/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.html;

import ch.qos.logback.classic.PatternLayout;
import ch.qos.logback.classic.html.DefaultCssBuilder;
import ch.qos.logback.classic.html.DefaultThrowableRenderer;
import ch.qos.logback.classic.pattern.MDCConverter;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.html.IThrowableRenderer;
import ch.qos.logback.core.pattern.Converter;
import java.util.Map;

public class HTMLLayout
extends HTMLLayoutBase<ILoggingEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%date%thread%level%logger%mdc%msg";
    IThrowableRenderer<ILoggingEvent> throwableRenderer;

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.throwableRenderer = new DefaultThrowableRenderer();
        this.cssBuilder = new DefaultCssBuilder();
    }

    @Override
    public void start() {
        int errorCount = 0;
        if (this.throwableRenderer == null) {
            this.addError("ThrowableRender cannot be null.");
            ++errorCount;
        }
        if (errorCount == 0) {
            super.start();
        }
    }

    @Override
    protected Map<String, String> getDefaultConverterMap() {
        return PatternLayout.defaultConverterMap;
    }

    @Override
    public String doLayout(ILoggingEvent event) {
        StringBuilder buf2 = new StringBuilder();
        this.startNewTableIfLimitReached(buf2);
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        String level = event.getLevel().toString().toLowerCase();
        buf2.append(CoreConstants.LINE_SEPARATOR);
        buf2.append("<tr class=\"");
        buf2.append(level);
        if (odd) {
            buf2.append(" odd\">");
        } else {
            buf2.append(" even\">");
        }
        buf2.append(CoreConstants.LINE_SEPARATOR);
        Converter c = this.head;
        while (c != null) {
            this.appendEventToBuffer(buf2, c, event);
            c = c.getNext();
        }
        buf2.append("</tr>");
        buf2.append(CoreConstants.LINE_SEPARATOR);
        if (event.getThrowableProxy() != null) {
            this.throwableRenderer.render(buf2, event);
        }
        return buf2.toString();
    }

    private void appendEventToBuffer(StringBuilder buf2, Converter<ILoggingEvent> c, ILoggingEvent event) {
        buf2.append("<td class=\"");
        buf2.append(this.computeConverterName(c));
        buf2.append("\">");
        buf2.append(Transform.escapeTags(c.convert(event)));
        buf2.append("</td>");
        buf2.append(CoreConstants.LINE_SEPARATOR);
    }

    public IThrowableRenderer getThrowableRenderer() {
        return this.throwableRenderer;
    }

    public void setThrowableRenderer(IThrowableRenderer<ILoggingEvent> throwableRenderer) {
        this.throwableRenderer = throwableRenderer;
    }

    @Override
    protected String computeConverterName(Converter c) {
        if (c instanceof MDCConverter) {
            MDCConverter mc = (MDCConverter)c;
            String key2 = mc.getFirstOption();
            if (key2 != null) {
                return key2;
            }
            return "MDC";
        }
        return super.computeConverterName(c);
    }
}

