/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.joran.action;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.net.SocketAppender;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import org.xml.sax.Attributes;

public class ConsolePluginAction
extends Action {
    private static final String PORT_ATTR = "port";
    private static final Integer DEFAULT_PORT = 4321;

    @Override
    public void begin(InterpretationContext ec, String name, Attributes attributes2) throws ActionException {
        String portStr = attributes2.getValue(PORT_ATTR);
        Integer port2 = null;
        if (portStr == null) {
            port2 = DEFAULT_PORT;
        } else {
            try {
                port2 = Integer.valueOf(portStr);
            }
            catch (NumberFormatException numberFormatException) {
                this.addError("Port " + portStr + " in ConsolePlugin config is not a correct number");
            }
        }
        LoggerContext lc = (LoggerContext)ec.getContext();
        SocketAppender appender = new SocketAppender();
        appender.setContext(lc);
        appender.setIncludeCallerData(true);
        appender.setRemoteHost("localhost");
        appender.setPort(port2);
        appender.start();
        Logger root = lc.getLogger("ROOT");
        root.addAppender(appender);
        this.addInfo("Sending LoggingEvents to the plugin using port " + port2);
    }

    @Override
    public void end(InterpretationContext ec, String name) throws ActionException {
    }
}

