/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.spi;

import ch.qos.logback.classic.spi.ClassPackagingData;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.StackTraceElementProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import ch.qos.logback.core.CoreConstants;

public class ThrowableProxyUtil {
    public static final int REGULAR_EXCEPTION_INDENT = 1;
    public static final int SUPPRESSED_EXCEPTION_INDENT = 1;
    private static final int BUILDER_CAPACITY = 2048;

    public static void build(ThrowableProxy nestedTP, Throwable nestedThrowable, ThrowableProxy parentTP) {
        StackTraceElement[] nestedSTE = nestedThrowable.getStackTrace();
        int commonFramesCount = -1;
        if (parentTP != null) {
            commonFramesCount = ThrowableProxyUtil.findNumberOfCommonFrames(nestedSTE, parentTP.getStackTraceElementProxyArray());
        }
        nestedTP.commonFrames = commonFramesCount;
        nestedTP.stackTraceElementProxyArray = ThrowableProxyUtil.steArrayToStepArray(nestedSTE);
    }

    static StackTraceElementProxy[] steArrayToStepArray(StackTraceElement[] stea) {
        if (stea == null) {
            return new StackTraceElementProxy[0];
        }
        StackTraceElementProxy[] stepa = new StackTraceElementProxy[stea.length];
        int i = 0;
        while (i < stepa.length) {
            stepa[i] = new StackTraceElementProxy(stea[i]);
            ++i;
        }
        return stepa;
    }

    static int findNumberOfCommonFrames(StackTraceElement[] steArray, StackTraceElementProxy[] parentSTEPArray) {
        if (parentSTEPArray == null || steArray == null) {
            return 0;
        }
        int steIndex = steArray.length - 1;
        int parentIndex = parentSTEPArray.length - 1;
        int count2 = 0;
        while (steIndex >= 0 && parentIndex >= 0) {
            StackTraceElement ste = steArray[steIndex];
            StackTraceElement otherSte = parentSTEPArray[parentIndex].ste;
            if (!ste.equals(otherSte)) break;
            ++count2;
            --steIndex;
            --parentIndex;
        }
        return count2;
    }

    public static String asString(IThrowableProxy tp) {
        StringBuilder sb = new StringBuilder(2048);
        ThrowableProxyUtil.recursiveAppend(sb, null, 1, tp);
        return sb.toString();
    }

    private static void recursiveAppend(StringBuilder sb, String prefix, int indent, IThrowableProxy tp) {
        if (tp == null) {
            return;
        }
        ThrowableProxyUtil.subjoinFirstLine(sb, prefix, indent, tp);
        sb.append(CoreConstants.LINE_SEPARATOR);
        ThrowableProxyUtil.subjoinSTEPArray(sb, indent, tp);
        IThrowableProxy[] suppressed = tp.getSuppressed();
        if (suppressed != null) {
            IThrowableProxy[] iThrowableProxyArray = suppressed;
            int n = suppressed.length;
            int n2 = 0;
            while (n2 < n) {
                IThrowableProxy current = iThrowableProxyArray[n2];
                ThrowableProxyUtil.recursiveAppend(sb, "Suppressed: ", indent + 1, current);
                ++n2;
            }
        }
        ThrowableProxyUtil.recursiveAppend(sb, "Caused by: ", indent, tp.getCause());
    }

    public static void indent(StringBuilder buf2, int indent) {
        int j2 = 0;
        while (j2 < indent) {
            buf2.append('\t');
            ++j2;
        }
    }

    private static void subjoinFirstLine(StringBuilder buf2, String prefix, int indent, IThrowableProxy tp) {
        ThrowableProxyUtil.indent(buf2, indent - 1);
        if (prefix != null) {
            buf2.append(prefix);
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf2, tp);
    }

    public static void subjoinPackagingData(StringBuilder builder, StackTraceElementProxy step) {
        ClassPackagingData cpd;
        if (step != null && (cpd = step.getClassPackagingData()) != null) {
            if (!cpd.isExact()) {
                builder.append(" ~[");
            } else {
                builder.append(" [");
            }
            builder.append(cpd.getCodeLocation()).append(':').append(cpd.getVersion()).append(']');
        }
    }

    public static void subjoinSTEP(StringBuilder sb, StackTraceElementProxy step) {
        sb.append(step.toString());
        ThrowableProxyUtil.subjoinPackagingData(sb, step);
    }

    public static void subjoinSTEPArray(StringBuilder sb, IThrowableProxy tp) {
        ThrowableProxyUtil.subjoinSTEPArray(sb, 1, tp);
    }

    public static void subjoinSTEPArray(StringBuilder sb, int indentLevel, IThrowableProxy tp) {
        StackTraceElementProxy[] stepArray = tp.getStackTraceElementProxyArray();
        int commonFrames = tp.getCommonFrames();
        int i = 0;
        while (i < stepArray.length - commonFrames) {
            StackTraceElementProxy step = stepArray[i];
            ThrowableProxyUtil.indent(sb, indentLevel);
            ThrowableProxyUtil.subjoinSTEP(sb, step);
            sb.append(CoreConstants.LINE_SEPARATOR);
            ++i;
        }
        if (commonFrames > 0) {
            ThrowableProxyUtil.indent(sb, indentLevel);
            sb.append("... ").append(commonFrames).append(" common frames omitted").append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void subjoinFirstLine(StringBuilder buf2, IThrowableProxy tp) {
        int commonFrames = tp.getCommonFrames();
        if (commonFrames > 0) {
            buf2.append("Caused by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf2, tp);
    }

    public static void subjoinFirstLineRootCauseFirst(StringBuilder buf2, IThrowableProxy tp) {
        if (tp.getCause() != null) {
            buf2.append("Wrapped by: ");
        }
        ThrowableProxyUtil.subjoinExceptionMessage(buf2, tp);
    }

    private static void subjoinExceptionMessage(StringBuilder buf2, IThrowableProxy tp) {
        buf2.append(tp.getClassName()).append(": ").append(tp.getMessage());
    }
}

