/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.helpers;

import java.util.regex.Pattern;

public class Transform {
    private static final String CDATA_START = "<![CDATA[";
    private static final String CDATA_END = "]]>";
    private static final String CDATA_PSEUDO_END = "]]&gt;";
    private static final String CDATA_EMBEDED_END = "]]>]]&gt;<![CDATA[";
    private static final int CDATA_END_LEN = "]]>".length();
    private static final Pattern UNSAFE_XML_CHARS = Pattern.compile("[\u0000-\b\u000b\f\u000e-\u001f<>&'\"]");

    public static String escapeTags(String input2) {
        if (input2 == null || input2.length() == 0 || !UNSAFE_XML_CHARS.matcher(input2).find()) {
            return input2;
        }
        StringBuffer buf2 = new StringBuffer(input2);
        return Transform.escapeTags(buf2);
    }

    public static String escapeTags(StringBuffer buf2) {
        block8: for (int i = 0; i < buf2.length(); ++i) {
            char ch2 = buf2.charAt(i);
            switch (ch2) {
                case '\t': 
                case '\n': 
                case '\r': {
                    continue block8;
                }
                case '&': {
                    buf2.replace(i, i + 1, "&amp;");
                    continue block8;
                }
                case '<': {
                    buf2.replace(i, i + 1, "&lt;");
                    continue block8;
                }
                case '>': {
                    buf2.replace(i, i + 1, "&gt;");
                    continue block8;
                }
                case '\"': {
                    buf2.replace(i, i + 1, "&quot;");
                    continue block8;
                }
                case '\'': {
                    buf2.replace(i, i + 1, "&#39;");
                    continue block8;
                }
                default: {
                    if (ch2 >= ' ') continue block8;
                    buf2.replace(i, i + 1, "\ufffd");
                }
            }
        }
        return buf2.toString();
    }

    public static void appendEscapingCDATA(StringBuilder output2, String str) {
        if (str == null) {
            return;
        }
        int end2 = str.indexOf(CDATA_END);
        if (end2 < 0) {
            output2.append(str);
            return;
        }
        int start = 0;
        while (end2 > -1) {
            output2.append(str.substring(start, end2));
            output2.append(CDATA_EMBEDED_END);
            start = end2 + CDATA_END_LEN;
            if (start < str.length()) {
                end2 = str.indexOf(CDATA_END, start);
                continue;
            }
            return;
        }
        output2.append(str.substring(start));
    }
}

