/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.pattern.parser;

import ch.qos.logback.core.pattern.parser.OptionTokenizer;
import ch.qos.logback.core.pattern.parser.Token;
import ch.qos.logback.core.pattern.util.IEscapeUtil;
import ch.qos.logback.core.pattern.util.RegularEscapeUtil;
import ch.qos.logback.core.pattern.util.RestrictedEscapeUtil;
import ch.qos.logback.core.spi.ScanException;
import java.util.ArrayList;
import java.util.List;

class TokenStream {
    final String pattern;
    final int patternLength;
    final IEscapeUtil escapeUtil;
    final IEscapeUtil optionEscapeUtil = new RestrictedEscapeUtil();
    TokenizerState state = TokenizerState.LITERAL_STATE;
    int pointer = 0;

    TokenStream(String pattern) {
        this(pattern, new RegularEscapeUtil());
    }

    TokenStream(String pattern, IEscapeUtil escapeUtil) {
        if (pattern == null || pattern.length() == 0) {
            throw new IllegalArgumentException("null or empty pattern string not allowed");
        }
        this.pattern = pattern;
        this.patternLength = pattern.length();
        this.escapeUtil = escapeUtil;
    }

    List tokenize() throws ScanException {
        ArrayList<Token> tokenList = new ArrayList<Token>();
        StringBuffer buf2 = new StringBuffer();
        while (this.pointer < this.patternLength) {
            char c = this.pattern.charAt(this.pointer);
            ++this.pointer;
            switch (this.state) {
                case LITERAL_STATE: {
                    this.handleLiteralState(c, tokenList, buf2);
                    break;
                }
                case FORMAT_MODIFIER_STATE: {
                    this.handleFormatModifierState(c, tokenList, buf2);
                    break;
                }
                case OPTION_STATE: {
                    this.processOption(c, tokenList, buf2);
                    break;
                }
                case KEYWORD_STATE: {
                    this.handleKeywordState(c, tokenList, buf2);
                    break;
                }
                case RIGHT_PARENTHESIS_STATE: {
                    this.handleRightParenthesisState(c, tokenList, buf2);
                    break;
                }
            }
        }
        switch (this.state) {
            case LITERAL_STATE: {
                this.addValuedToken(1000, buf2, tokenList);
                break;
            }
            case KEYWORD_STATE: {
                tokenList.add(new Token(1004, buf2.toString()));
                break;
            }
            case RIGHT_PARENTHESIS_STATE: {
                tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
                break;
            }
            case FORMAT_MODIFIER_STATE: 
            case OPTION_STATE: {
                throw new ScanException("Unexpected end of pattern string");
            }
        }
        return tokenList;
    }

    private void handleRightParenthesisState(char c, List<Token> tokenList, StringBuffer buf2) {
        tokenList.add(Token.RIGHT_PARENTHESIS_TOKEN);
        switch (c) {
            case ')': {
                break;
            }
            case '{': {
                this.state = TokenizerState.OPTION_STATE;
                break;
            }
            case '\\': {
                this.escape("%{}", buf2);
                this.state = TokenizerState.LITERAL_STATE;
                break;
            }
            default: {
                buf2.append(c);
                this.state = TokenizerState.LITERAL_STATE;
            }
        }
    }

    private void processOption(char c, List<Token> tokenList, StringBuffer buf2) throws ScanException {
        OptionTokenizer ot = new OptionTokenizer(this);
        ot.tokenize(c, tokenList);
    }

    private void handleFormatModifierState(char c, List<Token> tokenList, StringBuffer buf2) {
        if (c == '(') {
            this.addValuedToken(1002, buf2, tokenList);
            tokenList.add(Token.BARE_COMPOSITE_KEYWORD_TOKEN);
            this.state = TokenizerState.LITERAL_STATE;
        } else if (Character.isJavaIdentifierStart(c)) {
            this.addValuedToken(1002, buf2, tokenList);
            this.state = TokenizerState.KEYWORD_STATE;
            buf2.append(c);
        } else {
            buf2.append(c);
        }
    }

    private void handleLiteralState(char c, List<Token> tokenList, StringBuffer buf2) {
        switch (c) {
            case '\\': {
                this.escape("%()", buf2);
                break;
            }
            case '%': {
                this.addValuedToken(1000, buf2, tokenList);
                tokenList.add(Token.PERCENT_TOKEN);
                this.state = TokenizerState.FORMAT_MODIFIER_STATE;
                break;
            }
            case ')': {
                this.addValuedToken(1000, buf2, tokenList);
                this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
                break;
            }
            default: {
                buf2.append(c);
            }
        }
    }

    private void handleKeywordState(char c, List<Token> tokenList, StringBuffer buf2) {
        if (Character.isJavaIdentifierPart(c)) {
            buf2.append(c);
        } else if (c == '{') {
            this.addValuedToken(1004, buf2, tokenList);
            this.state = TokenizerState.OPTION_STATE;
        } else if (c == '(') {
            this.addValuedToken(1005, buf2, tokenList);
            this.state = TokenizerState.LITERAL_STATE;
        } else if (c == '%') {
            this.addValuedToken(1004, buf2, tokenList);
            tokenList.add(Token.PERCENT_TOKEN);
            this.state = TokenizerState.FORMAT_MODIFIER_STATE;
        } else if (c == ')') {
            this.addValuedToken(1004, buf2, tokenList);
            this.state = TokenizerState.RIGHT_PARENTHESIS_STATE;
        } else {
            this.addValuedToken(1004, buf2, tokenList);
            if (c == '\\') {
                if (this.pointer < this.patternLength) {
                    char next = this.pattern.charAt(this.pointer++);
                    this.escapeUtil.escape("%()", buf2, next, this.pointer);
                }
            } else {
                buf2.append(c);
            }
            this.state = TokenizerState.LITERAL_STATE;
        }
    }

    void escape(String escapeChars, StringBuffer buf2) {
        if (this.pointer < this.patternLength) {
            char next = this.pattern.charAt(this.pointer++);
            this.escapeUtil.escape(escapeChars, buf2, next, this.pointer);
        }
    }

    void optionEscape(String escapeChars, StringBuffer buf2) {
        if (this.pointer < this.patternLength) {
            char next = this.pattern.charAt(this.pointer++);
            this.optionEscapeUtil.escape(escapeChars, buf2, next, this.pointer);
        }
    }

    private void addValuedToken(int type2, StringBuffer buf2, List<Token> tokenList) {
        if (buf2.length() > 0) {
            tokenList.add(new Token(type2, buf2.toString()));
            buf2.setLength(0);
        }
    }

    static enum TokenizerState {
        LITERAL_STATE,
        FORMAT_MODIFIER_STATE,
        KEYWORD_STATE,
        OPTION_STATE,
        RIGHT_PARENTHESIS_STATE;

    }
}

