/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.status;

import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.helpers.Transform;
import ch.qos.logback.core.status.InfoStatus;
import ch.qos.logback.core.status.Status;
import ch.qos.logback.core.status.StatusManager;
import ch.qos.logback.core.util.CachingDateFormatter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class ViewStatusMessagesServletBase
extends HttpServlet {
    private static final long serialVersionUID = -3551928133801157219L;
    private static CachingDateFormatter SDF = new CachingDateFormatter("yyyy-MM-dd HH:mm:ss");
    static String SUBMIT = "submit";
    static String CLEAR = "Clear";
    int count;

    protected abstract StatusManager getStatusManager(HttpServletRequest var1, HttpServletResponse var2);

    protected abstract String getPageTitle(HttpServletRequest var1, HttpServletResponse var2);

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.count = 0;
        StatusManager sm = this.getStatusManager(req, resp);
        resp.setContentType("text/html");
        PrintWriter output2 = resp.getWriter();
        output2.append("<html>\r\n");
        output2.append("<head>\r\n");
        this.printCSS(req.getContextPath(), output2);
        output2.append("</head>\r\n");
        output2.append("<body>\r\n");
        output2.append(this.getPageTitle(req, resp));
        output2.append("<form method=\"POST\">\r\n");
        output2.append("<input type=\"submit\" name=\"" + SUBMIT + "\" value=\"" + CLEAR + "\">");
        output2.append("</form>\r\n");
        if (CLEAR.equalsIgnoreCase(req.getParameter(SUBMIT))) {
            sm.clear();
            sm.add(new InfoStatus("Cleared all status messages", (Object)this));
        }
        output2.append("<table>");
        StringBuilder buf2 = new StringBuilder();
        if (sm != null) {
            this.printList(buf2, sm);
        } else {
            output2.append("Could not find status manager");
        }
        output2.append(buf2);
        output2.append("</table>");
        output2.append("</body>\r\n");
        output2.append("</html>\r\n");
        output2.flush();
        output2.close();
    }

    public void printCSS(String localRef, PrintWriter output2) {
        output2.append("  <STYLE TYPE=\"text/css\">\r\n");
        output2.append("    .warn  { font-weight: bold; color: #FF6600;} \r\n");
        output2.append("    .error { font-weight: bold; color: #CC0000;} \r\n");
        output2.append("    table { margin-left: 2em; margin-right: 2em; border-left: 2px solid #AAA; }\r\n");
        output2.append("    tr.even { background: #FFFFFF; }\r\n");
        output2.append("    tr.odd  { background: #EAEAEA; }\r\n");
        output2.append("    td { padding-right: 1ex; padding-left: 1ex; border-right: 2px solid #AAA; }\r\n");
        output2.append("    td.date { text-align: right; font-family: courier, monospace; font-size: smaller; }");
        output2.append(CoreConstants.LINE_SEPARATOR);
        output2.append("  td.level { text-align: right; }");
        output2.append(CoreConstants.LINE_SEPARATOR);
        output2.append("    tr.header { background: #596ED5; color: #FFF; font-weight: bold; font-size: larger; }");
        output2.append(CoreConstants.LINE_SEPARATOR);
        output2.append("  td.exception { background: #A2AEE8; white-space: pre; font-family: courier, monospace;}");
        output2.append(CoreConstants.LINE_SEPARATOR);
        output2.append("  </STYLE>\r\n");
    }

    public void printList(StringBuilder buf2, StatusManager sm) {
        buf2.append("<table>\r\n");
        this.printHeader(buf2);
        List<Status> statusList = sm.getCopyOfStatusList();
        for (Status s2 : statusList) {
            ++this.count;
            this.printStatus(buf2, s2);
        }
        buf2.append("</table>\r\n");
    }

    public void printHeader(StringBuilder buf2) {
        buf2.append("  <tr class=\"header\">\r\n");
        buf2.append("    <th>Date </th>\r\n");
        buf2.append("    <th>Level</th>\r\n");
        buf2.append("    <th>Origin</th>\r\n");
        buf2.append("    <th>Message</th>\r\n");
        buf2.append("  </tr>\r\n");
    }

    String statusLevelAsString(Status s2) {
        switch (s2.getEffectiveLevel()) {
            case 0: {
                return "INFO";
            }
            case 1: {
                return "<span class=\"warn\">WARN</span>";
            }
            case 2: {
                return "<span class=\"error\">ERROR</span>";
            }
        }
        return null;
    }

    String abbreviatedOrigin(Status s2) {
        Object o = s2.getOrigin();
        if (o == null) {
            return null;
        }
        String fqClassName = o.getClass().getName();
        int lastIndex = fqClassName.lastIndexOf(46);
        if (lastIndex != -1) {
            return fqClassName.substring(lastIndex + 1, fqClassName.length());
        }
        return fqClassName;
    }

    private void printStatus(StringBuilder buf2, Status s2) {
        String trClass = this.count % 2 == 0 ? "even" : "odd";
        buf2.append("  <tr class=\"").append(trClass).append("\">\r\n");
        String dateStr = SDF.format(s2.getDate());
        buf2.append("    <td class=\"date\">").append(dateStr).append("</td>\r\n");
        buf2.append("    <td class=\"level\">").append(this.statusLevelAsString(s2)).append("</td>\r\n");
        buf2.append("    <td>").append(this.abbreviatedOrigin(s2)).append("</td>\r\n");
        buf2.append("    <td>").append(s2.getMessage()).append("</td>\r\n");
        buf2.append("  </tr>\r\n");
        if (s2.getThrowable() != null) {
            this.printThrowable(buf2, s2.getThrowable());
        }
    }

    private void printThrowable(StringBuilder buf2, Throwable t) {
        buf2.append("  <tr>\r\n");
        buf2.append("    <td colspan=\"4\" class=\"exception\"><pre>");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        buf2.append(Transform.escapeTags(sw.getBuffer()));
        buf2.append("    </pre></td>\r\n");
        buf2.append("  </tr>\r\n");
    }
}

