/*
 * Decompiled with CFR 0.152.
 */
package com.apurebase.kgraphql.schema.scalar;

import com.apurebase.kgraphql.ExecutionException;
import com.apurebase.kgraphql.ExtensionsKt;
import com.apurebase.kgraphql.GraphQLError;
import com.apurebase.kgraphql.schema.builtin.BOOLEAN_COERCION;
import com.apurebase.kgraphql.schema.builtin.DOUBLE_COERCION;
import com.apurebase.kgraphql.schema.builtin.FLOAT_COERCION;
import com.apurebase.kgraphql.schema.builtin.INT_COERCION;
import com.apurebase.kgraphql.schema.builtin.LONG_COERCION;
import com.apurebase.kgraphql.schema.builtin.SHORT_COERCION;
import com.apurebase.kgraphql.schema.builtin.STRING_COERCION;
import com.apurebase.kgraphql.schema.execution.Execution;
import com.apurebase.kgraphql.schema.model.ast.ValueNode;
import com.apurebase.kgraphql.schema.scalar.BooleanScalarCoercion;
import com.apurebase.kgraphql.schema.scalar.DoubleScalarCoercion;
import com.apurebase.kgraphql.schema.scalar.IntScalarCoercion;
import com.apurebase.kgraphql.schema.scalar.LongScalarCoercion;
import com.apurebase.kgraphql.schema.scalar.ScalarCoercion;
import com.apurebase.kgraphql.schema.scalar.ShortScalarCoercion;
import com.apurebase.kgraphql.schema.scalar.StringScalarCoercion;
import com.apurebase.kgraphql.schema.structure.Type;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NumericNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u00006\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a+\u0010\u0000\u001a\u0002H\u0001\"\b\b\u0000\u0010\u0001*\u00020\u00022\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a-\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\u00012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u0002H\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\f\u001a9\u0010\b\u001a\u00060\rj\u0002`\u000e\"\u0004\b\u0000\u0010\u00012\u0006\u0010\u000f\u001a\u00020\u00102\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0005\u001a\u0002H\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\u0011*\f\b\u0002\u0010\u0012\"\u00020\r2\u00020\r\u00a8\u0006\u0013"}, d2={"deserializeScalar", "T", "", "scalar", "Lcom/apurebase/kgraphql/schema/structure/Type$Scalar;", "value", "Lcom/apurebase/kgraphql/schema/model/ast/ValueNode;", "(Lcom/apurebase/kgraphql/schema/structure/Type$Scalar;Lcom/apurebase/kgraphql/schema/model/ast/ValueNode;)Ljava/lang/Object;", "serializeScalar", "Lkotlinx/serialization/json/JsonElement;", "executionNode", "Lcom/apurebase/kgraphql/schema/execution/Execution;", "(Lcom/apurebase/kgraphql/schema/structure/Type$Scalar;Ljava/lang/Object;Lcom/apurebase/kgraphql/schema/execution/Execution;)Lkotlinx/serialization/json/JsonElement;", "Lcom/fasterxml/jackson/databind/node/ValueNode;", "Lcom/apurebase/kgraphql/schema/scalar/JsonValueNode;", "jsonNodeFactory", "Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;", "(Lcom/fasterxml/jackson/databind/node/JsonNodeFactory;Lcom/apurebase/kgraphql/schema/structure/Type$Scalar;Ljava/lang/Object;Lcom/apurebase/kgraphql/schema/execution/Execution;)Lcom/fasterxml/jackson/databind/node/ValueNode;", "JsonValueNode", "kgraphql"})
public final class CoercionKt {
    @NotNull
    public static final <T> T deserializeScalar(@NotNull Type.Scalar<T> scalar, @NotNull com.apurebase.kgraphql.schema.model.ast.ValueNode value) {
        Intrinsics.checkNotNullParameter(scalar, "scalar");
        Intrinsics.checkNotNullParameter(value, "value");
        try {
            Object object;
            ScalarCoercion<T, ?> scalarCoercion = scalar.getCoercion();
            if (Intrinsics.areEqual(scalarCoercion, STRING_COERCION.INSTANCE)) {
                object = STRING_COERCION.INSTANCE.deserialize(value.getValueNodeName(), (com.apurebase.kgraphql.schema.model.ast.ValueNode)((ValueNode.StringValueNode)value));
            } else if (Intrinsics.areEqual(scalarCoercion, FLOAT_COERCION.INSTANCE)) {
                object = FLOAT_COERCION.INSTANCE.deserialize(value.getValueNodeName(), value);
            } else if (Intrinsics.areEqual(scalarCoercion, DOUBLE_COERCION.INSTANCE)) {
                object = DOUBLE_COERCION.INSTANCE.deserialize(value.getValueNodeName(), value);
            } else if (Intrinsics.areEqual(scalarCoercion, SHORT_COERCION.INSTANCE)) {
                object = SHORT_COERCION.INSTANCE.deserialize(value.getValueNodeName(), value);
            } else if (Intrinsics.areEqual(scalarCoercion, INT_COERCION.INSTANCE)) {
                object = INT_COERCION.INSTANCE.deserialize(value.getValueNodeName(), value);
            } else if (Intrinsics.areEqual(scalarCoercion, BOOLEAN_COERCION.INSTANCE)) {
                object = BOOLEAN_COERCION.INSTANCE.deserialize(value.getValueNodeName(), value);
            } else if (Intrinsics.areEqual(scalarCoercion, LONG_COERCION.INSTANCE)) {
                object = LONG_COERCION.INSTANCE.deserialize(value.getValueNodeName(), value);
            } else if (scalarCoercion instanceof StringScalarCoercion) {
                object = ((StringScalarCoercion)scalar.getCoercion()).deserialize(ExtensionsKt.dropQuotes(value.getValueNodeName()), value);
            } else if (scalarCoercion instanceof ShortScalarCoercion) {
                String string = value.getValueNodeName();
                boolean bl = false;
                object = ((ShortScalarCoercion)scalar.getCoercion()).deserialize(Short.parseShort(string), value);
            } else if (scalarCoercion instanceof IntScalarCoercion) {
                String string = value.getValueNodeName();
                boolean bl = false;
                object = ((IntScalarCoercion)scalar.getCoercion()).deserialize(Integer.parseInt(string), value);
            } else if (scalarCoercion instanceof DoubleScalarCoercion) {
                String string = value.getValueNodeName();
                boolean bl = false;
                object = ((DoubleScalarCoercion)scalar.getCoercion()).deserialize(Double.parseDouble(string), value);
            } else if (scalarCoercion instanceof BooleanScalarCoercion) {
                String string = value.getValueNodeName();
                boolean bl = false;
                object = ((BooleanScalarCoercion)scalar.getCoercion()).deserialize(Boolean.parseBoolean(string), value);
            } else if (scalarCoercion instanceof LongScalarCoercion) {
                String string = value.getValueNodeName();
                boolean bl = false;
                object = ((LongScalarCoercion)scalar.getCoercion()).deserialize(Long.parseLong(string), value);
            } else {
                throw new GraphQLError(Intrinsics.stringPlus("Unsupported coercion for scalar type ", scalar.getName()), value);
            }
            return (T)object;
        }
        catch (Exception e) {
            throw e instanceof GraphQLError ? (Throwable)e : (Throwable)new GraphQLError("argument '" + value.getValueNodeName() + "' is not valid value of type " + scalar.getName(), CollectionsKt.listOf(value), null, null, e, 12, null);
        }
    }

    @NotNull
    public static final <T> ValueNode serializeScalar(@NotNull JsonNodeFactory jsonNodeFactory, @NotNull Type.Scalar<?> scalar, T value, @NotNull Execution executionNode) {
        ValueNode valueNode;
        Intrinsics.checkNotNullParameter(jsonNodeFactory, "jsonNodeFactory");
        Intrinsics.checkNotNullParameter(scalar, "scalar");
        Intrinsics.checkNotNullParameter(executionNode, "executionNode");
        ScalarCoercion<?, ?> scalarCoercion = scalar.getCoercion();
        if (scalarCoercion instanceof StringScalarCoercion) {
            TextNode textNode = jsonNodeFactory.textNode((String)((StringScalarCoercion)scalar.getCoercion()).serialize(value));
            Intrinsics.checkNotNullExpressionValue(textNode, "{\n        jsonNodeFactory.textNode((scalar.coercion as StringScalarCoercion<T>).serialize(value))\n    }");
            valueNode = textNode;
        } else if (scalarCoercion instanceof ShortScalarCoercion) {
            NumericNode numericNode = jsonNodeFactory.numberNode(((Number)((ShortScalarCoercion)scalar.getCoercion()).serialize(value)).shortValue());
            Intrinsics.checkNotNullExpressionValue(numericNode, "{\n        jsonNodeFactory.numberNode((scalar.coercion as ShortScalarCoercion<T>).serialize(value))\n    }");
            valueNode = numericNode;
        } else if (scalarCoercion instanceof IntScalarCoercion) {
            NumericNode numericNode = jsonNodeFactory.numberNode(((Number)((IntScalarCoercion)scalar.getCoercion()).serialize(value)).intValue());
            Intrinsics.checkNotNullExpressionValue(numericNode, "{\n        jsonNodeFactory.numberNode((scalar.coercion as IntScalarCoercion<T>).serialize(value))\n    }");
            valueNode = numericNode;
        } else if (scalarCoercion instanceof DoubleScalarCoercion) {
            NumericNode numericNode = jsonNodeFactory.numberNode(((Number)((DoubleScalarCoercion)scalar.getCoercion()).serialize(value)).doubleValue());
            Intrinsics.checkNotNullExpressionValue(numericNode, "{\n        jsonNodeFactory.numberNode((scalar.coercion as DoubleScalarCoercion<T>).serialize(value))\n    }");
            valueNode = numericNode;
        } else if (scalarCoercion instanceof LongScalarCoercion) {
            NumericNode numericNode = jsonNodeFactory.numberNode(((Number)((LongScalarCoercion)scalar.getCoercion()).serialize(value)).longValue());
            Intrinsics.checkNotNullExpressionValue(numericNode, "{\n        jsonNodeFactory.numberNode((scalar.coercion as LongScalarCoercion<T>).serialize(value))\n    }");
            valueNode = numericNode;
        } else if (scalarCoercion instanceof BooleanScalarCoercion) {
            BooleanNode booleanNode = jsonNodeFactory.booleanNode((Boolean)((BooleanScalarCoercion)scalar.getCoercion()).serialize(value));
            Intrinsics.checkNotNullExpressionValue(booleanNode, "{\n        jsonNodeFactory.booleanNode((scalar.coercion as BooleanScalarCoercion<T>).serialize(value))\n    }");
            valueNode = booleanNode;
        } else {
            throw new ExecutionException(Intrinsics.stringPlus("Unsupported coercion for scalar type ", scalar.getName()), executionNode, null, 4, null);
        }
        return valueNode;
    }

    @NotNull
    public static final <T> JsonElement serializeScalar(@NotNull Type.Scalar<?> scalar, T value, @NotNull Execution executionNode) {
        JsonElement jsonElement;
        Intrinsics.checkNotNullParameter(scalar, "scalar");
        Intrinsics.checkNotNullParameter(executionNode, "executionNode");
        ScalarCoercion<?, ?> scalarCoercion = scalar.getCoercion();
        if (scalarCoercion instanceof StringScalarCoercion) {
            jsonElement = JsonElementKt.JsonPrimitive((String)((StringScalarCoercion)scalar.getCoercion()).serialize(value));
        } else if (scalarCoercion instanceof ShortScalarCoercion) {
            jsonElement = JsonElementKt.JsonPrimitive((Number)((ShortScalarCoercion)scalar.getCoercion()).serialize(value));
        } else if (scalarCoercion instanceof IntScalarCoercion) {
            jsonElement = JsonElementKt.JsonPrimitive((Number)((IntScalarCoercion)scalar.getCoercion()).serialize(value));
        } else if (scalarCoercion instanceof DoubleScalarCoercion) {
            jsonElement = JsonElementKt.JsonPrimitive((Number)((DoubleScalarCoercion)scalar.getCoercion()).serialize(value));
        } else if (scalarCoercion instanceof LongScalarCoercion) {
            jsonElement = JsonElementKt.JsonPrimitive((Number)((LongScalarCoercion)scalar.getCoercion()).serialize(value));
        } else if (scalarCoercion instanceof BooleanScalarCoercion) {
            jsonElement = JsonElementKt.JsonPrimitive((Boolean)((BooleanScalarCoercion)scalar.getCoercion()).serialize(value));
        } else {
            throw new ExecutionException(Intrinsics.stringPlus("Unsupported coercion for scalar type ", scalar.getName()), executionNode, null, 4, null);
        }
        return jsonElement;
    }
}

