/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.algorithms;

import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.algorithms.CryptoHelper;
import com.auth0.jwt.exceptions.SignatureGenerationException;
import com.auth0.jwt.exceptions.SignatureVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.auth0.jwt.interfaces.RSAKeyProvider;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;

class RSAAlgorithm
extends Algorithm {
    private final RSAKeyProvider keyProvider;
    private final CryptoHelper crypto;

    RSAAlgorithm(CryptoHelper crypto, String id2, String algorithm, RSAKeyProvider keyProvider) throws IllegalArgumentException {
        super(id2, algorithm);
        if (keyProvider == null) {
            throw new IllegalArgumentException("The Key Provider cannot be null.");
        }
        this.keyProvider = keyProvider;
        this.crypto = crypto;
    }

    RSAAlgorithm(String id2, String algorithm, RSAKeyProvider keyProvider) throws IllegalArgumentException {
        this(new CryptoHelper(), id2, algorithm, keyProvider);
    }

    @Override
    public void verify(DecodedJWT jwt) throws SignatureVerificationException {
        try {
            byte[] signatureBytes = Base64.getUrlDecoder().decode(jwt.getSignature());
            RSAPublicKey publicKey = (RSAPublicKey)this.keyProvider.getPublicKeyById(jwt.getKeyId());
            if (publicKey == null) {
                throw new IllegalStateException("The given Public Key is null.");
            }
            boolean valid = this.crypto.verifySignatureFor(this.getDescription(), (PublicKey)publicKey, jwt.getHeader(), jwt.getPayload(), signatureBytes);
            if (!valid) {
                throw new SignatureVerificationException(this);
            }
        }
        catch (IllegalArgumentException | IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureVerificationException(this, (Throwable)e);
        }
    }

    @Override
    @Deprecated
    public byte[] sign(byte[] headerBytes, byte[] payloadBytes) throws SignatureGenerationException {
        try {
            RSAPrivateKey privateKey = (RSAPrivateKey)this.keyProvider.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), privateKey, headerBytes, payloadBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public byte[] sign(byte[] contentBytes) throws SignatureGenerationException {
        try {
            RSAPrivateKey privateKey = (RSAPrivateKey)this.keyProvider.getPrivateKey();
            if (privateKey == null) {
                throw new IllegalStateException("The given Private Key is null.");
            }
            return this.crypto.createSignatureFor(this.getDescription(), privateKey, contentBytes);
        }
        catch (IllegalStateException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new SignatureGenerationException(this, (Throwable)e);
        }
    }

    @Override
    public String getSigningKeyId() {
        return this.keyProvider.getPrivateKeyId();
    }

    static RSAKeyProvider providerForKeys(final RSAPublicKey publicKey, final RSAPrivateKey privateKey) {
        if (publicKey == null && privateKey == null) {
            throw new IllegalArgumentException("Both provided Keys cannot be null.");
        }
        return new RSAKeyProvider(){

            @Override
            public RSAPublicKey getPublicKeyById(String keyId) {
                return publicKey;
            }

            @Override
            public RSAPrivateKey getPrivateKey() {
                return privateKey;
            }

            @Override
            public String getPrivateKeyId() {
                return null;
            }
        };
    }
}

