/*
 * Decompiled with CFR 0.152.
 */
package com.auth0.jwt.impl;

import com.auth0.jwt.impl.JsonNodeClaim;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.Header;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class BasicHeader
implements Header,
Serializable {
    private static final long serialVersionUID = -4659137688548605095L;
    private final String algorithm;
    private final String type;
    private final String contentType;
    private final String keyId;
    private final Map<String, JsonNode> tree;
    private final ObjectReader objectReader;

    BasicHeader(String algorithm, String type2, String contentType2, String keyId, Map<String, JsonNode> tree, ObjectReader objectReader) {
        this.algorithm = algorithm;
        this.type = type2;
        this.contentType = contentType2;
        this.keyId = keyId;
        this.tree = Collections.unmodifiableMap(tree == null ? new HashMap() : tree);
        this.objectReader = objectReader;
    }

    Map<String, JsonNode> getTree() {
        return this.tree;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    @Override
    public String getKeyId() {
        return this.keyId;
    }

    @Override
    public Claim getHeaderClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree, this.objectReader);
    }
}

