/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.io;

import com.ctc.wstx.api.ReaderConfig;
import com.ctc.wstx.io.BaseReader;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;

public final class UTF32Reader
extends BaseReader {
    protected final boolean mBigEndian;
    protected boolean mXml11;
    protected char mSurrogate = '\u0000';
    protected int mCharCount = 0;
    protected int mByteCount = 0;

    public UTF32Reader(ReaderConfig cfg, InputStream in, byte[] buf2, int ptr, int len, boolean recycleBuffer, boolean isBigEndian) {
        super(cfg, in, buf2, ptr, len, recycleBuffer);
        this.mBigEndian = isBigEndian;
    }

    @Override
    public void setXmlCompliancy(int xmlVersion) {
        this.mXml11 = xmlVersion == 272;
    }

    @Override
    public int read(char[] cbuf, int start, int len) throws IOException {
        if (start < 0 || start + len > cbuf.length) {
            this.reportBounds(cbuf, start, len);
        }
        if (this.mByteBuffer == null) {
            return -1;
        }
        if (len < 1) {
            return 0;
        }
        len += start;
        int outPtr = start;
        if (this.mSurrogate != '\u0000') {
            cbuf[outPtr++] = this.mSurrogate;
            this.mSurrogate = '\u0000';
        } else {
            int left = this.mByteBufferEnd - this.mBytePtr;
            if (left < 4 && !this.loadMore(left)) {
                if (left == 0) {
                    return -1;
                }
                this.reportUnexpectedEOF(this.mByteBufferEnd - this.mBytePtr, 4);
            }
        }
        byte[] buf2 = this.mByteBuffer;
        int lastValidInputStart = this.mByteBufferEnd - 4;
        while (outPtr < len) {
            int ptr = this.mBytePtr;
            if (this.mBytePtr > lastValidInputStart) break;
            int ch2 = this.mBigEndian ? buf2[ptr] << 24 | (buf2[ptr + 1] & 0xFF) << 16 | (buf2[ptr + 2] & 0xFF) << 8 | buf2[ptr + 3] & 0xFF : buf2[ptr] & 0xFF | (buf2[ptr + 1] & 0xFF) << 8 | (buf2[ptr + 2] & 0xFF) << 16 | buf2[ptr + 3] << 24;
            this.mBytePtr += 4;
            if (ch2 >= 127) {
                if (ch2 <= 159) {
                    if (this.mXml11) {
                        if (ch2 != 133) {
                            this.reportInvalid(ch2, outPtr - start, "(can only be included via entity in xml 1.1)");
                        }
                        ch2 = 10;
                    }
                } else if (ch2 >= 55296) {
                    if (ch2 > 0x10FFFF) {
                        this.reportInvalid(ch2, outPtr - start, "(above " + Integer.toHexString(0x10FFFF) + ") ");
                    }
                    if (ch2 > 65535) {
                        cbuf[outPtr++] = (char)(55296 + ((ch2 -= 65536) >> 10));
                        ch2 = 0xDC00 | ch2 & 0x3FF;
                        if (outPtr >= len) {
                            this.mSurrogate = (char)ch2;
                            break;
                        }
                    } else if (ch2 < 57344) {
                        this.reportInvalid(ch2, outPtr - start, "(a surrogate char) ");
                    } else if (ch2 >= 65534) {
                        this.reportInvalid(ch2, outPtr - start, "");
                    }
                } else if (ch2 == 8232 && this.mXml11) {
                    ch2 = 10;
                }
            }
            cbuf[outPtr++] = (char)ch2;
        }
        len = outPtr - start;
        this.mCharCount += len;
        return len;
    }

    private void reportUnexpectedEOF(int gotBytes, int needed) throws IOException {
        int bytePos = this.mByteCount + gotBytes;
        int charPos = this.mCharCount;
        throw new CharConversionException("Unexpected EOF in the middle of a 4-byte UTF-32 char: got " + gotBytes + ", needed " + needed + ", at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private void reportInvalid(int value, int offset, String msg) throws IOException {
        int bytePos = this.mByteCount + this.mBytePtr - 1;
        int charPos = this.mCharCount + offset;
        throw new CharConversionException("Invalid UTF-32 character 0x" + Integer.toHexString(value) + msg + " at char #" + charPos + ", byte #" + bytePos + ")");
    }

    private boolean loadMore(int available) throws IOException {
        int count2;
        this.mByteCount += this.mByteBufferEnd - available;
        if (available > 0) {
            if (this.mBytePtr > 0 && this.canModifyBuffer()) {
                for (int i = 0; i < available; ++i) {
                    this.mByteBuffer[i] = this.mByteBuffer[this.mBytePtr + i];
                }
                this.mBytePtr = 0;
                this.mByteBufferEnd = available;
            }
        } else {
            count2 = this.readBytes();
            if (count2 < 1) {
                if (count2 < 0) {
                    this.freeBuffers();
                    return false;
                }
                this.reportStrangeStream();
            }
        }
        while (this.mByteBufferEnd - this.mBytePtr < 4) {
            count2 = this.readBytesAt(this.mByteBufferEnd);
            if (count2 >= 1) continue;
            if (count2 < 0) {
                this.freeBuffers();
                this.reportUnexpectedEOF(this.mByteBufferEnd, 4);
            }
            this.reportStrangeStream();
        }
        return true;
    }
}

