/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.msv;

import com.ctc.wstx.msv.W3CSchema;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XMLSchemaGrammar;
import com.ctc.wstx.shaded.msv_core.grammar.xmlschema.XMLSchemaSchema;
import com.ctc.wstx.shaded.msv_core.reader.GrammarReaderController;
import com.ctc.wstx.shaded.msv_core.reader.State;
import com.ctc.wstx.shaded.msv_core.reader.xmlschema.EmbeddedSchema;
import com.ctc.wstx.shaded.msv_core.reader.xmlschema.MultiSchemaReader;
import com.ctc.wstx.shaded.msv_core.reader.xmlschema.SchemaState;
import com.ctc.wstx.shaded.msv_core.reader.xmlschema.WSDLGrammarReaderController;
import com.ctc.wstx.shaded.msv_core.reader.xmlschema.XMLSchemaReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.codehaus.stax2.validation.XMLValidationSchema;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Locator;

public class W3CMultiSchemaFactory {
    private final SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    public W3CMultiSchemaFactory() {
        this.parserFactory.setNamespaceAware(true);
    }

    public XMLValidationSchema createSchema(String baseURI, Map<String, Source> schemaSources) throws XMLStreamException {
        HashMap<String, EmbeddedSchema> embeddedSources = new HashMap<String, EmbeddedSchema>();
        for (Map.Entry<String, Source> source2 : schemaSources.entrySet()) {
            if (!(source2.getValue() instanceof DOMSource)) continue;
            Node nd = ((DOMSource)source2.getValue()).getNode();
            Object el = null;
            if (nd instanceof Element) {
                el = (Element)nd;
            } else if (nd instanceof Document) {
                el = ((Document)nd).getDocumentElement();
            }
            embeddedSources.put(source2.getKey(), new EmbeddedSchema(source2.getValue().getSystemId(), (Element)el));
        }
        WSDLGrammarReaderController ctrl = new WSDLGrammarReaderController(null, baseURI, embeddedSources);
        RecursiveAllowedXMLSchemaReader xmlSchemaReader = new RecursiveAllowedXMLSchemaReader(ctrl, this.parserFactory);
        MultiSchemaReader multiSchemaReader = new MultiSchemaReader(xmlSchemaReader);
        for (Source source3 : schemaSources.values()) {
            multiSchemaReader.parse(source3);
        }
        XMLSchemaGrammar grammar = multiSchemaReader.getResult();
        if (grammar == null) {
            throw new XMLStreamException("Failed to load schemas");
        }
        return new W3CSchema(grammar);
    }

    static class RecursiveAllowedXMLSchemaReader
    extends XMLSchemaReader {
        Set<String> sysIds = new TreeSet<String>();

        RecursiveAllowedXMLSchemaReader(GrammarReaderController controller, SAXParserFactory parserFactory) {
            super(controller, parserFactory, new XMLSchemaReader.StateFactory(){

                @Override
                public State schemaHead(String expectedNamespace) {
                    return new SchemaState(expectedNamespace){
                        private XMLSchemaSchema old;

                        @Override
                        protected void endSelf() {
                            super.endSelf();
                            RecursiveAllowedXMLSchemaReader r2 = (RecursiveAllowedXMLSchemaReader)this.reader;
                            r2.currentSchema = this.old;
                        }

                        @Override
                        protected void onTargetNamespaceResolved(String targetNs, boolean ignoreContents) {
                            RecursiveAllowedXMLSchemaReader r2 = (RecursiveAllowedXMLSchemaReader)this.reader;
                            this.old = r2.currentSchema;
                            r2.currentSchema = r2.getOrCreateSchema(targetNs);
                            if (ignoreContents) {
                                return;
                            }
                            if (!r2.isSchemaDefined(r2.currentSchema)) {
                                r2.markSchemaAsDefined(r2.currentSchema);
                            }
                        }
                    };
                }
            }, new ExpressionPool());
        }

        @Override
        public void setLocator(Locator locator) {
            if (locator == null && this.getLocator() != null && this.getLocator().getSystemId() != null) {
                this.sysIds.add(this.getLocator().getSystemId());
            }
            super.setLocator(locator);
        }

        @Override
        public void switchSource(Source source2, State newState) {
            String url2 = source2.getSystemId();
            if (url2 != null && this.sysIds.contains(url2)) {
                return;
            }
            super.switchSource(source2, newState);
        }
    }
}

