/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.BinaryBaseType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.BinaryValueType;

public class Base64BinaryType
extends BinaryBaseType {
    public static final Base64BinaryType theInstance = new Base64BinaryType();
    private static final byte[] decodeMap = Base64BinaryType.initDecodeMap();
    private static final byte PADDING = 127;
    private static final char[] encodeMap = Base64BinaryType.initEncodeMap();
    private static final long serialVersionUID = 1L;

    private Base64BinaryType() {
        super("base64Binary");
    }

    private static byte[] initDecodeMap() {
        int i;
        byte[] map2 = new byte[256];
        for (i = 0; i < 256; ++i) {
            map2[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            map2[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            map2[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            map2[i] = (byte)(i - 48 + 52);
        }
        map2[43] = 62;
        map2[47] = 63;
        map2[61] = 127;
        return map2;
    }

    public Object _createValue(String lexicalValue, ValidationContext context) {
        byte[] buf2 = Base64BinaryType.load(lexicalValue);
        if (buf2 == null) {
            return null;
        }
        return new BinaryValueType(buf2);
    }

    public static byte[] load(String lexicalValue) {
        char[] buf2 = lexicalValue.toCharArray();
        int outlen = Base64BinaryType.calcLength(buf2);
        if (outlen == -1) {
            return null;
        }
        byte[] out2 = new byte[outlen];
        int o = 0;
        int len = buf2.length;
        byte[] quadruplet = new byte[4];
        int q = 0;
        for (int i = 0; i < len; ++i) {
            byte v = decodeMap[buf2[i]];
            if (v != -1) {
                quadruplet[q++] = v;
            }
            if (q != 4) continue;
            out2[o++] = (byte)(quadruplet[0] << 2 | quadruplet[1] >> 4);
            if (quadruplet[2] != 127) {
                out2[o++] = (byte)(quadruplet[1] << 4 | quadruplet[2] >> 2);
            }
            if (quadruplet[3] != 127) {
                out2[o++] = (byte)(quadruplet[2] << 6 | quadruplet[3]);
            }
            q = 0;
        }
        if (q != 0) {
            throw new IllegalStateException();
        }
        return out2;
    }

    protected boolean checkFormat(String lexicalValue, ValidationContext context) {
        return Base64BinaryType.calcLength(lexicalValue.toCharArray()) != -1;
    }

    private static int calcLength(char[] buf2) {
        int i;
        int len = buf2.length;
        int base64count = 0;
        int paddingCount = 0;
        for (i = 0; i < len && buf2[i] != '='; ++i) {
            if (buf2[i] >= '\u0100') {
                return -1;
            }
            if (decodeMap[buf2[i]] == -1) continue;
            ++base64count;
        }
        while (i < len) {
            if (buf2[i] == '=') {
                ++paddingCount;
            } else {
                if (buf2[i] >= '\u0100') {
                    return -1;
                }
                if (decodeMap[buf2[i]] != -1) {
                    return -1;
                }
            }
            ++i;
        }
        if (paddingCount > 2) {
            return -1;
        }
        if ((base64count + paddingCount) % 4 != 0) {
            return -1;
        }
        return (base64count + paddingCount) / 4 * 3 - paddingCount;
    }

    private static char[] initEncodeMap() {
        int i;
        char[] map2 = new char[64];
        for (i = 0; i < 26; ++i) {
            map2[i] = (char)(65 + i);
        }
        for (i = 26; i < 52; ++i) {
            map2[i] = (char)(97 + (i - 26));
        }
        for (i = 52; i < 62; ++i) {
            map2[i] = (char)(48 + (i - 52));
        }
        map2[62] = 43;
        map2[63] = 47;
        return map2;
    }

    protected static char encode(int i) {
        return encodeMap[i & 0x3F];
    }

    public String serializeJavaObject(Object value, SerializationContext context) {
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return Base64BinaryType.save((byte[])value);
    }

    public static String save(byte[] input2) {
        StringBuffer r2 = new StringBuffer(input2.length * 4 / 3);
        block4: for (int i = 0; i < input2.length; i += 3) {
            switch (input2.length - i) {
                case 1: {
                    r2.append(Base64BinaryType.encode(input2[i] >> 2));
                    r2.append(Base64BinaryType.encode((input2[i] & 3) << 4));
                    r2.append("==");
                    continue block4;
                }
                case 2: {
                    r2.append(Base64BinaryType.encode(input2[i] >> 2));
                    r2.append(Base64BinaryType.encode((input2[i] & 3) << 4 | input2[i + 1] >> 4 & 0xF));
                    r2.append(Base64BinaryType.encode((input2[i + 1] & 0xF) << 2));
                    r2.append("=");
                    continue block4;
                }
                default: {
                    r2.append(Base64BinaryType.encode(input2[i] >> 2));
                    r2.append(Base64BinaryType.encode((input2[i] & 3) << 4 | input2[i + 1] >> 4 & 0xF));
                    r2.append(Base64BinaryType.encode((input2[i + 1] & 0xF) << 2 | input2[i + 2] >> 6 & 3));
                    r2.append(Base64BinaryType.encode(input2[i + 2] & 0x3F));
                }
            }
        }
        return r2.toString();
    }

    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (!(value instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return this.serializeJavaObject(((BinaryValueType)value).rawData, context);
    }
}

