/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.BinaryBaseType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.BinaryValueType;

public class HexBinaryType
extends BinaryBaseType {
    public static final HexBinaryType theInstance = new HexBinaryType();
    private static final long serialVersionUID = 1L;

    private HexBinaryType() {
        super("hexBinary");
    }

    private static int hexToBin(char ch2) {
        if ('0' <= ch2 && ch2 <= '9') {
            return ch2 - 48;
        }
        if ('A' <= ch2 && ch2 <= 'F') {
            return ch2 - 65 + 10;
        }
        if ('a' <= ch2 && ch2 <= 'f') {
            return ch2 - 97 + 10;
        }
        return -1;
    }

    public Object _createValue(String lexicalValue, ValidationContext context) {
        byte[] buf2 = HexBinaryType.load(lexicalValue);
        if (buf2 == null) {
            return null;
        }
        return new BinaryValueType(buf2);
    }

    public static byte[] load(String s2) {
        int len = s2.length();
        if (len % 2 != 0) {
            return null;
        }
        byte[] out2 = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            int h2 = HexBinaryType.hexToBin(s2.charAt(i));
            int l = HexBinaryType.hexToBin(s2.charAt(i + 1));
            if (h2 == -1 || l == -1) {
                return null;
            }
            out2[i / 2] = (byte)(h2 * 16 + l);
        }
        return out2;
    }

    protected boolean checkFormat(String lexicalValue, ValidationContext context) {
        int len = lexicalValue.length();
        if (len % 2 != 0) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (HexBinaryType.hexToBin(lexicalValue.charAt(i)) != -1) continue;
            return false;
        }
        return true;
    }

    public String serializeJavaObject(Object value, SerializationContext context) {
        if (!(value instanceof byte[])) {
            throw new IllegalArgumentException();
        }
        return HexBinaryType.save((byte[])value);
    }

    public static String save(byte[] data2) {
        StringBuffer r2 = new StringBuffer(data2.length * 2);
        for (int i = 0; i < data2.length; ++i) {
            r2.append(HexBinaryType.encode(data2[i] >> 4));
            r2.append(HexBinaryType.encode(data2[i] & 0xF));
        }
        return r2.toString();
    }

    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (!(value instanceof BinaryValueType)) {
            throw new IllegalArgumentException();
        }
        return this.serializeJavaObject(((BinaryValueType)value).rawData, context);
    }

    public static char encode(int ch2) {
        if ((ch2 &= 0xF) < 10) {
            return (char)(48 + ch2);
        }
        return (char)(65 + (ch2 - 10));
    }
}

