/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.relaxng_datatype.DatatypeException;
import com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.Comparator;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.DataTypeWithFacet;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.IntegerValueType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.MaxInclusiveFacet;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.MinInclusiveFacet;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatypeImpl;

abstract class IntegerDerivedType
extends BuiltinAtomicType
implements Comparator {
    private final XSDatatypeImpl baseFacets;
    private static final long serialVersionUID = -7353993842821534786L;

    protected IntegerDerivedType(String typeName, XSDatatypeImpl _baseFacets) {
        super(typeName);
        this.baseFacets = _baseFacets;
    }

    public final int isFacetApplicable(String facetName) {
        if (facetName.equals("totalDigits") || facetName.equals("pattern") || facetName.equals("whiteSpace") || facetName.equals("enumeration") || facetName.equals("maxInclusive") || facetName.equals("minInclusive") || facetName.equals("maxExclusive") || facetName.equals("minExclusive")) {
            return 0;
        }
        if (facetName.equals("fractionDigits")) {
            return -1;
        }
        return -2;
    }

    public DataTypeWithFacet getFacetObject(String facetName) {
        return this.baseFacets.getFacetObject(facetName);
    }

    protected final boolean checkFormat(String content2, ValidationContext context) {
        return this._createValue(content2, context) != null;
    }

    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (value instanceof Number || value instanceof IntegerValueType) {
            return value.toString();
        }
        throw new IllegalArgumentException("invalid value type:" + value.getClass().toString());
    }

    public final int compare(Object o1, Object o2) {
        int r2 = ((Comparable)o1).compareTo(o2);
        if (r2 < 0) {
            return -1;
        }
        if (r2 > 0) {
            return 1;
        }
        return 0;
    }

    protected static String removeOptionalPlus(String s2) {
        if (s2.length() <= 1 || s2.charAt(0) != '+') {
            return s2;
        }
        char ch2 = (s2 = s2.substring(1)).charAt(0);
        if ('0' <= ch2 && ch2 <= '9') {
            return s2;
        }
        if ('.' == ch2) {
            return s2;
        }
        throw new NumberFormatException();
    }

    protected static XSDatatypeImpl createRangeFacet(XSDatatypeImpl baseType, Number min2, Number max) {
        try {
            XSDatatypeImpl r2 = baseType;
            if (min2 != null) {
                r2 = new MinInclusiveFacet(null, null, r2, min2, false);
            }
            if (max != null) {
                r2 = new MaxInclusiveFacet(null, null, r2, max, false);
            }
            return r2;
        }
        catch (DatatypeException e) {
            throw new InternalError();
        }
    }
}

