/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.relaxng_datatype.ValidationContext;
import com.ctc.wstx.shaded.msv_core.datatype.SerializationContext;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.BuiltinAtomicType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.Comparator;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.SimpleURType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberType
extends BuiltinAtomicType
implements Comparator {
    public static final NumberType theInstance = new NumberType();
    private static final BigInteger the10 = new BigInteger("10");
    private static final long serialVersionUID = 1L;

    private NumberType() {
        super("decimal");
    }

    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    protected boolean checkFormat(String content2, ValidationContext context) {
        int len = content2.length();
        int i = 0;
        boolean atLeastOneDigit = false;
        if (len == 0) {
            return false;
        }
        char ch2 = content2.charAt(0);
        if (ch2 == '-' || ch2 == '+') {
            ++i;
        }
        while (i < len) {
            if ('0' <= (ch2 = content2.charAt(i++)) && ch2 <= '9') {
                atLeastOneDigit = true;
                continue;
            }
            if (ch2 == '.') break;
            return false;
        }
        while (i < len) {
            if ('0' <= (ch2 = content2.charAt(i++)) && ch2 <= '9') {
                atLeastOneDigit = true;
                continue;
            }
            return false;
        }
        return atLeastOneDigit;
    }

    public Object _createValue(String content2, ValidationContext context) {
        if (!this.checkFormat(content2, context)) {
            return null;
        }
        return NumberType.load(content2);
    }

    public static BigDecimal load(String content2) {
        try {
            BigInteger[] q_r;
            if (content2.length() == 0) {
                return null;
            }
            if (content2.charAt(0) == '+') {
                content2 = content2.substring(1);
            }
            BigDecimal r2 = new BigDecimal(content2);
            while (r2.scale() > 0 && (q_r = r2.unscaledValue().divideAndRemainder(the10))[1].equals(BigInteger.ZERO)) {
                r2 = new BigDecimal(q_r[0], r2.scale() - 1);
            }
            return r2;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static String save(Object o) {
        return ((BigDecimal)o).toString();
    }

    public Class getJavaObjectType() {
        return BigDecimal.class;
    }

    public String convertToLexicalValue(Object o, SerializationContext context) {
        if (o instanceof BigDecimal) {
            return o.toString();
        }
        throw new IllegalArgumentException();
    }

    public final int isFacetApplicable(String facetName) {
        if (facetName.equals("totalDigits") || facetName.equals("fractionDigits") || facetName.equals("pattern") || facetName.equals("enumeration") || facetName.equals("whiteSpace") || facetName.equals("maxInclusive") || facetName.equals("minInclusive") || facetName.equals("maxExclusive") || facetName.equals("minExclusive")) {
            return 0;
        }
        return -2;
    }

    public final int compare(Object o1, Object o2) {
        int r2 = ((Comparable)o1).compareTo(o2);
        if (r2 < 0) {
            return -1;
        }
        if (r2 > 0) {
            return 1;
        }
        return 0;
    }
}

