/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.xsd_util.XmlChars;

public class XmlNames {
    private XmlNames() {
    }

    public static boolean isName(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char c = value.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < value.length(); ++i) {
            if (XmlChars.isNameChar(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnqualifiedName(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        char c = value.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < value.length(); ++i) {
            if (XmlChars.isNCNameChar(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedName(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        int first2 = value.indexOf(58);
        if (first2 <= 0) {
            return XmlNames.isUnqualifiedName(value);
        }
        int last2 = value.lastIndexOf(58);
        if (last2 != first2) {
            return false;
        }
        return XmlNames.isUnqualifiedName(value.substring(0, first2)) && XmlNames.isUnqualifiedName(value.substring(first2 + 1));
    }

    public static boolean isNmtoken(String token2) {
        if (token2 == null || token2.length() == 0) {
            return false;
        }
        int length = token2.length();
        for (int i = 0; i < length; ++i) {
            if (XmlChars.isNameChar(token2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNmtoken(String token2) {
        return XmlNames.isNmtoken(token2) && token2.indexOf(58) < 0;
    }

    public static boolean isNCName(String token2) {
        return XmlNames.isName(token2) && token2.indexOf(58) < 0;
    }
}

