/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime;

import com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.AbstractCalendarFormatter;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.BigDateTimeValueType;
import com.ctc.wstx.shaded.msv_core.datatype.xsd.datetime.IDateTimeValueType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

public class PreciseCalendarFormatter
extends AbstractCalendarFormatter {
    private static final PreciseCalendarFormatter theInstance = new PreciseCalendarFormatter();

    private PreciseCalendarFormatter() {
    }

    public static String format(String format, IDateTimeValueType cal) {
        return theInstance.doFormat(format, cal.getBigValue());
    }

    protected Calendar toCalendar(Object cal) {
        return ((BigDateTimeValueType)cal).toCalendar();
    }

    protected void formatYear(Object cal, StringBuffer buf2) {
        String s2;
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        BigInteger year2 = bv.getYear();
        if (year2 == null) {
            buf2.append("0000");
            return;
        }
        if (year2.signum() <= 0) {
            buf2.append('-');
            s2 = year2.negate().add(BigInteger.ONE).toString();
        } else {
            s2 = year2.toString();
        }
        while (s2.length() < 4) {
            s2 = "0" + s2;
        }
        buf2.append(s2);
    }

    protected void formatMonth(Object cal, StringBuffer buf2) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getMonth(), 1, buf2);
    }

    protected void formatDays(Object cal, StringBuffer buf2) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getDay(), 1, buf2);
    }

    protected void formatHours(Object cal, StringBuffer buf2) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getHour(), buf2);
    }

    protected void formatMinutes(Object cal, StringBuffer buf2) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        this.formatTwoDigits(bv.getMinute(), buf2);
    }

    protected void formatSeconds(Object cal, StringBuffer buf2) {
        BigDateTimeValueType bv = ((IDateTimeValueType)cal).getBigValue();
        BigDecimal sec = bv.getSecond();
        if (sec == null) {
            buf2.append("00");
            return;
        }
        while (sec.scale() > 0 && sec.toString().endsWith("0")) {
            sec = sec.movePointLeft(1);
        }
        String s2 = sec.toString();
        if (sec.compareTo(new BigDecimal("10")) < 0) {
            s2 = "0" + s2;
        }
        buf2.append(s2);
    }

    private void formatTwoDigits(Integer v, StringBuffer buf2) {
        this.formatTwoDigits(v, 0, buf2);
    }

    private void formatTwoDigits(Integer v, int offset, StringBuffer buf2) {
        if (v == null) {
            buf2.append("00");
        } else {
            this.formatTwoDigits(v + offset, buf2);
        }
    }
}

