/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.scanner.dtd;

import com.ctc.wstx.shaded.msv_core.scanner.dtd.XmlReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class Resolver
implements EntityResolver {
    private boolean ignoringMIME;
    private Hashtable id2uri;
    private Hashtable id2resource;
    private Hashtable id2loader;
    private static final String[] types = new String[]{"application/xml", "text/xml", "text/plain", "text/html", "application/x-netcdf", "content/unknown"};

    public static InputSource createInputSource(String contentType2, InputStream stream, boolean checkType, String scheme2) throws IOException {
        String charset = null;
        if (contentType2 != null) {
            int index = (contentType2 = contentType2.toLowerCase()).indexOf(59);
            if (index != -1) {
                String attributes2 = contentType2.substring(index + 1);
                contentType2 = contentType2.substring(0, index);
                index = attributes2.indexOf("charset");
                if (index != -1) {
                    if ((index = (attributes2 = attributes2.substring(index + 7)).indexOf(59)) != -1) {
                        attributes2 = attributes2.substring(0, index);
                    }
                    if ((index = attributes2.indexOf(61)) != -1) {
                        if ((index = (attributes2 = attributes2.substring(index + 1)).indexOf(40)) != -1) {
                            attributes2 = attributes2.substring(0, index);
                        }
                        if ((index = attributes2.indexOf(34)) != -1) {
                            attributes2 = attributes2.substring(index + 1);
                            attributes2 = attributes2.substring(0, attributes2.indexOf(34));
                        }
                        charset = attributes2.trim();
                    }
                }
            }
            if (checkType) {
                boolean isOK = false;
                for (int i = 0; i < types.length; ++i) {
                    if (!types[i].equals(contentType2)) continue;
                    isOK = true;
                    break;
                }
                if (!isOK) {
                    throw new IOException("Not XML: " + contentType2);
                }
            }
            if (charset == null && (contentType2 = contentType2.trim()).startsWith("text/") && !"file".equalsIgnoreCase(scheme2)) {
                charset = "US-ASCII";
            }
        }
        InputSource retval = new InputSource(XmlReader.createReader(stream, charset));
        retval.setByteStream(stream);
        retval.setEncoding(charset);
        return retval;
    }

    public static InputSource createInputSource(URL uri2, boolean checkType) throws IOException {
        InputSource retval;
        URLConnection conn = uri2.openConnection();
        if (checkType) {
            String contentType2 = conn.getContentType();
            retval = Resolver.createInputSource(contentType2, conn.getInputStream(), false, uri2.getProtocol());
        } else {
            retval = new InputSource(XmlReader.createReader(conn.getInputStream()));
        }
        retval.setSystemId(conn.getURL().toString());
        return retval;
    }

    public static InputSource createInputSource(File file2) throws IOException {
        InputSource retval = new InputSource(XmlReader.createReader(new FileInputStream(file2)));
        String path = file2.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (!path.endsWith("/") && file2.isDirectory()) {
            path = path + "/";
        }
        retval.setSystemId("file:" + path);
        return retval;
    }

    public InputSource resolveEntity(String name, String uri2) throws IOException {
        InputSource retval;
        InputStream stream;
        String mappedURI = this.name2uri(name);
        if (mappedURI == null && (stream = this.mapResource(name)) != null) {
            uri2 = "java:resource:" + (String)this.id2resource.get(name);
            retval = new InputSource(XmlReader.createReader(stream));
        } else {
            if (mappedURI != null) {
                uri2 = mappedURI;
            } else if (uri2 == null) {
                return null;
            }
            URL url2 = new URL(uri2);
            URLConnection conn = url2.openConnection();
            uri2 = conn.getURL().toString();
            if (this.ignoringMIME) {
                retval = new InputSource(XmlReader.createReader(conn.getInputStream()));
            } else {
                String contentType2 = conn.getContentType();
                retval = Resolver.createInputSource(contentType2, conn.getInputStream(), false, url2.getProtocol());
            }
        }
        retval.setSystemId(uri2);
        retval.setPublicId(name);
        return retval;
    }

    public boolean isIgnoringMIME() {
        return this.ignoringMIME;
    }

    public void setIgnoringMIME(boolean value) {
        this.ignoringMIME = value;
    }

    private String name2uri(String publicId) {
        if (publicId == null || this.id2uri == null) {
            return null;
        }
        return (String)this.id2uri.get(publicId);
    }

    public void registerCatalogEntry(String publicId, String uri2) {
        if (this.id2uri == null) {
            this.id2uri = new Hashtable(17);
        }
        this.id2uri.put(publicId, uri2);
    }

    private InputStream mapResource(String publicId) {
        if (publicId == null || this.id2resource == null) {
            return null;
        }
        String resourceName = (String)this.id2resource.get(publicId);
        ClassLoader loader = null;
        if (resourceName == null) {
            return null;
        }
        if (this.id2loader != null) {
            loader = (ClassLoader)this.id2loader.get(publicId);
        }
        if (loader == null) {
            return ClassLoader.getSystemResourceAsStream(resourceName);
        }
        return loader.getResourceAsStream(resourceName);
    }

    public void registerCatalogEntry(String publicId, String resourceName, ClassLoader loader) {
        if (this.id2resource == null) {
            this.id2resource = new Hashtable(17);
        }
        this.id2resource.put(publicId, resourceName);
        if (loader != null) {
            if (this.id2loader == null) {
                this.id2loader = new Hashtable(17);
            }
            this.id2loader.put(publicId, loader);
        }
    }
}

