/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.util;

import com.ctc.wstx.util.DataUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.NamespaceContext;

public final class BijectiveNsMap {
    static final int DEFAULT_ARRAY_SIZE = 32;
    private static final int MAX_LOOP_FOR_NEW_PREFIX = 999999;
    final int mScopeStart;
    String[] mNsStrings;
    int mScopeEnd;

    private BijectiveNsMap(int scopeStart, String[] strs) {
        this.mScopeStart = this.mScopeEnd = scopeStart;
        this.mNsStrings = strs;
    }

    public static BijectiveNsMap createEmpty() {
        String[] strs = new String[32];
        strs[0] = "xml";
        strs[1] = "http://www.w3.org/XML/1998/namespace";
        strs[2] = "xmlns";
        strs[3] = "http://www.w3.org/2000/xmlns/";
        return new BijectiveNsMap(4, strs);
    }

    public BijectiveNsMap createChild() {
        return new BijectiveNsMap(this.mScopeEnd, this.mNsStrings);
    }

    public String findUriByPrefix(String prefix) {
        String[] strs = this.mNsStrings;
        int phash = prefix.hashCode();
        for (int ix = this.mScopeEnd - 2; ix >= 0; ix -= 2) {
            String thisP = strs[ix];
            if (thisP != prefix && (thisP.hashCode() != phash || !thisP.equals(prefix))) continue;
            return strs[ix + 1];
        }
        return null;
    }

    public String findPrefixByUri(String uri2) {
        String[] strs = this.mNsStrings;
        int uhash = uri2.hashCode();
        block0: for (int ix = this.mScopeEnd - 1; ix > 0; ix -= 2) {
            String thisU = strs[ix];
            if (thisU != uri2 && (thisU.hashCode() != uhash || !thisU.equals(uri2))) continue;
            String prefix = strs[ix - 1];
            if (ix < this.mScopeStart) {
                int phash = prefix.hashCode();
                int end2 = this.mScopeEnd;
                for (int j2 = ix + 1; j2 < end2; j2 += 2) {
                    String thisP = strs[j2];
                    if (thisP == prefix || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
            }
            return prefix;
        }
        return null;
    }

    public List<String> getPrefixesBoundToUri(String uri2, List<String> l) {
        String[] strs = this.mNsStrings;
        int uhash = uri2.hashCode();
        block0: for (int ix = this.mScopeEnd - 1; ix > 0; ix -= 2) {
            String thisU = strs[ix];
            if (thisU != uri2 && (thisU.hashCode() != uhash || !thisU.equals(uri2))) continue;
            String prefix = strs[ix - 1];
            if (ix < this.mScopeStart) {
                int phash = prefix.hashCode();
                int end2 = this.mScopeEnd;
                for (int j2 = ix + 1; j2 < end2; j2 += 2) {
                    String thisP = strs[j2];
                    if (thisP == prefix || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
            }
            if (l == null) {
                l = new ArrayList<String>();
            }
            l.add(prefix);
        }
        return l;
    }

    public int size() {
        return this.mScopeEnd >> 1;
    }

    public int localSize() {
        return this.mScopeEnd - this.mScopeStart >> 1;
    }

    public String addMapping(String prefix, String uri2) {
        String[] strs = this.mNsStrings;
        int phash = prefix.hashCode();
        int end2 = this.mScopeEnd;
        for (int ix = this.mScopeStart; ix < end2; ix += 2) {
            String thisP = strs[ix];
            if (thisP != prefix && (thisP.hashCode() != phash || !thisP.equals(prefix))) continue;
            String old = strs[ix + 1];
            strs[ix + 1] = uri2;
            return old;
        }
        if (this.mScopeEnd >= strs.length) {
            strs = DataUtil.growArrayBy(strs, strs.length);
            this.mNsStrings = strs;
        }
        strs[this.mScopeEnd++] = prefix;
        strs[this.mScopeEnd++] = uri2;
        return null;
    }

    public String addGeneratedMapping(String prefixBase, NamespaceContext ctxt, String uri2, int[] seqArr) {
        String prefix;
        int seqNr;
        String[] strs;
        block3: {
            strs = this.mNsStrings;
            seqNr = seqArr[0];
            int attempts = 0;
            block0: while (true) {
                String existing;
                prefix = (prefixBase + seqNr).intern();
                ++seqNr;
                int phash = prefix.hashCode();
                for (int ix = this.mScopeEnd - 2; ix >= 0; ix -= 2) {
                    String thisP = strs[ix];
                    if (thisP == prefix || thisP.hashCode() == phash && thisP.equals(prefix)) continue block0;
                }
                if (ctxt == null || (existing = ctxt.getNamespaceURI(prefix)) == null || existing.isEmpty()) break block3;
                if (++attempts > 999999) break;
            }
            throw new IllegalStateException("Internal error: failed to find a mapping prefix for URI '" + uri2 + " in " + 999999 + " attempts");
        }
        seqArr[0] = seqNr;
        if (this.mScopeEnd >= strs.length) {
            strs = DataUtil.growArrayBy(strs, strs.length);
            this.mNsStrings = strs;
        }
        strs[this.mScopeEnd++] = prefix;
        strs[this.mScopeEnd++] = uri2;
        return prefix;
    }

    public String toString() {
        return "[" + this.getClass().toString() + "; " + this.size() + " entries; of which " + this.localSize() + " local]";
    }
}

