/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io;

import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.io.UTF8Writer;
import com.fasterxml.jackson.core.util.ByteArrayBuilder;
import com.fasterxml.jackson.core.util.TextBuffer;
import java.util.Arrays;

public final class JsonStringEncoder {
    private static final char[] HC = CharTypes.copyHexChars();
    private static final byte[] HB = CharTypes.copyHexBytes();
    private static final int SURR1_FIRST = 55296;
    private static final int SURR1_LAST = 56319;
    private static final int SURR2_FIRST = 56320;
    private static final int SURR2_LAST = 57343;
    static final int MIN_CHAR_BUFFER_SIZE = 16;
    static final int MAX_CHAR_BUFFER_SIZE = 32000;
    static final int MIN_BYTE_BUFFER_SIZE = 24;
    static final int MAX_BYTE_BUFFER_SIZE = 32000;
    private static final JsonStringEncoder instance = new JsonStringEncoder();

    public static JsonStringEncoder getInstance() {
        return instance;
    }

    public char[] quoteAsString(String input2) {
        int inputLen = input2.length();
        char[] outputBuffer = new char[JsonStringEncoder._initialCharBufSize(inputLen)];
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        TextBuffer textBuffer = null;
        int outPtr = 0;
        char[] qbuf = null;
        block0: while (inPtr < inputLen) {
            char d;
            int escCode;
            int length;
            char c;
            while ((c = input2.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                if (outPtr >= outputBuffer.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(outputBuffer);
                    }
                    outputBuffer = textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = c;
                if (++inPtr < inputLen) continue;
                break block0;
            }
            if (qbuf == null) {
                qbuf = this._qbuf();
            }
            int n = length = (escCode = escCodes[d = input2.charAt(inPtr++)]) < 0 ? this._appendNumeric(d, qbuf) : this._appendNamed(escCode, qbuf);
            if (outPtr + length > outputBuffer.length) {
                int first2 = outputBuffer.length - outPtr;
                if (first2 > 0) {
                    System.arraycopy(qbuf, 0, outputBuffer, outPtr, first2);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(outputBuffer);
                }
                outputBuffer = textBuffer.finishCurrentSegment();
                int second2 = length - first2;
                System.arraycopy(qbuf, first2, outputBuffer, 0, second2);
                outPtr = second2;
                continue;
            }
            System.arraycopy(qbuf, 0, outputBuffer, outPtr, length);
            outPtr += length;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outPtr);
        }
        textBuffer.setCurrentLength(outPtr);
        return textBuffer.contentsAsArray();
    }

    public char[] quoteAsString(CharSequence input2) {
        if (input2 instanceof String) {
            return this.quoteAsString((String)input2);
        }
        TextBuffer textBuffer = null;
        int inputLen = input2.length();
        char[] outputBuffer = new char[JsonStringEncoder._initialCharBufSize(inputLen)];
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int outPtr = 0;
        char[] qbuf = null;
        block0: while (inPtr < inputLen) {
            char d;
            int escCode;
            int length;
            char c;
            while ((c = input2.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                if (outPtr >= outputBuffer.length) {
                    if (textBuffer == null) {
                        textBuffer = TextBuffer.fromInitial(outputBuffer);
                    }
                    outputBuffer = textBuffer.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = c;
                if (++inPtr < inputLen) continue;
                break block0;
            }
            if (qbuf == null) {
                qbuf = this._qbuf();
            }
            int n = length = (escCode = escCodes[d = input2.charAt(inPtr++)]) < 0 ? this._appendNumeric(d, qbuf) : this._appendNamed(escCode, qbuf);
            if (outPtr + length > outputBuffer.length) {
                int first2 = outputBuffer.length - outPtr;
                if (first2 > 0) {
                    System.arraycopy(qbuf, 0, outputBuffer, outPtr, first2);
                }
                if (textBuffer == null) {
                    textBuffer = TextBuffer.fromInitial(outputBuffer);
                }
                outputBuffer = textBuffer.finishCurrentSegment();
                int second2 = length - first2;
                System.arraycopy(qbuf, first2, outputBuffer, 0, second2);
                outPtr = second2;
                continue;
            }
            System.arraycopy(qbuf, 0, outputBuffer, outPtr, length);
            outPtr += length;
        }
        if (textBuffer == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outPtr);
        }
        textBuffer.setCurrentLength(outPtr);
        return textBuffer.contentsAsArray();
    }

    public void quoteAsString(CharSequence input2, StringBuilder output2) {
        int[] escCodes = CharTypes.get7BitOutputEscapes();
        int escCodeCount = escCodes.length;
        int inPtr = 0;
        int inputLen = input2.length();
        char[] qbuf = null;
        block0: while (inPtr < inputLen) {
            char d;
            int escCode;
            char c;
            while ((c = input2.charAt(inPtr)) >= escCodeCount || escCodes[c] == 0) {
                output2.append(c);
                if (++inPtr < inputLen) continue;
                break block0;
            }
            if (qbuf == null) {
                qbuf = this._qbuf();
            }
            int length = (escCode = escCodes[d = input2.charAt(inPtr++)]) < 0 ? this._appendNumeric(d, qbuf) : this._appendNamed(escCode, qbuf);
            output2.append(qbuf, 0, length);
        }
    }

    public byte[] quoteAsUTF8(String text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        ByteArrayBuilder bb = null;
        block0: while (inputPtr < inputEnd) {
            int ch2;
            int[] escCodes = CharTypes.get7BitOutputEscapes();
            while ((ch2 = text.charAt(inputPtr)) <= 127 && escCodes[ch2] == 0) {
                if (outputPtr >= outputBuffer.length) {
                    if (bb == null) {
                        bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)ch2;
                if (++inputPtr < inputEnd) continue;
                break block0;
            }
            if (bb == null) {
                bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = bb.finishCurrentSegment();
                outputPtr = 0;
            }
            if ((ch2 = text.charAt(inputPtr++)) <= 127) {
                int escape = escCodes[ch2];
                outputPtr = this._appendByte(ch2, escape, bb, outputPtr);
                outputBuffer = bb.getCurrentSegment();
                continue;
            }
            if (ch2 <= 2047) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | ch2 >> 6);
                ch2 = 0x80 | ch2 & 0x3F;
            } else if (ch2 < 55296 || ch2 > 57343) {
                outputBuffer[outputPtr++] = (byte)(0xE0 | ch2 >> 12);
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch2 >> 6 & 0x3F);
                ch2 = 0x80 | ch2 & 0x3F;
            } else {
                if (ch2 > 56319) {
                    JsonStringEncoder._illegal(ch2);
                }
                if (inputPtr >= inputEnd) {
                    JsonStringEncoder._illegal(ch2);
                }
                if ((ch2 = JsonStringEncoder._convert(ch2, text.charAt(inputPtr++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(ch2);
                }
                outputBuffer[outputPtr++] = (byte)(0xF0 | ch2 >> 18);
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch2 >> 12 & 0x3F);
                if (outputPtr >= outputBuffer.length) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | ch2 >> 6 & 0x3F);
                ch2 = 0x80 | ch2 & 0x3F;
            }
            if (outputPtr >= outputBuffer.length) {
                outputBuffer = bb.finishCurrentSegment();
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)ch2;
        }
        if (bb == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb.completeAndCoalesce(outputPtr);
    }

    public byte[] encodeAsUTF8(String text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        int outputEnd = outputBuffer.length;
        ByteArrayBuilder bb = null;
        block0: while (inputPtr < inputEnd) {
            int c = text.charAt(inputPtr++);
            while (c <= 127) {
                if (outputPtr >= outputEnd) {
                    if (bb == null) {
                        bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)c;
                if (inputPtr >= inputEnd) break block0;
                c = text.charAt(inputPtr++);
            }
            if (bb == null) {
                bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            if (c < 2048) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | c >> 6);
            } else if (c < 55296 || c > 57343) {
                outputBuffer[outputPtr++] = (byte)(0xE0 | c >> 12);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            } else {
                if (c > 56319) {
                    JsonStringEncoder._illegal(c);
                }
                if (inputPtr >= inputEnd) {
                    JsonStringEncoder._illegal(c);
                }
                if ((c = JsonStringEncoder._convert(c, text.charAt(inputPtr++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(c);
                }
                outputBuffer[outputPtr++] = (byte)(0xF0 | c >> 18);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)(0x80 | c & 0x3F);
        }
        if (bb == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb.completeAndCoalesce(outputPtr);
    }

    public byte[] encodeAsUTF8(CharSequence text) {
        int inputPtr = 0;
        int inputEnd = text.length();
        int outputPtr = 0;
        byte[] outputBuffer = new byte[JsonStringEncoder._initialByteBufSize(inputEnd)];
        int outputEnd = outputBuffer.length;
        ByteArrayBuilder bb = null;
        block0: while (inputPtr < inputEnd) {
            int c = text.charAt(inputPtr++);
            while (c <= 127) {
                if (outputPtr >= outputEnd) {
                    if (bb == null) {
                        bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
                    }
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)c;
                if (inputPtr >= inputEnd) break block0;
                c = text.charAt(inputPtr++);
            }
            if (bb == null) {
                bb = ByteArrayBuilder.fromInitial(outputBuffer, outputPtr);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            if (c < 2048) {
                outputBuffer[outputPtr++] = (byte)(0xC0 | c >> 6);
            } else if (c < 55296 || c > 57343) {
                outputBuffer[outputPtr++] = (byte)(0xE0 | c >> 12);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            } else {
                if (c > 56319) {
                    JsonStringEncoder._illegal(c);
                }
                if (inputPtr >= inputEnd) {
                    JsonStringEncoder._illegal(c);
                }
                if ((c = JsonStringEncoder._convert(c, text.charAt(inputPtr++))) > 0x10FFFF) {
                    JsonStringEncoder._illegal(c);
                }
                outputBuffer[outputPtr++] = (byte)(0xF0 | c >> 18);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
                if (outputPtr >= outputEnd) {
                    outputBuffer = bb.finishCurrentSegment();
                    outputEnd = outputBuffer.length;
                    outputPtr = 0;
                }
                outputBuffer[outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
            }
            if (outputPtr >= outputEnd) {
                outputBuffer = bb.finishCurrentSegment();
                outputEnd = outputBuffer.length;
                outputPtr = 0;
            }
            outputBuffer[outputPtr++] = (byte)(0x80 | c & 0x3F);
        }
        if (bb == null) {
            return Arrays.copyOfRange(outputBuffer, 0, outputPtr);
        }
        return bb.completeAndCoalesce(outputPtr);
    }

    private char[] _qbuf() {
        char[] qbuf = new char[6];
        qbuf[0] = 92;
        qbuf[2] = 48;
        qbuf[3] = 48;
        return qbuf;
    }

    private int _appendNumeric(int value, char[] qbuf) {
        qbuf[1] = 117;
        qbuf[4] = HC[value >> 4];
        qbuf[5] = HC[value & 0xF];
        return 6;
    }

    private int _appendNamed(int esc, char[] qbuf) {
        qbuf[1] = (char)esc;
        return 2;
    }

    private int _appendByte(int ch2, int esc, ByteArrayBuilder bb, int ptr) {
        bb.setCurrentSegmentLength(ptr);
        bb.append(92);
        if (esc < 0) {
            bb.append(117);
            if (ch2 > 255) {
                int hi = ch2 >> 8;
                bb.append(HB[hi >> 4]);
                bb.append(HB[hi & 0xF]);
                ch2 &= 0xFF;
            } else {
                bb.append(48);
                bb.append(48);
            }
            bb.append(HB[ch2 >> 4]);
            bb.append(HB[ch2 & 0xF]);
        } else {
            bb.append((byte)esc);
        }
        return bb.getCurrentSegmentLength();
    }

    private static int _convert(int p1, int p2) {
        if (p2 < 56320 || p2 > 57343) {
            throw new IllegalArgumentException("Broken surrogate pair: first char 0x" + Integer.toHexString(p1) + ", second 0x" + Integer.toHexString(p2) + "; illegal combination");
        }
        return 65536 + (p1 - 55296 << 10) + (p2 - 56320);
    }

    private static void _illegal(int c) {
        throw new IllegalArgumentException(UTF8Writer.illegalSurrogateDesc(c));
    }

    static int _initialCharBufSize(int strLen) {
        int estimated = Math.max(16, strLen + Math.min(6 + (strLen >> 3), 1000));
        return Math.min(estimated, 32000);
    }

    static int _initialByteBufSize(int strLen) {
        int doubled = Math.max(24, strLen + 6 + (strLen >> 1));
        return Math.min(doubled, 32000);
    }
}

