/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.NodeFactory;
import com.github.benmanes.caffeine.cache.References;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;

class FD<K, V>
extends Node<K, V>
implements NodeFactory<K, V> {
    protected static final VarHandle KEY;
    protected static final VarHandle VALUE;
    volatile References.WeakKeyReference<K> key;
    volatile References.SoftValueReference<V> value;

    FD() {
    }

    FD(K key2, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        this(new References.WeakKeyReference<K>(key2, keyReferenceQueue), value, valueReferenceQueue, weight, now);
    }

    FD(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        KEY.set(this, keyReference);
        VALUE.set(this, new References.SoftValueReference<V>(keyReference, value, valueReferenceQueue));
    }

    @Override
    public final K getKey() {
        return (K)KEY.get(this).get();
    }

    @Override
    public final Object getKeyReference() {
        return KEY.get(this);
    }

    @Override
    public final V getValue() {
        return (V)VALUE.get(this).get();
    }

    @Override
    public final Object getValueReference() {
        return VALUE.get(this);
    }

    @Override
    public final void setValue(V value, ReferenceQueue<V> referenceQueue) {
        ((Reference)this.getValueReference()).clear();
        VALUE.set(this, new References.SoftValueReference<V>(this.getKeyReference(), value, referenceQueue));
    }

    @Override
    public final boolean containsValue(Object value) {
        return this.getValue() == value;
    }

    @Override
    public Node<K, V> newNode(K key2, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FD<K, V>(key2, keyReferenceQueue, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FD<K, V>(keyReference, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Object newLookupKey(Object key2) {
        return new References.LookupKeyReference<Object>(key2);
    }

    @Override
    public Object newReferenceKey(K key2, ReferenceQueue<K> referenceQueue) {
        return new References.WeakKeyReference<K>(key2, referenceQueue);
    }

    @Override
    public boolean softValues() {
        return true;
    }

    @Override
    public final boolean isAlive() {
        Object key2 = this.getKeyReference();
        return key2 != RETIRED_WEAK_KEY && key2 != DEAD_WEAK_KEY;
    }

    @Override
    public final boolean isRetired() {
        return this.getKeyReference() == RETIRED_WEAK_KEY;
    }

    @Override
    public final void retire() {
        ((Reference)this.getKeyReference()).clear();
        ((Reference)this.getValueReference()).clear();
        KEY.set(this, RETIRED_WEAK_KEY);
    }

    @Override
    public final boolean isDead() {
        return this.getKeyReference() == DEAD_WEAK_KEY;
    }

    @Override
    public final void die() {
        ((Reference)this.getKeyReference()).clear();
        ((Reference)this.getValueReference()).clear();
        KEY.set(this, DEAD_WEAK_KEY);
    }

    static {
        MethodHandles.Lookup lookup2 = MethodHandles.lookup();
        try {
            KEY = lookup2.findVarHandle(FD.class, "key", References.WeakKeyReference.class);
            VALUE = lookup2.findVarHandle(FD.class, "value", References.SoftValueReference.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

