/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.PS;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;

class PSA<K, V>
extends PS<K, V> {
    protected static final VarHandle ACCESS_TIME;
    volatile long accessTime;
    Node<K, V> previousInAccessOrder;
    Node<K, V> nextInAccessOrder;

    PSA() {
    }

    PSA(K key2, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key2, keyReferenceQueue, value, valueReferenceQueue, weight, now);
        ACCESS_TIME.set(this, now);
    }

    PSA(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value, valueReferenceQueue, weight, now);
        ACCESS_TIME.set(this, now);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> previousInAccessOrder) {
        this.previousInAccessOrder = previousInAccessOrder;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> nextInAccessOrder) {
        this.nextInAccessOrder = nextInAccessOrder;
    }

    @Override
    public long getVariableTime() {
        return ACCESS_TIME.get(this);
    }

    @Override
    public void setVariableTime(long accessTime) {
        ACCESS_TIME.set(this, accessTime);
    }

    @Override
    public boolean casVariableTime(long expect, long update2) {
        return this.accessTime == expect && ACCESS_TIME.compareAndSet(this, expect, update2);
    }

    @Override
    public final long getAccessTime() {
        return ACCESS_TIME.get(this);
    }

    @Override
    public final void setAccessTime(long accessTime) {
        ACCESS_TIME.set(this, accessTime);
    }

    @Override
    public final Node<K, V> getPreviousInAccessOrder() {
        return this.previousInAccessOrder;
    }

    @Override
    public final void setPreviousInAccessOrder(Node<K, V> previousInAccessOrder) {
        this.previousInAccessOrder = previousInAccessOrder;
    }

    @Override
    public final Node<K, V> getNextInAccessOrder() {
        return this.nextInAccessOrder;
    }

    @Override
    public final void setNextInAccessOrder(Node<K, V> nextInAccessOrder) {
        this.nextInAccessOrder = nextInAccessOrder;
    }

    @Override
    public Node<K, V> newNode(K key2, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new PSA<K, V>(key2, keyReferenceQueue, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new PSA<K, V>(keyReference, value, valueReferenceQueue, weight, now);
    }

    static {
        MethodHandles.Lookup lookup2 = MethodHandles.lookup();
        try {
            ACCESS_TIME = lookup2.findVarHandle(PSA.class, "accessTime", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

