/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Node;
import com.github.benmanes.caffeine.cache.PWA;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;

class PWAW<K, V>
extends PWA<K, V> {
    protected static final VarHandle WRITE_TIME;
    volatile long writeTime;
    Node<K, V> previousInWriteOrder;
    Node<K, V> nextInWriteOrder;

    PWAW() {
    }

    PWAW(K key2, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key2, keyReferenceQueue, value, valueReferenceQueue, weight, now);
        WRITE_TIME.set(this, now);
    }

    PWAW(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value, valueReferenceQueue, weight, now);
        WRITE_TIME.set(this, now);
    }

    @Override
    public Node<K, V> getPreviousInVariableOrder() {
        return this.previousInWriteOrder;
    }

    @Override
    public void setPreviousInVariableOrder(Node<K, V> previousInWriteOrder) {
        this.previousInWriteOrder = previousInWriteOrder;
    }

    @Override
    public Node<K, V> getNextInVariableOrder() {
        return this.nextInWriteOrder;
    }

    @Override
    public void setNextInVariableOrder(Node<K, V> nextInWriteOrder) {
        this.nextInWriteOrder = nextInWriteOrder;
    }

    @Override
    public long getVariableTime() {
        return WRITE_TIME.get(this);
    }

    @Override
    public void setVariableTime(long writeTime) {
        WRITE_TIME.set(this, writeTime);
    }

    @Override
    public boolean casVariableTime(long expect, long update2) {
        return this.writeTime == expect && WRITE_TIME.compareAndSet(this, expect, update2);
    }

    @Override
    public final long getWriteTime() {
        return WRITE_TIME.get(this);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        WRITE_TIME.set(this, writeTime);
    }

    @Override
    public final Node<K, V> getPreviousInWriteOrder() {
        return this.previousInWriteOrder;
    }

    @Override
    public final void setPreviousInWriteOrder(Node<K, V> previousInWriteOrder) {
        this.previousInWriteOrder = previousInWriteOrder;
    }

    @Override
    public final Node<K, V> getNextInWriteOrder() {
        return this.nextInWriteOrder;
    }

    @Override
    public final void setNextInWriteOrder(Node<K, V> nextInWriteOrder) {
        this.nextInWriteOrder = nextInWriteOrder;
    }

    @Override
    public Node<K, V> newNode(K key2, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new PWAW<K, V>(key2, keyReferenceQueue, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new PWAW<K, V>(keyReference, value, valueReferenceQueue, weight, now);
    }

    static {
        MethodHandles.Lookup lookup2 = MethodHandles.lookup();
        try {
            WRITE_TIME = lookup2.findVarHandle(PWAW.class, "writeTime", Long.TYPE);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

