/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.MapIteratorCache;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

class MapRetrievalCache<K, V>
extends MapIteratorCache<K, V> {
    private volatile transient @Nullable CacheEntry<K, V> cacheEntry1;
    private volatile transient @Nullable CacheEntry<K, V> cacheEntry2;

    MapRetrievalCache(Map<K, V> backingMap) {
        super(backingMap);
    }

    @Override
    public V get(@Nullable Object key2) {
        V value = this.getIfCached(key2);
        if (value != null) {
            return value;
        }
        value = this.getWithoutCaching(key2);
        if (value != null) {
            this.addToCache(key2, value);
        }
        return value;
    }

    @Override
    protected V getIfCached(@Nullable Object key2) {
        Object value = super.getIfCached(key2);
        if (value != null) {
            return value;
        }
        CacheEntry<K, V> entry = this.cacheEntry1;
        if (entry != null && entry.key == key2) {
            return entry.value;
        }
        entry = this.cacheEntry2;
        if (entry != null && entry.key == key2) {
            this.addToCache(entry);
            return entry.value;
        }
        return null;
    }

    @Override
    protected void clearCache() {
        super.clearCache();
        this.cacheEntry1 = null;
        this.cacheEntry2 = null;
    }

    private void addToCache(K key2, V value) {
        this.addToCache(new CacheEntry<K, V>(key2, value));
    }

    private void addToCache(CacheEntry<K, V> entry) {
        this.cacheEntry2 = this.cacheEntry1;
        this.cacheEntry1 = entry;
    }

    private static final class CacheEntry<K, V> {
        final K key;
        final V value;

        CacheEntry(K key2, V value) {
            this.key = key2;
            this.value = value;
        }
    }
}

