/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import com.google.gson.internal.LinkedTreeMap;
import java.util.Map;
import java.util.Set;

public final class JsonObject
extends JsonElement {
    private final LinkedTreeMap<String, JsonElement> members = new LinkedTreeMap();

    @Override
    JsonObject deepCopy() {
        JsonObject result2 = new JsonObject();
        for (Map.Entry<String, JsonElement> entry : this.members.entrySet()) {
            result2.add(entry.getKey(), entry.getValue().deepCopy());
        }
        return result2;
    }

    public void add(String property2, JsonElement value) {
        if (value == null) {
            value = JsonNull.INSTANCE;
        }
        this.members.put(property2, value);
    }

    public JsonElement remove(String property2) {
        return this.members.remove(property2);
    }

    public void addProperty(String property2, String value) {
        this.add(property2, this.createJsonElement(value));
    }

    public void addProperty(String property2, Number value) {
        this.add(property2, this.createJsonElement(value));
    }

    public void addProperty(String property2, Boolean value) {
        this.add(property2, this.createJsonElement(value));
    }

    public void addProperty(String property2, Character value) {
        this.add(property2, this.createJsonElement(value));
    }

    private JsonElement createJsonElement(Object value) {
        return value == null ? JsonNull.INSTANCE : new JsonPrimitive(value);
    }

    public Set<Map.Entry<String, JsonElement>> entrySet() {
        return this.members.entrySet();
    }

    public int size() {
        return this.members.size();
    }

    public boolean has(String memberName) {
        return this.members.containsKey(memberName);
    }

    public JsonElement get(String memberName) {
        return this.members.get(memberName);
    }

    public JsonPrimitive getAsJsonPrimitive(String memberName) {
        return (JsonPrimitive)this.members.get(memberName);
    }

    public JsonArray getAsJsonArray(String memberName) {
        return (JsonArray)this.members.get(memberName);
    }

    public JsonObject getAsJsonObject(String memberName) {
        return (JsonObject)this.members.get(memberName);
    }

    public boolean equals(Object o) {
        return o == this || o instanceof JsonObject && ((JsonObject)o).members.equals(this.members);
    }

    public int hashCode() {
        return this.members.hashCode();
    }
}

