/*
 * Decompiled with CFR 0.152.
 */
package com.zlab;

import com.zlab.ExtensionsKt;
import com.zlab.MainPreferences;
import com.zlab.PlayerEvent;
import com.zlab.bus.EventBus;
import com.zlab.enum.TRACK;
import com.zlab.model.KeyEntry;
import com.zlab.model.PlayableChannel;
import com.zlab.model.Settings;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\bH\u0002J\b\u0010\"\u001a\u00020\u001dH\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\u0010\u0010$\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\bH\u0002J\b\u0010%\u001a\u00020\u001dH\u0002J\u0018\u0010&\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010\bR\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u000f\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\b0\rX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000f\"\u0004\b\u0016\u0010\u0013R\u0016\u0010\u0017\u001a\n \u0019*\u0004\u0018\u00010\u00180\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/zlab/CommandBuilder;", "", "settings", "Lcom/zlab/model/Settings;", "playableChannel", "Lcom/zlab/model/PlayableChannel;", "(Lcom/zlab/model/Settings;Lcom/zlab/model/PlayableChannel;)V", "aKey", "", "aKeyAssigned", "", "channelPath", "copierCommand", "", "getCopierCommand", "()Ljava/util/List;", "decoderCommand", "getDecoderCommand", "setDecoderCommand", "(Ljava/util/List;)V", "ffmpegDownloaderCommand", "getFfmpegDownloaderCommand", "setFfmpegDownloaderCommand", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "vKey", "vKeyAssigned", "assignDefaultKeys", "", "assignKey", "track", "Lcom/zlab/enum/TRACK;", "key", "buildDecoderCommand", "buildFfmpegDownloaderCommand", "getDecoderCommandTest", "handleUnprotected", "keyAssignCallback", "kid", "player"})
public final class CommandBuilder {
    @NotNull
    private final PlayableChannel playableChannel;
    @Nullable
    private String vKey;
    @Nullable
    private String aKey;
    private boolean vKeyAssigned;
    private boolean aKeyAssigned;
    private final Logger logger;
    @NotNull
    private final String channelPath;
    @NotNull
    private final List<String> copierCommand;
    public List<String> decoderCommand;
    public List<String> ffmpegDownloaderCommand;

    public CommandBuilder(@NotNull Settings settings2, @NotNull PlayableChannel playableChannel) {
        List<String> list;
        Intrinsics.checkNotNullParameter(settings2, "settings");
        Intrinsics.checkNotNullParameter(playableChannel, "playableChannel");
        this.playableChannel = playableChannel;
        this.logger = LoggerFactory.getLogger("Main.CommandBuilder");
        String string = MainPreferences.INSTANCE.getRamdiskPath();
        Intrinsics.checkNotNullExpressionValue(string, "MainPreferences.ramdiskPath");
        this.channelPath = StringsKt.removeSuffix(string, (CharSequence)"/") + "/" + this.playableChannel.getId();
        if (Intrinsics.areEqual(this.playableChannel.getProvider().getFormat(), "HLS")) {
            String[] stringArray = new String[]{"/bin/bash", "-c", "ffmpeg -y -v fatal -hide_banner -nostats -progress pipe:2 -stats_period 1s -re -thread_queue_size 1024 -i - -c copy -sc_threshold 0 -hls_flags delete_segments -hls_time " + settings2.getHlsSegmentDuration() + " -hls_list_size " + settings2.getHlsListSize() + " " + this.channelPath + "/playlist.m3u8"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            String[] stringArray = new String[]{"/bin/bash", "-c", "ffmpeg -v fatal -hide_banner -nostats -progress pipe:2 -stats_period 1s -re -thread_queue_size 1024 -i - -metadata service_name=\"" + this.playableChannel.getName() + "\" -metadata service_provider=\"" + this.playableChannel.getProvider().getName() + "\" -c copy -f mpegts -"};
            list = CollectionsKt.listOf(stringArray);
        }
        this.copierCommand = list;
    }

    @NotNull
    public final List<String> getCopierCommand() {
        return this.copierCommand;
    }

    @NotNull
    public final List<String> getDecoderCommand() {
        List<String> list = this.decoderCommand;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("decoderCommand");
        return null;
    }

    public final void setDecoderCommand(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.decoderCommand = list;
    }

    @NotNull
    public final List<String> getFfmpegDownloaderCommand() {
        List<String> list = this.ffmpegDownloaderCommand;
        if (list != null) {
            return list;
        }
        Intrinsics.throwUninitializedPropertyAccessException("ffmpegDownloaderCommand");
        return null;
    }

    public final void setFfmpegDownloaderCommand(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.ffmpegDownloaderCommand = list;
    }

    private final void assignKey(TRACK track, String key2) {
        switch (WhenMappings.$EnumSwitchMapping$0[track.ordinal()]) {
            case 1: {
                this.vKey = key2;
                this.vKeyAssigned = true;
                break;
            }
            case 2: {
                this.aKey = key2;
                this.aKeyAssigned = true;
            }
        }
        this.logger.info("Key: " + key2 + " assigned for " + track + " track", (Object)this.playableChannel, (Object)"AssignKeys");
        if (this.vKeyAssigned && this.aKeyAssigned) {
            this.buildDecoderCommand();
            this.buildFfmpegDownloaderCommand();
        }
    }

    private final void handleUnprotected() {
        this.vKey = "";
        this.aKey = "";
        this.buildDecoderCommand();
    }

    private final void buildDecoderCommand() {
        List<String> list;
        String[] stringArray = (String[])this.vKey;
        if (stringArray == null || stringArray.length() == 0) {
            stringArray = new String[]{"/bin/bash", "-c", "ffmpeg -v warning -hide_banner -nostats -i " + this.channelPath + "/v.mp4 -i " + this.channelPath + "/a.mp4 -c copy -f mpegts -"};
            list = CollectionsKt.listOf(stringArray);
        } else {
            String string = this.aKey;
            if (string == null) {
                string = this.vKey;
            }
            String command2 = "ffmpeg -v warning -hide_banner -nostats -decryption_key " + this.vKey + " -i " + this.channelPath + "/v.mp4 -decryption_key " + string + " -i " + this.channelPath + "/a.mp4 -preset ultrafast -c copy -f mpegts -";
            System.out.println((Object)("Dec command: " + command2));
            String[] stringArray2 = new String[]{"/bin/bash", "-c", command2};
            list = CollectionsKt.listOf(stringArray2);
        }
        this.setDecoderCommand(list);
    }

    private final void buildFfmpegDownloaderCommand() {
        String[] stringArray = new String[]{"/bin/bash", "-c", "ffmpeg -v fatal -user_agent \"Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/16.0 Safari/605.1.15\" -cenc_decryption_key \"" + this.vKey + "\" -i \"" + this.playableChannel.getUrl() + "\" -c copy -f mpegts -"};
        this.setFfmpegDownloaderCommand(CollectionsKt.listOf(stringArray));
    }

    private final String getDecoderCommandTest(String channelPath) {
        return "ffmpeg -v debug -hide_banner -nostats -f h264 -i " + channelPath + "/v.mp4 -c:v libx264 -preset ultrafast -b:v 8M -f mpegts -";
    }

    public final void keyAssignCallback(@NotNull TRACK track, @Nullable String kid) {
        Object v2;
        block7: {
            Intrinsics.checkNotNullParameter((Object)track, "track");
            Iterable iterable = this.playableChannel.getKeys();
            for (Object t : iterable) {
                KeyEntry it = (KeyEntry)t;
                boolean bl = false;
                String string = it.getType();
                String string2 = track.name().toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue(string2, "this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (!Intrinsics.areEqual(string, string2)) continue;
                v2 = t;
                break block7;
            }
            v2 = null;
        }
        KeyEntry forcedKey = v2;
        if (forcedKey != null) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            ExtensionsKt.showInfo(logger, "Found forced key: " + forcedKey.getKey() + " for " + track + " track.", this.playableChannel, "AssignKeys");
            this.assignKey(track, forcedKey.getKey());
            return;
        }
        if (kid != null) {
            String key2;
            Object v6;
            block8: {
                String normalizedKid = StringsKt.replace$default(kid, "-", "", false, 4, null);
                Iterable iterable = this.playableChannel.getKeys();
                for (Object t : iterable) {
                    KeyEntry it = (KeyEntry)t;
                    boolean bl = false;
                    String string = it.getKid();
                    boolean bl2 = string != null ? StringsKt.equals(string, normalizedKid, true) : false;
                    if (!bl2) continue;
                    v6 = t;
                    break block8;
                }
                v6 = null;
            }
            KeyEntry keyEntry = v6;
            String string = key2 = keyEntry != null ? keyEntry.getKey() : null;
            if (key2 != null) {
                this.assignKey(track, key2);
            } else {
                this.assignDefaultKeys();
            }
        } else {
            this.assignDefaultKeys();
        }
    }

    private final void assignDefaultKeys() {
        int keysCount = this.playableChannel.getKeys().size();
        if (keysCount > 1) {
            BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ CommandBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            this.label = 1;
                            Object object3 = EventBus.INSTANCE.emitEvent(new PlayerEvent.Stop(CommandBuilder.access$getPlayableChannel$p(this.this$0).getId()), this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null);
        } else if (keysCount == 1) {
            this.assignKey(TRACK.VIDEO, CollectionsKt.first(this.playableChannel.getKeys()).getKey());
            this.assignKey(TRACK.AUDIO, CollectionsKt.first(this.playableChannel.getKeys()).getKey());
        } else if (keysCount == 0) {
            this.handleUnprotected();
        }
    }

    public static final /* synthetic */ PlayableChannel access$getPlayableChannel$p(CommandBuilder $this) {
        return $this.playableChannel;
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TRACK.values().length];
            try {
                nArray[TRACK.VIDEO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TRACK.AUDIO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

