/*
 * Decompiled with CFR 0.152.
 */
package com.zlab;

import com.zlab.Downloader;
import com.zlab.ExtensionsKt;
import com.zlab.SegmentInfo;
import com.zlab.enum.MpdType;
import com.zlab.enum.TRACK;
import com.zlab.model.PlayableChannel;
import com.zlab.model.TimeLineItem;
import com.zlab.model.TimelinePair;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.LongRange;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ReceiveChannel;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0019\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0019\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001dJ\u0006\u0010\u001e\u001a\u00020\u0013J\u000e\u0010\u001f\u001a\u00020\u00152\u0006\u0010 \u001a\u00020!R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \u0011*\u0004\u0018\u00010\u00100\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\""}, d2={"Lcom/zlab/Downloader;", "", "playableChannel", "Lcom/zlab/model/PlayableChannel;", "segmentInfo", "Lcom/zlab/SegmentInfo;", "(Lcom/zlab/model/PlayableChannel;Lcom/zlab/SegmentInfo;)V", "availabilityChecking", "", "buf", "Lkotlinx/coroutines/channels/Channel;", "Lcom/zlab/model/TimelinePair;", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "isOnline", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "download", "", "newItemsCount", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "downloadDynamic", "downloadPair", "Lkotlinx/coroutines/Job;", "timeLinePair", "(Lcom/zlab/model/TimelinePair;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getItemsFlow", "Lkotlinx/coroutines/flow/Flow;", "stopWorking", "syncWithWindow", "timeLineItem", "Lcom/zlab/model/TimeLineItem;", "player"})
public final class Downloader {
    @NotNull
    private final PlayableChannel playableChannel;
    @NotNull
    private final SegmentInfo segmentInfo;
    private boolean isOnline;
    private final boolean availabilityChecking;
    private final Logger logger;
    @NotNull
    private AtomicInteger counter;
    @NotNull
    private final Channel<TimelinePair> buf;

    public Downloader(@NotNull PlayableChannel playableChannel, @NotNull SegmentInfo segmentInfo) {
        Intrinsics.checkNotNullParameter(playableChannel, "playableChannel");
        Intrinsics.checkNotNullParameter(segmentInfo, "segmentInfo");
        this.playableChannel = playableChannel;
        this.segmentInfo = segmentInfo;
        this.isOnline = true;
        this.availabilityChecking = this.playableChannel.getProvider().getAvailabilityCheck();
        this.logger = LoggerFactory.getLogger("Main.Downloader");
        this.counter = new AtomicInteger(0);
        this.buf = ChannelKt.Channel(3, BufferOverflow.SUSPEND, (Function1)new Function1<TimelinePair, Unit>(this){
            final /* synthetic */ Downloader this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull TimelinePair p) {
                Intrinsics.checkNotNullParameter(p, "p");
                Logger logger = Downloader.access$getLogger$p(this.this$0);
                Intrinsics.checkNotNullExpressionValue(logger, "logger");
                ExtensionsKt.showError(logger, "Undelivered V " + p.getVItem().getPresentationTime(), Downloader.access$getPlayableChannel$p(this.this$0), null, "Buffering");
            }
        });
    }

    @NotNull
    public final Flow<TimelinePair> getItemsFlow() {
        return FlowKt.consumeAsFlow((ReceiveChannel)this.buf);
    }

    public final void stopWorking() {
        this.isOnline = false;
        this.counter.set(0);
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        ExtensionsKt.showInfo(logger, "Downloader stopped", this.playableChannel, "Stop working");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object downloadDynamic(int var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof downloadDynamic.1)) ** GOTO lbl-1000
        var4_3 = var2_2;
        if ((var4_3.label & -2147483648) != 0) {
            var4_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                /* synthetic */ Object result;
                final /* synthetic */ Downloader this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.downloadDynamic(0, this);
                }
            };
        }
        $result = $continuation.result;
        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                this.isOnline = true;
                v0 = this.logger;
                Intrinsics.checkNotNullExpressionValue(v0, "logger");
                ExtensionsKt.showInfo(v0, "First manifest download. Get " + (int)newItemsCount + " segments", this.playableChannel, "Download dynamic");
                $continuation.label = 1;
                v1 = this.download((int)newItemsCount, $continuation);
                if (v1 == var5_5) {
                    return var5_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl24:
                // 2 sources

                System.out.println((Object)"Exit collect");
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object download(int var1_1, Continuation<? super Unit> var2_2) {
        block20: {
            if (!(var2_2 instanceof download.1)) ** GOTO lbl-1000
            var15_3 = var2_2;
            if ((var15_3.label & -2147483648) != 0) {
                var15_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int I$0;
                    int I$1;
                    long J$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ Downloader this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return Downloader.access$download(this.this$0, 0, this);
                    }
                };
            }
            $result = $continuation.result;
            var16_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            block2 : switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    elapsed = newItemsCount;
lbl13:
                    // 5 sources

                    while (this.isOnline) {
                        if (elapsed == 0) {
                            v0 = this.logger;
                            Intrinsics.checkNotNullExpressionValue(v0, "logger");
                            ExtensionsKt.showInfo(v0, "Buffer empty ? " + this.buf.isEmpty(), this.playableChannel, "Download");
                        }
                        if ((timeLinePair = this.segmentInfo.getTimeLinePair(this.counter.get())) == null) break block2;
                        v1 = this.logger;
                        Intrinsics.checkNotNullExpressionValue(v1, "logger");
                        ExtensionsKt.showInfo(v1, "Counter " + this.counter + " Elapsed " + elapsed + " Start number V " + timeLinePair.getVItem().getStartNumber() + " A " + timeLinePair.getAItem().getStartNumber() + " NOW " + this.segmentInfo.getLiveEdge() + " SEG PT V " + timeLinePair.getVItem().getPresentationTime() + " A " + timeLinePair.getAItem().getPresentationTime(), this.playableChannel, "Buffer filling");
                        windowCheck = this.segmentInfo.getType() == MpdType.NUMBERED || this.availabilityChecking == false ? 0 : this.syncWithWindow(timeLinePair.getVItem());
                        System.out.println((Object)("Window check " + windowCheck));
                        if (windowCheck != 0) break block2;
                        $i$a$-runCatching-Downloader$download$2 = false;
                        v2 = this.logger;
                        Intrinsics.checkNotNullExpressionValue(v2, "logger");
                        ExtensionsKt.showInfo(v2, "Downloading " + timeLinePair.getVItem().getUrl(), this.playableChannel, "Prepare pair");
                        $i$f$measureTimeMillis = false;
                        start$iv = System.currentTimeMillis();
                        $i$a$-measureTimeMillis-Downloader$download$2$time$1 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = timeLinePair;
                        $continuation.L$2 = null;
                        $continuation.I$0 = elapsed;
                        $continuation.J$0 = start$iv;
                        $continuation.label = 1;
                        v3 = this.downloadPair(timeLinePair, $continuation);
                        ** if (v3 != var16_5) goto lbl45
lbl44:
                        // 1 sources

                        return var16_5;
lbl45:
                        // 1 sources

                        ** GOTO lbl59
                    }
                    break;
                }
                case 1: {
                    $i$a$-runCatching-Downloader$download$2 = false;
                    $i$f$measureTimeMillis = false;
                    $i$a$-measureTimeMillis-Downloader$download$2$time$1 = false;
                    start$iv = $continuation.J$0;
                    elapsed = $continuation.I$0;
                    timeLinePair = (TimelinePair)$continuation.L$1;
                    this = (Downloader)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl59:
                        // 2 sources

                        time = System.currentTimeMillis() - start$iv;
                        v4 = this.logger;
                        Intrinsics.checkNotNullExpressionValue(v4, "logger");
                        ExtensionsKt.showDebug(v4, "Pair downloaded with " + time + " ms", this.playableChannel, null, "Download pair");
                        $i$a$-runCatching-Downloader$download$2 = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable var7_13) {
                        $i$a$-runCatching-Downloader$download$2 = Result.constructor-impl(ResultKt.createFailure(var7_13));
                    }
                    if (!Result.isSuccess-impl($i$a$-runCatching-Downloader$download$2)) ** GOTO lbl92
                    (Unit)$i$a$-runCatching-Downloader$download$2;
                    $i$a$-onSuccess-Downloader$download$3 = false;
                    $continuation.L$0 = this;
                    $continuation.L$1 = timeLinePair;
                    $continuation.L$2 = $i$a$-runCatching-Downloader$download$2;
                    $continuation.I$0 = elapsed;
                    $continuation.label = 2;
                    v5 = this.buf.send(timeLinePair, $continuation);
                    if (v5 == var16_5) {
                        return var16_5;
                    }
                    ** GOTO lbl90
                }
                case 2: {
                    $i$a$-onSuccess-Downloader$download$3 = false;
                    elapsed = $continuation.I$0;
                    $i$a$-runCatching-Downloader$download$2 = $continuation.L$2;
                    timeLinePair = (TimelinePair)$continuation.L$1;
                    this = (Downloader)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v5 = $result;
lbl90:
                    // 2 sources

                    this.segmentInfo.updateStartTime(timeLinePair);
lbl92:
                    // 2 sources

                    if (Result.exceptionOrNull-impl($i$a$-runCatching-Downloader$download$2) != null) {
                        it = var7_12;
                        $i$a$-onFailure-Downloader$download$4 = false;
                        this.segmentInfo.updateStartTime(timeLinePair);
                        v6 = this.logger;
                        Intrinsics.checkNotNullExpressionValue(v6, "logger");
                        v7 = it.getMessage();
                        if (v7 == null) {
                            v7 = "Unknown error";
                        }
                        ExtensionsKt.showError(v6, v7, this.playableChannel, null, "Download pair");
                    }
                    this.counter.incrementAndGet();
                    --elapsed;
                    ** GOTO lbl13
                }
            }
            if (windowCheck <= 0) break block20;
            v8 = this.logger;
            Intrinsics.checkNotNullExpressionValue(v8, "logger");
            ExtensionsKt.showWarning(v8, "Skip it", this.playableChannel, "Download");
            this.counter.incrementAndGet();
            --elapsed;
            ** GOTO lbl13
        }
        delay = Math.abs(windowCheck);
        $continuation.L$0 = this;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.I$0 = elapsed;
        $continuation.I$1 = delay;
        $continuation.label = 3;
        v9 = DelayKt.delay(delay, $continuation);
        if (v9 == var16_5) {
            return var16_5;
        }
        ** GOTO lbl133
        {
            case 3: {
                delay = $continuation.I$1;
                elapsed = $continuation.I$0;
                this = (Downloader)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v9 = $result;
lbl133:
                // 2 sources

                v10 = this.logger;
                Intrinsics.checkNotNullExpressionValue(v10, "logger");
                ExtensionsKt.showInfo$default(v10, "Window check error!! Delay " + delay, this.playableChannel, null, 4, null);
                ** GOTO lbl13
            }
        }
        this.segmentInfo.clearTimeLine();
        this.counter.set(0);
        $continuation.L$0 = this;
        $continuation.L$1 = null;
        $continuation.L$2 = null;
        $continuation.label = 4;
        v11 = this.segmentInfo.getNewItems(System.currentTimeMillis(), $continuation);
        if (v11 == var16_5) {
            return var16_5;
        }
        ** GOTO lbl151
        {
            case 4: {
                this = (Downloader)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v11 = $result;
lbl151:
                // 2 sources

                elapsed = ((Number)v11).intValue();
                ** GOTO lbl13
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final Object downloadPair(TimelinePair timeLinePair, Continuation<? super Job> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)new Function2<CoroutineScope, Continuation<? super Job>, Object>(this, timeLinePair, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ Downloader this$0;
            final /* synthetic */ TimelinePair $timeLinePair;
            {
                this.this$0 = $receiver;
                this.$timeLinePair = $timeLinePair;
                super(2, $completion);
            }

            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        Job job2;
                        ResultKt.throwOnFailure(object);
                        CoroutineScope $this$coroutineScope = (CoroutineScope)this.L$0;
                        try {
                            BuildersKt.launch$default($this$coroutineScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$timeLinePair, null){
                                int label;
                                final /* synthetic */ Downloader this$0;
                                final /* synthetic */ TimelinePair $timeLinePair;
                                {
                                    this.this$0 = $receiver;
                                    this.$timeLinePair = $timeLinePair;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = Downloader.access$getSegmentInfo$p(this.this$0).getHttpClient().getBytesAsync(this.$timeLinePair.getVItem(), Downloader.access$getSegmentInfo$p(this.this$0).getInitBytes(TRACK.VIDEO), this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 3, null);
                            job2 = BuildersKt.launch$default($this$coroutineScope, null, null, new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this.$timeLinePair, null){
                                int label;
                                final /* synthetic */ Downloader this$0;
                                final /* synthetic */ TimelinePair $timeLinePair;
                                {
                                    this.this$0 = $receiver;
                                    this.$timeLinePair = $timeLinePair;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - void declaration
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object object) {
                                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure(object);
                                            this.label = 1;
                                            Object object3 = Downloader.access$getSegmentInfo$p(this.this$0).getHttpClient().getBytesAsync(this.$timeLinePair.getAItem(), Downloader.access$getSegmentInfo$p(this.this$0).getInitBytes(TRACK.AUDIO), this);
                                            if (object3 != object2) return Unit.INSTANCE;
                                            return object2;
                                        }
                                        case 1: {
                                            void $result;
                                            ResultKt.throwOnFailure($result);
                                            Object object3 = $result;
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }, 3, null);
                        }
                        catch (Exception e) {
                            Logger logger = Downloader.access$getLogger$p(this.this$0);
                            Intrinsics.checkNotNullExpressionValue(logger, "logger");
                            String string = e.getMessage();
                            if (string == null) {
                                string = "UNKNOWN ERROR";
                            }
                            ExtensionsKt.showError$default(logger, string, Downloader.access$getPlayableChannel$p(this.this$0), null, "Download", 4, null);
                            throw e;
                        }
                        return job2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return var3_3;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Job> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, $completion);
    }

    public final int syncWithWindow(@NotNull TimeLineItem timeLineItem) {
        int n;
        Intrinsics.checkNotNullParameter(timeLineItem, "timeLineItem");
        String op = "Check in window";
        long now = Instant.now().toEpochMilli();
        LongRange w = new LongRange(now - this.segmentInfo.getWindowStart(), now);
        LongRange i = new LongRange(timeLineItem.getPresentationTime(), timeLineItem.getPresentationTime() + this.segmentInfo.getMaxSegmentDurationMs());
        long windowSize = w.getFirst() - w.getLast();
        if (i.getFirst() >= w.getFirst() && i.getLast() < w.getLast()) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            ExtensionsKt.showInfo(logger, "Segment " + i + " in window " + w.getFirst() + " - " + w.getLast() + " WS: " + windowSize + " TO END: " + (w.getLast() - i.getLast()), this.playableChannel, op);
            n = false;
        } else if (i.getLast() > w.getLast()) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            ExtensionsKt.showInfo(logger, "End of segment " + i + " goes out of window " + w.getFirst() + " - " + w.getLast() + " " + windowSize, this.playableChannel, op);
            n = (int)(w.getLast() - i.getLast());
        } else if (i.getLast() == w.getLast()) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            ExtensionsKt.showInfo(logger, "End of segment " + i + " matches end of window " + w.getFirst() + " - " + w.getLast() + " " + windowSize, this.playableChannel, op);
            n = -1;
        } else if (i.getFirst() < w.getFirst()) {
            Logger logger = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger, "logger");
            ExtensionsKt.showInfo(logger, "The beginning of the " + i + " segment goes beyond the beginning of the window " + w.getFirst() + " - " + w.getLast() + " " + windowSize, this.playableChannel, op);
            n = (int)(w.getFirst() - i.getFirst());
        } else {
            throw new Exception("Unknown window " + w.getFirst() + " - " + w.getLast() + " " + windowSize + " item " + i);
        }
        return n;
    }

    public static final /* synthetic */ Object access$download(Downloader $this, int newItemsCount2, Continuation $completion) {
        return $this.download(newItemsCount2, $completion);
    }

    public static final /* synthetic */ Object access$downloadPair(Downloader $this, TimelinePair timeLinePair, Continuation $completion) {
        return $this.downloadPair(timeLinePair, $completion);
    }

    public static final /* synthetic */ SegmentInfo access$getSegmentInfo$p(Downloader $this) {
        return $this.segmentInfo;
    }

    public static final /* synthetic */ Logger access$getLogger$p(Downloader $this) {
        return $this.logger;
    }

    public static final /* synthetic */ PlayableChannel access$getPlayableChannel$p(Downloader $this) {
        return $this.playableChannel;
    }
}

