/*
 * Decompiled with CFR 0.152.
 */
package com.zlab;

import com.zlab.ExtensionsKt;
import com.zlab.MediaTrack;
import com.zlab.enum.TRACK;
import com.zlab.model.PlayableChannel;
import com.zlab.model.TimeLineItem;
import com.zlab.mpd.data.AdaptationSet;
import com.zlab.mpd.data.Period;
import com.zlab.mpd.data.Representation;
import com.zlab.mpd.data.Segment;
import com.zlab.mpd.data.SegmentTemplate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000f\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J'\u0010=\u001a\u00020\b2\b\u0010>\u001a\u0004\u0018\u00010\u000e2\u0006\u0010/\u001a\u0002002\u0006\u0010?\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010@J-\u0010A\u001a\u00020\u00112\u0006\u0010/\u001a\u00020\u00112\n\b\u0002\u0010B\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010C\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010DJ\u0019\u0010E\u001a\u00020\b2\u0006\u0010?\u001a\u00020\u000eH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010FJ\u0006\u0010G\u001a\u00020HJ\u000e\u0010I\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000eJ\u0010\u0010J\u001a\u0004\u0018\u0001042\u0006\u0010K\u001a\u00020\bJ\u0010\u0010L\u001a\u0004\u0018\u0001042\u0006\u0010C\u001a\u00020\u000eJ\u0010\u0010M\u001a\u0004\u0018\u0001042\u0006\u0010N\u001a\u00020\u000eJ\u001f\u0010O\u001a\u00020\u000e2\u0006\u0010B\u001a\u00020\u000e2\b\u0010C\u001a\u0004\u0018\u00010\u000eH\u0002\u00a2\u0006\u0002\u0010PJ;\u0010Q\u001a\u00020H2(\u0010R\u001a$\b\u0001\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180U0T\u0012\u0006\u0012\u0004\u0018\u00010\u00010SH\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010VJ-\u0010W\u001a\u00020\b2\f\u0010X\u001a\b\u0012\u0004\u0012\u00020Z0Y2\b\u0010C\u001a\u0004\u0018\u00010\u000e2\u0006\u0010?\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010[J.\u0010\\\u001a\u00020H2\u0006\u0010]\u001a\u00020^2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u000eJ\u0016\u0010_\u001a\u00020H2\u0006\u0010`\u001a\u00020\b2\u0006\u0010a\u001a\u00020\bJ\u000e\u0010b\u001a\u00020H2\u0006\u0010]\u001a\u00020^J\u000e\u0010c\u001a\u00020H2\u0006\u0010d\u001a\u000204JB\u0010e\u001a\u0002Hf\"\u0004\b\u0000\u0010f\"\u000e\b\u0001\u0010g*\b\u0012\u0004\u0012\u0002Hg0h*\b\u0012\u0004\u0012\u0002Hf0i2\u0012\u0010j\u001a\u000e\u0012\u0004\u0012\u0002Hf\u0012\u0004\u0012\u0002Hg0kH\u0082\b\u00a2\u0006\u0002\u0010lR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u0016\u0010 \u001a\n \"*\u0004\u0018\u00010!0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010$\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010%\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010(\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010)\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010*\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\n\"\u0004\b,\u0010\fR\u000e\u0010-\u001a\u00020.X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R \u00102\u001a\b\u0012\u0004\u0012\u00020403X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u00109\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010:\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006m"}, d2={"Lcom/zlab/MediaTrack;", "", "type", "Lcom/zlab/enum/TRACK;", "playableChannel", "Lcom/zlab/model/PlayableChannel;", "(Lcom/zlab/enum/TRACK;Lcom/zlab/model/PlayableChannel;)V", "adaptationIndex", "", "getAdaptationIndex", "()I", "setAdaptationIndex", "(I)V", "availabilityStartTimeMs", "", "availabilityStartTimeSec", "bandwidth", "", "baseUrl", "firstStart", "", "fragmentDuration", "Ljava/lang/Long;", "initBytes", "", "getInitBytes", "()[B", "setInitBytes", "([B)V", "initTemplate", "lastNumber", "lastStartTime", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "maxSegmentDurationMs", "mostRecentNumber", "periodStartMs", "periodStartSec", "presentationDelayMs", "presentationOffset", "representationId", "representationIndex", "getRepresentationIndex", "setRepresentationIndex", "segmentDurationSec", "", "segmentTemplate", "Lcom/zlab/mpd/data/SegmentTemplate;", "template", "timeline", "", "Lcom/zlab/model/TimeLineItem;", "getTimeline", "()Ljava/util/List;", "setTimeline", "(Ljava/util/List;)V", "timescale", "trimToLive", "getType", "()Lcom/zlab/enum/TRACK;", "buildFullTimeLine", "lastStartNumber", "nowMs", "(Ljava/lang/Long;Lcom/zlab/mpd/data/SegmentTemplate;J)I", "buildHttpUrl", "startTime", "startNumber", "(Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;)Ljava/lang/String;", "buildTimeline", "(JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "clearTimeline", "", "getLiveEdge", "getPairByIndex", "index", "getPairByNumber", "getPairByPt", "presentationTime", "getPresentationTime", "(JLjava/lang/Long;)J", "loadInitBytes", "downloader", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlinx/coroutines/Deferred;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseTimeline", "segments", "", "Lcom/zlab/mpd/data/Segment;", "(Ljava/util/List;Ljava/lang/Long;J)I", "settingUp", "period", "Lcom/zlab/mpd/data/Period;", "setupAdaptationAndRepresentationIndex", "adaptIndex", "repIndex", "updatePeriod", "updateStartTime", "item", "findClosest", "T", "R", "", "", "selector", "Lkotlin/Function1;", "(Ljava/lang/Iterable;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "player"})
public final class MediaTrack {
    @NotNull
    private final TRACK type;
    @NotNull
    private final PlayableChannel playableChannel;
    private final Logger logger;
    @NotNull
    private String baseUrl;
    @Nullable
    private Long lastNumber;
    @Nullable
    private Long lastStartTime;
    @Nullable
    private Long fragmentDuration;
    private long timescale;
    private int adaptationIndex;
    private int representationIndex;
    @NotNull
    private String template;
    @Nullable
    private String initTemplate;
    @NotNull
    private String bandwidth;
    @NotNull
    private String representationId;
    @Nullable
    private byte[] initBytes;
    private long periodStartMs;
    private long periodStartSec;
    @Nullable
    private Long presentationOffset;
    private SegmentTemplate segmentTemplate;
    private long availabilityStartTimeMs;
    private long availabilityStartTimeSec;
    private long presentationDelayMs;
    @Nullable
    private Long mostRecentNumber;
    private double segmentDurationSec;
    private long maxSegmentDurationMs;
    @NotNull
    private List<TimeLineItem> timeline;
    private boolean firstStart;
    private final boolean trimToLive;

    public MediaTrack(@NotNull TRACK type2, @NotNull PlayableChannel playableChannel) {
        Intrinsics.checkNotNullParameter((Object)type2, "type");
        Intrinsics.checkNotNullParameter(playableChannel, "playableChannel");
        this.type = type2;
        this.playableChannel = playableChannel;
        this.logger = LoggerFactory.getLogger("Main.MediaTrack." + this.type);
        this.baseUrl = "";
        this.timescale = 9000L;
        this.template = "";
        this.bandwidth = "";
        this.representationId = "";
        this.segmentDurationSec = 1.0;
        this.timeline = new ArrayList();
        this.firstStart = true;
        this.trimToLive = this.playableChannel.getProvider().getTrimToLive();
    }

    @NotNull
    public final TRACK getType() {
        return this.type;
    }

    public final int getAdaptationIndex() {
        return this.adaptationIndex;
    }

    public final void setAdaptationIndex(int n) {
        this.adaptationIndex = n;
    }

    public final int getRepresentationIndex() {
        return this.representationIndex;
    }

    public final void setRepresentationIndex(int n) {
        this.representationIndex = n;
    }

    @Nullable
    public final byte[] getInitBytes() {
        return this.initBytes;
    }

    public final void setInitBytes(@Nullable byte[] byArray2) {
        this.initBytes = byArray2;
    }

    @NotNull
    public final List<TimeLineItem> getTimeline() {
        return this.timeline;
    }

    public final void setTimeline(@NotNull List<TimeLineItem> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.timeline = list;
    }

    public final void setupAdaptationAndRepresentationIndex(int adaptIndex, int repIndex) {
        this.adaptationIndex = adaptIndex;
        this.representationIndex = repIndex;
    }

    public final void updatePeriod(@NotNull Period period) {
        long l;
        SegmentTemplate segmentTemplate;
        SegmentTemplate segmentTemplate2;
        SegmentTemplate segmentTemplate3;
        Intrinsics.checkNotNullParameter(period, "period");
        Duration duration = period.getStart();
        long l2 = this.periodStartMs = duration != null ? duration.toMillis() : 0L;
        if (this.periodStartMs != 0L) {
            this.periodStartSec = this.periodStartMs / (long)1000;
        }
        if ((segmentTemplate3 = period.getAdaptationSets().get(this.adaptationIndex).getSegmentTemplate()) == null) {
            SegmentTemplate segmentTemplate4 = period.getAdaptationSets().get(this.adaptationIndex).getRepresentations().get(this.representationIndex).getSegmentTemplate();
            segmentTemplate2 = segmentTemplate4;
            Intrinsics.checkNotNullExpressionValue(segmentTemplate4, "period.adaptationSets[ad\u2026ionIndex].segmentTemplate");
        } else {
            segmentTemplate2 = segmentTemplate3;
        }
        if ((segmentTemplate = (this.segmentTemplate = segmentTemplate2)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate = null;
        }
        Long l3 = segmentTemplate.getDuration();
        if (l3 == null) {
            SegmentTemplate segmentTemplate5 = this.segmentTemplate;
            if (segmentTemplate5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
                segmentTemplate5 = null;
            }
            List<Segment> list = segmentTemplate5.getSegmentTimeline();
            Intrinsics.checkNotNullExpressionValue(list, "segmentTemplate.segmentTimeline");
            l = CollectionsKt.first(list).getD();
        } else {
            l = l3;
        }
        long segDurationInUnits = l;
        double d = segDurationInUnits;
        SegmentTemplate segmentTemplate6 = this.segmentTemplate;
        if (segmentTemplate6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate6 = null;
        }
        Long l4 = segmentTemplate6.getTimescale();
        Intrinsics.checkNotNullExpressionValue(l4, "segmentTemplate.timescale");
        this.segmentDurationSec = ExtensionsKt.round(d / ((Number)l4).doubleValue(), 3);
    }

    public final void settingUp(@NotNull Period period, long availabilityStartTimeMs, long presentationDelayMs, @NotNull String baseUrl, long maxSegmentDurationMs) {
        Long l;
        Intrinsics.checkNotNullParameter(period, "period");
        Intrinsics.checkNotNullParameter(baseUrl, "baseUrl");
        AdaptationSet adapt = period.getAdaptationSets().get(this.adaptationIndex);
        Representation rep = adapt.getRepresentations().get(this.representationIndex);
        this.availabilityStartTimeMs = availabilityStartTimeMs;
        if (availabilityStartTimeMs != 0L) {
            this.availabilityStartTimeSec = availabilityStartTimeMs / (long)1000;
        }
        this.presentationDelayMs = presentationDelayMs;
        this.maxSegmentDurationMs = maxSegmentDurationMs;
        this.updatePeriod(period);
        this.baseUrl = baseUrl;
        SegmentTemplate segmentTemplate = this.segmentTemplate;
        if (segmentTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate = null;
        }
        String string = segmentTemplate.getMedia();
        if (string == null) {
            throw new Exception("Cant parse string template");
        }
        this.template = string;
        SegmentTemplate segmentTemplate2 = this.segmentTemplate;
        if (segmentTemplate2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate2 = null;
        }
        this.fragmentDuration = segmentTemplate2.getDuration();
        SegmentTemplate segmentTemplate3 = this.segmentTemplate;
        if (segmentTemplate3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate3 = null;
        }
        Long l2 = segmentTemplate3.getTimescale();
        Intrinsics.checkNotNullExpressionValue(l2, "segmentTemplate.timescale");
        this.timescale = ((Number)l2).longValue();
        SegmentTemplate segmentTemplate4 = this.segmentTemplate;
        if (segmentTemplate4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate4 = null;
        }
        this.initTemplate = segmentTemplate4.getInitialization();
        SegmentTemplate segmentTemplate5 = this.segmentTemplate;
        if (segmentTemplate5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate5 = null;
        }
        if ((l = segmentTemplate5.getPresentationTimeOffset()) == null) {
            l = 0L;
        }
        this.presentationOffset = l;
        this.bandwidth = String.valueOf(rep.getBandwidth());
        String string2 = rep.getId();
        Intrinsics.checkNotNullExpressionValue(string2, "rep.id");
        this.representationId = string2;
    }

    @Nullable
    public final Object buildTimeline(long nowMs, @NotNull Continuation<? super Integer> $completion) {
        int n;
        SegmentTemplate segmentTemplate = this.segmentTemplate;
        if (segmentTemplate == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate = null;
        }
        List<Segment> timeline = segmentTemplate.getSegmentTimeline();
        SegmentTemplate segmentTemplate2 = this.segmentTemplate;
        if (segmentTemplate2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
            segmentTemplate2 = null;
        }
        Long startNumber = segmentTemplate2.getStartNumber();
        Collection collection = timeline;
        if (collection == null || collection.isEmpty()) {
            if (startNumber == null) {
                throw new Exception("Empty start number");
            }
            SegmentTemplate segmentTemplate3 = this.segmentTemplate;
            if (segmentTemplate3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("segmentTemplate");
                segmentTemplate3 = null;
            }
            n = this.buildFullTimeLine(this.lastNumber, segmentTemplate3, nowMs);
        } else {
            Intrinsics.checkNotNullExpressionValue(timeline, "timeline");
            n = this.parseTimeline(timeline, startNumber, nowMs);
        }
        return Boxing.boxInt(n);
    }

    private final int buildFullTimeLine(Long lastStartNumber, SegmentTemplate segmentTemplate, long nowMs) {
        System.out.println((Object)("LAST START NUMBER: " + lastStartNumber));
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        ExtensionsKt.showInfo(logger, "Period start ms " + this.periodStartMs + "\nSegment duration: " + this.segmentDurationSec + "\nTemplate start number:" + segmentTemplate.getStartNumber() + "\nAVS: " + this.availabilityStartTimeMs, this.playableChannel, "Build full timeline");
        int fallbackSegments = (int)((double)30 / this.segmentDurationSec);
        Long l = lastStartNumber;
        if (l == null) {
            if (this.mostRecentNumber == null) {
                if (this.trimToLive) {
                    double d;
                    double d2 = (double)(nowMs - (long)30000 - this.periodStartMs - this.availabilityStartTimeMs) / this.segmentDurationSec / (double)1000;
                    Long l2 = segmentTemplate.getStartNumber();
                    Intrinsics.checkNotNullExpressionValue(l2, "segmentTemplate.startNumber");
                    double it = d = d2 + ((Number)l2).doubleValue();
                    boolean bl = false;
                    this.mostRecentNumber = (long)it;
                    l = (long)d - (long)fallbackSegments;
                } else {
                    l = segmentTemplate.getStartNumber();
                }
            } else {
                Long l3 = this.mostRecentNumber;
                l = l3;
                Intrinsics.checkNotNull(l3);
            }
        }
        Long mostRecent = l;
        System.out.println((Object)("MOST RECENT NUMBER " + mostRecent));
        Long d = segmentTemplate.getDuration();
        long l4 = mostRecent;
        Intrinsics.checkNotNullExpressionValue(d, "d");
        long t = l4 * d;
        Segment seg = Segment.builder().withD(d).withT(t).withR(10L).build();
        return this.parseTimeline(CollectionsKt.listOf(seg), mostRecent, nowMs);
    }

    public final long getLiveEdge(long nowMs) {
        return nowMs - this.availabilityStartTimeMs - this.maxSegmentDurationMs;
    }

    private final int parseTimeline(List<? extends Segment> segments2, Long startNumber, long nowMs) {
        long l;
        Logger logger = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger, "logger");
        ExtensionsKt.showDebug(logger, "Last segment in new timeline: " + CollectionsKt.last(segments2), this.playableChannel, this.type, "ParseTimeline");
        long liveEdge = this.getLiveEdge(nowMs);
        int newItemCount = 0;
        long totalSegs = 0L;
        Iterable $this$forEach$iv = segments2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Segment it = (Segment)element$iv;
            boolean bl = false;
            if (it.getR() != null) {
                Long l2 = it.getR();
                Intrinsics.checkNotNullExpressionValue(l2, "it.r");
                if (((Number)l2).longValue() > 0L) {
                    totalSegs += it.getR() + 1L;
                    continue;
                }
            }
            ++totalSegs;
        }
        long startTime = 0L;
        TimeLineItem last2 = CollectionsKt.lastOrNull(this.timeline);
        if (last2 == null) {
            Logger logger2 = this.logger;
            Intrinsics.checkNotNullExpressionValue(logger2, "logger");
            ExtensionsKt.showWarning(logger2, "Timeline is empty. Last start time: " + this.lastStartTime, this.playableChannel, "ParseTimeline");
        }
        TimeLineItem timeLineItem = last2;
        System.out.println(timeLineItem != null ? Long.valueOf(timeLineItem.getStartTime()) : null);
        System.out.println(this.lastStartTime);
        Long l3 = this.lastStartTime;
        if (l3 != null) {
            l = l3;
        } else {
            TimeLineItem timeLineItem2 = last2;
            Long l4 = timeLineItem2 != null ? Long.valueOf(timeLineItem2.getStartTime()) : null;
            l = l4 != null ? l4 : 0L;
        }
        long lastStartTime = l;
        Long l5 = this.lastNumber;
        Long startN = l5 != null ? Long.valueOf(l5 + 1L) : startNumber;
        System.out.println((Object)(this.type + " Timeline size: " + this.timeline.size()));
        Logger logger3 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger3, "logger");
        ExtensionsKt.showInfo(logger3, "Parse timeline. [" + this.type + "] START NUMBER: " + startNumber + " LAST START TIME:" + this.getPresentationTime(lastStartTime, startNumber) + " PERIOD START " + this.periodStartMs, this.playableChannel, "Parse");
        int n = segments2.size();
        for (int i = 0; i < n; ++i) {
            if (segments2.get(i).getT() != null) {
                Long l6 = segments2.get(i).getT();
                Intrinsics.checkNotNull(l6);
                if (l6 > 0L) {
                    Long l7 = segments2.get(i).getT();
                    Intrinsics.checkNotNull(l7);
                    startTime = l7;
                }
            }
            if (segments2.get(i).getR() != null) {
                Long l8 = segments2.get(i).getR();
                Intrinsics.checkNotNullExpressionValue(l8, "segments[i].r");
                long l9 = ((Number)l8).longValue();
                for (long j2 = 0L; j2 < l9; ++j2) {
                    if (lastStartTime >= (startTime += segments2.get(i).getD())) continue;
                    Long l10 = startN;
                    Long startNum = l10 != null ? Long.valueOf(l10 + (long)newItemCount) : null;
                    String url2 = this.buildHttpUrl(this.template, startTime, startNum);
                    long pt = this.getPresentationTime(startTime, startNum);
                    long l11 = startTime;
                    long l12 = segments2.get(i).getD();
                    TimeLineItem timeLineItem3 = new TimeLineItem(l11, l12, pt, null, startNum, url2, null, 72, null);
                    if (this.firstStart && this.trimToLive) {
                        if (liveEdge - pt < 30000L) {
                            this.timeline.add(timeLineItem3);
                            ++newItemCount;
                            continue;
                        }
                        System.out.println((Object)("Skipping " + timeLineItem3.getPresentationTime()));
                        continue;
                    }
                    this.timeline.add(timeLineItem3);
                    ++newItemCount;
                }
                if (segments2.get(i).getD() > 0L) {
                    startTime += segments2.get(i).getD();
                }
            } else if (segments2.get(i).getD() > 0L) {
                startTime += segments2.get(i).getD();
            }
            if (lastStartTime >= startTime) continue;
            Long l13 = startN;
            Long startNum = l13 != null ? Long.valueOf(l13 + (long)newItemCount) : null;
            String url3 = this.buildHttpUrl(this.template, startTime, startNum);
            long pt = this.getPresentationTime(startTime, startNum);
            long l14 = startTime;
            long l15 = segments2.get(i).getD();
            TimeLineItem timeLineItem4 = new TimeLineItem(l14, l15, pt, null, startNum, url3, null, 72, null);
            if (this.firstStart && this.trimToLive) {
                if (liveEdge - pt < 30000L) {
                    this.timeline.add(timeLineItem4);
                    ++newItemCount;
                    continue;
                }
                System.out.println((Object)("Skipping " + timeLineItem4.getPresentationTime()));
                continue;
            }
            this.timeline.add(timeLineItem4);
            ++newItemCount;
        }
        Logger logger4 = this.logger;
        Intrinsics.checkNotNullExpressionValue(logger4, "logger");
        ExtensionsKt.showInfo(logger4, "[" + this.type + "] NEW TIMELINE ITEMS ADDED " + this.timeline.size(), this.playableChannel, "Parse");
        this.firstStart = false;
        return this.timeline.size();
    }

    public final void updateStartTime(@NotNull TimeLineItem item2) {
        Intrinsics.checkNotNullParameter(item2, "item");
        System.out.println((Object)("Update START: " + item2.getStartTime() + " NUMBER " + item2.getStartNumber()));
        this.lastStartTime = item2.getStartTime();
        this.lastNumber = item2.getStartNumber();
    }

    public final void clearTimeline() {
        this.timeline.clear();
    }

    private final long getPresentationTime(long startTime, Long startNumber) {
        Long l = this.presentationOffset;
        double r1 = ExtensionsKt.round((double)(startTime - (l != null ? l : 0L)) / (double)this.timescale, 2) * (double)1000 + (double)this.periodStartSec;
        return (long)r1 + (long)30000 + this.availabilityStartTimeMs;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object loadInitBytes(@NotNull Function2<? super String, ? super Continuation<? super Deferred<byte[]>>, ? extends Object> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        block14: {
            if (!(var2_2 instanceof loadInitBytes.1)) ** GOTO lbl-1000
            var9_3 = var2_2;
            if ((var9_3.label & -2147483648) != 0) {
                var9_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, var2_2){
                    Object L$0;
                    Object L$1;
                    /* synthetic */ Object result;
                    final /* synthetic */ MediaTrack this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.loadInitBytes(null, this);
                    }
                };
            }
            $result = $continuation.result;
            var10_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure($result);
                    if (this.initBytes != null) break;
                    if (this.initTemplate == null) break block14;
                    v0 = this.initTemplate;
                    Intrinsics.checkNotNull(v0);
                    url = MediaTrack.buildHttpUrl$default(this, v0, null, null, 6, null);
                    v1 = this.logger;
                    Intrinsics.checkNotNullExpressionValue(v1, "logger");
                    ExtensionsKt.showInfo(v1, "INIT URL: " + url, this.playableChannel, "Load init bytes");
                    var4_7 = this;
                    $this$loadInitBytes_u24lambda_u242 = (MediaTrack)var4_7;
                    $i$a$-runCatching-MediaTrack$loadInitBytes$2 = false;
                    var7_12 = $this$loadInitBytes_u24lambda_u242;
                    $continuation.L$0 = this;
                    $continuation.L$1 = var7_12;
                    $continuation.label = 1;
                    v2 = downloader.invoke(url, $continuation);
                    ** if (v2 != var10_5) goto lbl33
lbl32:
                    // 1 sources

                    return var10_5;
lbl33:
                    // 1 sources

                    ** GOTO lbl42
                }
                case 1: {
                    $i$a$-runCatching-MediaTrack$loadInitBytes$2 = false;
                    var7_12 = (MediaTrack)$continuation.L$1;
                    this = (MediaTrack)$continuation.L$0;
                    ResultKt.throwOnFailure($result);
                    v2 = $result;
lbl42:
                    // 2 sources

                    $continuation.L$0 = this;
                    $continuation.L$1 = var7_12;
                    $continuation.label = 2;
                    v3 = ((Deferred)v2).await($continuation);
                    ** if (v3 != var10_5) goto lbl48
lbl47:
                    // 1 sources

                    return var10_5;
lbl48:
                    // 1 sources

                    ** GOTO lbl57
                }
                case 2: {
                    $i$a$-runCatching-MediaTrack$loadInitBytes$2 = false;
                    var7_12 = (MediaTrack)$continuation.L$1;
                    this = (MediaTrack)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure($result);
                        v3 = $result;
lbl57:
                        // 2 sources

                        var7_12.initBytes = (byte[])v3;
                        var5_8 = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable var6_11) {
                        var5_8 = Result.constructor-impl(ResultKt.createFailure(var6_11));
                    }
                    var4_7 = var5_8;
                    v4 = Result.exceptionOrNull-impl(var4_7);
                    if (v4 != null) {
                        var5_8 = v4;
                        $i$a$-onFailure-MediaTrack$loadInitBytes$3 = false;
                        v5 = this.logger;
                        Intrinsics.checkNotNullExpressionValue(v5, "logger");
                        ExtensionsKt.showError(v5, "Init bytes download error", this.playableChannel, null, "LoadInitBytes");
                    }
                    ResultKt.throwOnFailure(var4_7);
                    break block14;
                }
            }
            v6 = this.logger;
            Intrinsics.checkNotNullExpressionValue(v6, "logger");
            ExtensionsKt.showInfo(v6, "Init bytes already loaded", this.playableChannel, "LoadInitBytes");
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final String buildHttpUrl(String segmentTemplate, Long startTime, Long startNumber) {
        String template = segmentTemplate;
        if (startTime != null && StringsKt.contains$default((CharSequence)template, "$Time$", false, 2, null)) {
            template = StringsKt.replace$default(template, "$Time$", startTime.toString(), false, 4, null);
        }
        if (StringsKt.contains$default((CharSequence)template, "$Bandwidth$", false, 2, null)) {
            template = StringsKt.replace$default(template, "$Bandwidth$", this.bandwidth, false, 4, null);
        }
        if (startNumber != null && StringsKt.contains$default((CharSequence)template, "$Number$", false, 2, null)) {
            template = StringsKt.replace$default(template, "$Number$", startNumber.toString(), false, 4, null);
        }
        if (StringsKt.contains$default((CharSequence)template, "$RepresentationID$", false, 2, null)) {
            template = StringsKt.replace$default(template, "$RepresentationID$", this.representationId, false, 4, null);
        }
        return StringsKt.startsWith$default(template, "http", false, 2, null) ? template : StringsKt.removeSuffix(this.baseUrl, (CharSequence)"/") + "/" + template;
    }

    static /* synthetic */ String buildHttpUrl$default(MediaTrack mediaTrack, String string, Long l, Long l2, int n, Object object) {
        if ((n & 2) != 0) {
            l = null;
        }
        if ((n & 4) != 0) {
            l2 = null;
        }
        return mediaTrack.buildHttpUrl(string, l, l2);
    }

    @Nullable
    public final TimeLineItem getPairByIndex(int index) {
        return CollectionsKt.getOrNull(this.timeline, index);
    }

    @Nullable
    public final TimeLineItem getPairByPt(long presentationTime) {
        Object v0;
        Iterable $this$minByOrNull$iv = this.timeline;
        boolean $i$f$minByOrNull = false;
        Iterator iterator$iv = $this$minByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object minElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = minElem$iv;
            } else {
                TimeLineItem it = (TimeLineItem)minElem$iv;
                boolean bl = false;
                long minValue$iv = Math.abs(it.getPresentationTime() - presentationTime);
                do {
                    Object e$iv = iterator$iv.next();
                    TimeLineItem it2 = (TimeLineItem)e$iv;
                    $i$a$-minByOrNull-MediaTrack$getPairByPt$1 = false;
                    long v$iv = Math.abs(it2.getPresentationTime() - presentationTime);
                    if (minValue$iv <= v$iv) continue;
                    minElem$iv = e$iv;
                    minValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = minElem$iv;
            }
        }
        return v0;
    }

    @Nullable
    public final TimeLineItem getPairByNumber(long startNumber) {
        Object v1;
        block1: {
            Iterable $this$firstOrNull$iv = this.timeline;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TimeLineItem it = (TimeLineItem)element$iv;
                boolean bl = false;
                Long l = it.getStartNumber();
                long l2 = startNumber;
                if (!(l != null && l == l2)) continue;
                v1 = element$iv;
                break block1;
            }
            v1 = null;
        }
        return v1;
    }

    private final <T, R extends Comparable<? super R>> T findClosest(Iterable<? extends T> $this$findClosest, Function1<? super T, ? extends R> selector) {
        boolean $i$f$findClosest = false;
        Iterator<T> iterator2 = $this$findClosest.iterator();
        T minElem = iterator2.next();
        if (!iterator2.hasNext()) {
            return minElem;
        }
        Comparable minValue = (Comparable)selector.invoke(minElem);
        do {
            T e;
            Comparable v;
            if (minValue.compareTo(v = (Comparable)selector.invoke(e = iterator2.next())) <= 0) continue;
            minElem = e;
            minValue = v;
        } while (iterator2.hasNext());
        return minElem;
    }
}

