/*
 * Decompiled with CFR 0.152.
 */
package com.zlab;

import com.zlab.MediaTrack;
import com.zlab.MpdTracks;
import com.zlab.enum.TRACK;
import com.zlab.model.PlayableChannel;
import com.zlab.model.TimeLineItem;
import com.zlab.model.TimelinePair;
import com.zlab.mpd.data.Period;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0007J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0014J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0018\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u0007J\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001a2\u0006\u0010\r\u001a\u00020\u0007Jc\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00142(\u0010#\u001a$\b\u0001\u0012\u0004\u0012\u00020!\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0&0%\u0012\u0006\u0012\u0004\u0018\u00010\u00010$H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010'J\u0016\u0010(\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010)\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010,\u001a\u00020\n2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010-\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0011J\u0016\u0010.\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010+\u001a\u00020\u0011J\u0016\u0010/\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u00072\u0006\u00100\u001a\u00020\u0011J\u000e\u00101\u001a\u00020\n2\u0006\u00102\u001a\u000203J!\u00104\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00105\u001a\u00020\u0014H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00106R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00067"}, d2={"Lcom/zlab/MpdTracks;", "", "playableChannel", "Lcom/zlab/model/PlayableChannel;", "(Lcom/zlab/model/PlayableChannel;)V", "tracks", "", "Lcom/zlab/enum/TRACK;", "Lcom/zlab/MediaTrack;", "clearTimelines", "", "getInitBytes", "", "track", "getPairByIndex", "Lcom/zlab/model/TimeLineItem;", "index", "", "getPairByNumber", "startNumber", "", "getPairByPt", "presentationTime", "getSegmentByIndex", "getTimeLineSize", "getTimeline", "", "initialize", "period", "Lcom/zlab/mpd/data/Period;", "availabilityStartTimeMs", "presentationDelayMs", "baseUrl", "", "maxSegmentDurationMs", "downloader", "Lkotlin/Function2;", "Lkotlin/coroutines/Continuation;", "Lkotlinx/coroutines/Deferred;", "(Lcom/zlab/mpd/data/Period;JJLjava/lang/String;JLkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "removeSegmentByIndex", "selectAudio", "adaptIndex", "repIndex", "selectVideo", "setAdaptationIndex", "setRepresentationIndex", "trimTimeLine", "startIndex", "updateStartTime", "timelinePair", "Lcom/zlab/model/TimelinePair;", "updateTimeLine", "nowMs", "(Lcom/zlab/mpd/data/Period;JLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "player"})
public final class MpdTracks {
    @NotNull
    private final Map<TRACK, MediaTrack> tracks;

    public MpdTracks(@NotNull PlayableChannel playableChannel) {
        Intrinsics.checkNotNullParameter(playableChannel, "playableChannel");
        Pair[] pairArray = new Pair[]{TuplesKt.to(TRACK.VIDEO, new MediaTrack(TRACK.VIDEO, playableChannel)), TuplesKt.to(TRACK.AUDIO, new MediaTrack(TRACK.AUDIO, playableChannel))};
        this.tracks = MapsKt.mapOf(pairArray);
    }

    public final void selectAudio(int adaptIndex, int repIndex) {
        Unit unit;
        MediaTrack mediaTrack = this.tracks.get((Object)TRACK.AUDIO);
        if (mediaTrack != null) {
            mediaTrack.setupAdaptationAndRepresentationIndex(adaptIndex, repIndex);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new Exception("Cant find AUDIO track in track list");
        }
    }

    public final void selectVideo(int adaptIndex, int repIndex) {
        Unit unit;
        MediaTrack mediaTrack = this.tracks.get((Object)TRACK.VIDEO);
        if (mediaTrack != null) {
            mediaTrack.setupAdaptationAndRepresentationIndex(adaptIndex, repIndex);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        if (unit == null) {
            throw new Exception("Cant find VIDIO track in track list");
        }
    }

    public final void setAdaptationIndex(@NotNull TRACK track, int adaptIndex) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        if (mediaTrack != null) {
            mediaTrack.setAdaptationIndex(adaptIndex);
        }
    }

    public final void setRepresentationIndex(@NotNull TRACK track, int repIndex) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        if (mediaTrack != null) {
            mediaTrack.setRepresentationIndex(repIndex);
        }
    }

    @NotNull
    public final List<TimeLineItem> getTimeline(@NotNull TRACK track) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        Intrinsics.checkNotNull(mediaTrack);
        return mediaTrack.getTimeline();
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object initialize(@NotNull Period var1_1, long var2_2, long var4_3, @NotNull String var6_4, long var7_5, @NotNull Function2<? super String, ? super Continuation<? super Deferred<byte[]>>, ? extends Object> var9_6, @NotNull Continuation<? super Unit> var10_7) {
        if (!(var10_7 instanceof initialize.1)) ** GOTO lbl-1000
        var24_8 = var10_7;
        if ((var24_8.label & -2147483648) != 0) {
            var24_8.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var10_7){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                long J$0;
                long J$1;
                long J$2;
                /* synthetic */ Object result;
                final /* synthetic */ MpdTracks this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.initialize(null, 0L, 0L, null, 0L, null, this);
                }
            };
        }
        $result = $continuation.result;
        var25_10 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $this$onEach$iv = this.tracks;
                $i$f$onEach = false;
                $this$onEach_u24lambda_u242$iv = var13_13 = $this$onEach$iv;
                $i$a$-apply-MapsKt___MapsKt$onEach$1$iv = false;
                var16_16 = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
lbl17:
                // 3 sources

                while (var16_16.hasNext()) {
                    it = element$iv = var16_16.next();
                    $i$a$-onEach-MpdTracks$initialize$2 = false;
                    var20_20 = it.getValue();
                    $this$initialize_u24lambda_u241_u24lambda_u240 = (MediaTrack)var20_20;
                    $i$a$-apply-MpdTracks$initialize$2$1 = false;
                    $this$initialize_u24lambda_u241_u24lambda_u240.settingUp(period, availabilityStartTimeMs, presentationDelayMs, baseUrl, maxSegmentDurationMs);
                    $continuation.L$0 = period;
                    $continuation.L$1 = baseUrl;
                    $continuation.L$2 = downloader;
                    $continuation.L$3 = var13_13;
                    $continuation.L$4 = var16_16;
                    $continuation.L$5 = var20_20;
                    $continuation.J$0 = availabilityStartTimeMs;
                    $continuation.J$1 = presentationDelayMs;
                    $continuation.J$2 = maxSegmentDurationMs;
                    $continuation.label = 1;
                    v0 = $this$initialize_u24lambda_u241_u24lambda_u240.loadInitBytes(downloader, $continuation);
                    if (v0 != var25_10) continue;
                    return var25_10;
                }
                break;
            }
            case 1: {
                $i$f$onEach = false;
                $i$a$-apply-MapsKt___MapsKt$onEach$1$iv = false;
                $i$a$-onEach-MpdTracks$initialize$2 = false;
                $i$a$-apply-MpdTracks$initialize$2$1 = false;
                maxSegmentDurationMs = $continuation.J$2;
                presentationDelayMs = $continuation.J$1;
                availabilityStartTimeMs = $continuation.J$0;
                var20_20 = $continuation.L$5;
                var16_16 = (Iterator)$continuation.L$4;
                var13_13 = (Map)$continuation.L$3;
                downloader = (Function2)$continuation.L$2;
                baseUrl = (String)$continuation.L$1;
                period = (Period)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
                ** GOTO lbl17
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public final Object updateTimeLine(@NotNull Period var1_1, long var2_2, @NotNull Continuation<? super Integer> var4_3) {
        if (!(var4_3 instanceof updateTimeLine.1)) ** GOTO lbl-1000
        var22_4 = var4_3;
        if ((var22_4.label & -2147483648) != 0) {
            var22_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var4_3){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                long J$0;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ MpdTracks this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.updateTimeLine(null, 0L, this);
                }
            };
        }
        $result = $continuation.result;
        var23_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                total = new Ref.IntRef();
                $this$onEach$iv = this.tracks;
                $i$f$onEach = false;
                $this$onEach_u24lambda_u242$iv = var8_10 = $this$onEach$iv;
                $i$a$-apply-MapsKt___MapsKt$onEach$1$iv = false;
                var11_13 = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
lbl18:
                // 2 sources

                while (var11_13.hasNext()) {
                    it = element$iv = (Map.Entry)var11_13.next();
                    $i$a$-onEach-MpdTracks$updateTimeLine$2 = false;
                    var15_17 = it.getValue();
                    $this$updateTimeLine_u24lambda_u243_u24lambda_u242 = (MediaTrack)var15_17;
                    $i$a$-apply-MpdTracks$updateTimeLine$2$1 = false;
                    $this$updateTimeLine_u24lambda_u243_u24lambda_u242.updatePeriod(period);
                    var18_20 = total.element;
                    var19_21 = total;
                    $continuation.L$0 = period;
                    $continuation.L$1 = total;
                    $continuation.L$2 = var8_10;
                    $continuation.L$3 = var11_13;
                    $continuation.L$4 = var15_17;
                    $continuation.L$5 = var19_21;
                    $continuation.J$0 = nowMs;
                    $continuation.I$0 = var18_20;
                    $continuation.label = 1;
                    v0 = $this$updateTimeLine_u24lambda_u243_u24lambda_u242.buildTimeline(nowMs, $continuation);
                    if (v0 == var23_6) {
                        return var23_6;
                    }
                    ** GOTO lbl56
                }
                break;
            }
            case 1: {
                $i$f$onEach = false;
                $i$a$-apply-MapsKt___MapsKt$onEach$1$iv = false;
                $i$a$-onEach-MpdTracks$updateTimeLine$2 = false;
                $i$a$-apply-MpdTracks$updateTimeLine$2$1 = false;
                var18_20 = $continuation.I$0;
                nowMs = $continuation.J$0;
                var19_21 = (Ref.IntRef)$continuation.L$5;
                var15_17 = $continuation.L$4;
                var11_13 = (Iterator)$continuation.L$3;
                var8_10 = (Map)$continuation.L$2;
                total = (Ref.IntRef)$continuation.L$1;
                period = (Period)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl56:
                // 2 sources

                var20_22 = v0;
                var19_21.element = var18_20 + ((Number)var20_22).intValue();
                ** GOTO lbl18
            }
        }
        return Boxing.boxInt(total.element > 0 ? total.element / 2 : total.element);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final byte[] getInitBytes(@NotNull TRACK track) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        return (byte[])(mediaTrack != null ? mediaTrack.getInitBytes() : null);
    }

    public final void clearTimelines() {
        Map<TRACK, MediaTrack> map2;
        Map<TRACK, MediaTrack> $this$onEach$iv = this.tracks;
        boolean $i$f$onEach = false;
        Map<TRACK, MediaTrack> $this$onEach_u24lambda_u242$iv = map2 = $this$onEach$iv;
        boolean bl = false;
        Iterator<Map.Entry<TRACK, MediaTrack>> iterator2 = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry<TRACK, MediaTrack> element$iv;
            Map.Entry<TRACK, MediaTrack> it = element$iv = iterator2.next();
            boolean bl2 = false;
            it.getValue().clearTimeline();
        }
    }

    @Nullable
    public final TimeLineItem getPairByIndex(@NotNull TRACK track, int index) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        return mediaTrack != null ? mediaTrack.getPairByIndex(index) : null;
    }

    @Nullable
    public final TimeLineItem getPairByPt(@NotNull TRACK track, long presentationTime) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        return mediaTrack != null ? mediaTrack.getPairByPt(presentationTime) : null;
    }

    @Nullable
    public final TimeLineItem getPairByNumber(@NotNull TRACK track, long startNumber) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        return mediaTrack != null ? mediaTrack.getPairByNumber(startNumber) : null;
    }

    @Nullable
    public final TimeLineItem getSegmentByIndex(@NotNull TRACK track, int index) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        Intrinsics.checkNotNull(mediaTrack);
        return CollectionsKt.getOrNull(mediaTrack.getTimeline(), index);
    }

    public final void removeSegmentByIndex(@NotNull TRACK track, int index) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        Intrinsics.checkNotNull(mediaTrack);
        mediaTrack.getTimeline().remove(index);
    }

    public final int getTimeLineSize() {
        MediaTrack mediaTrack = this.tracks.get((Object)TRACK.VIDEO);
        Intrinsics.checkNotNull(mediaTrack);
        int n = mediaTrack.getTimeline().size();
        MediaTrack mediaTrack2 = this.tracks.get((Object)TRACK.AUDIO);
        Intrinsics.checkNotNull(mediaTrack2);
        return Integer.min(n, mediaTrack2.getTimeline().size());
    }

    public final int getTimeLineSize(@NotNull TRACK track) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        Intrinsics.checkNotNull(mediaTrack);
        return mediaTrack.getTimeline().size();
    }

    public final void trimTimeLine(@NotNull TRACK track, int startIndex) {
        Intrinsics.checkNotNullParameter((Object)track, "track");
        MediaTrack mediaTrack = this.tracks.get((Object)track);
        Intrinsics.checkNotNull(mediaTrack);
        List<TimeLineItem> tl = mediaTrack.getTimeline();
        MediaTrack mediaTrack2 = this.tracks.get((Object)track);
        Intrinsics.checkNotNull(mediaTrack2);
        mediaTrack2.setTimeline(tl.subList(startIndex, tl.size()));
    }

    public final void updateStartTime(@NotNull TimelinePair timelinePair) {
        Intrinsics.checkNotNullParameter(timelinePair, "timelinePair");
        MediaTrack mediaTrack = this.tracks.get((Object)TRACK.VIDEO);
        Intrinsics.checkNotNull(mediaTrack);
        mediaTrack.updateStartTime(timelinePair.getVItem());
        MediaTrack mediaTrack2 = this.tracks.get((Object)TRACK.AUDIO);
        Intrinsics.checkNotNull(mediaTrack2);
        mediaTrack2.updateStartTime(timelinePair.getAItem());
    }
}

