/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import java.util.Objects;

public class BaseURL {
    @JacksonXmlText
    private final String value;
    @JacksonXmlProperty(isAttribute=true)
    private final String serviceLocation;
    @JacksonXmlProperty(isAttribute=true)
    private final String byteRange;
    @JacksonXmlProperty(isAttribute=true)
    private final Double availabilityTimeOffset;
    @JacksonXmlProperty(isAttribute=true)
    private final Boolean availabilityTimeComplete;

    private BaseURL() {
        this.value = null;
        this.serviceLocation = null;
        this.byteRange = null;
        this.availabilityTimeOffset = null;
        this.availabilityTimeComplete = null;
    }

    private BaseURL(String value) {
        this.value = value;
        this.serviceLocation = null;
        this.byteRange = null;
        this.availabilityTimeOffset = null;
        this.availabilityTimeComplete = null;
    }

    private BaseURL(String value, String serviceLocation, String byteRange, Double availabilityTimeOffset, Boolean availabilityTimeComplete) {
        this.value = value;
        this.serviceLocation = serviceLocation;
        this.byteRange = byteRange;
        this.availabilityTimeOffset = availabilityTimeOffset;
        this.availabilityTimeComplete = availabilityTimeComplete;
    }

    public String getValue() {
        return this.value;
    }

    public String getServiceLocation() {
        return this.serviceLocation;
    }

    public String getByteRange() {
        return this.byteRange;
    }

    public Double getAvailabilityTimeOffset() {
        return this.availabilityTimeOffset;
    }

    public Boolean getAvailabilityTimeComplete() {
        return this.availabilityTimeComplete;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseURL baseURL = (BaseURL)o;
        return Objects.equals(this.value, baseURL.value) && Objects.equals(this.serviceLocation, baseURL.serviceLocation) && Objects.equals(this.byteRange, baseURL.byteRange) && Objects.equals(this.availabilityTimeOffset, baseURL.availabilityTimeOffset) && Objects.equals(this.availabilityTimeComplete, baseURL.availabilityTimeComplete);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.serviceLocation, this.byteRange, this.availabilityTimeOffset, this.availabilityTimeComplete);
    }

    public String toString() {
        return "BaseURL{value='" + this.value + "', serviceLocation='" + this.serviceLocation + "', byteRange='" + this.byteRange + "', availabilityTimeOffset=" + this.availabilityTimeOffset + ", availabilityTimeComplete=" + this.availabilityTimeComplete + "}";
    }

    public Builder buildUpon() {
        return new Builder().withValue(this.value).withServiceLocation(this.serviceLocation).withByteRange(this.byteRange).withAvailabilityTimeOffset(this.availabilityTimeOffset).withAvailabilityTimeComplete(this.availabilityTimeComplete);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String value;
        private String serviceLocation;
        private String byteRange;
        private Double availabilityTimeOffset;
        private Boolean availabilityTimeComplete;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withServiceLocation(String serviceLocation) {
            this.serviceLocation = serviceLocation;
            return this;
        }

        public Builder withByteRange(String byteRange) {
            this.byteRange = byteRange;
            return this;
        }

        public Builder withAvailabilityTimeOffset(Double availabilityTimeOffset) {
            this.availabilityTimeOffset = availabilityTimeOffset;
            return this;
        }

        public Builder withAvailabilityTimeComplete(Boolean availabilityTimeComplete) {
            this.availabilityTimeComplete = availabilityTimeComplete;
            return this;
        }

        public BaseURL build() {
            return new BaseURL(this.value, this.serviceLocation, this.byteRange, this.availabilityTimeOffset, this.availabilityTimeComplete);
        }
    }
}

