/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;

public class Event {
    @JacksonXmlProperty(isAttribute=true)
    private final Long presentationTime;
    @JacksonXmlProperty(isAttribute=true)
    private final Long duration;
    @JacksonXmlProperty(isAttribute=true)
    private final Long id;
    @JacksonXmlProperty(isAttribute=true)
    private final String messageData;

    private Event(Long presentationTime, Long duration, Long id2, String messageData) {
        this.presentationTime = presentationTime;
        this.duration = duration;
        this.id = id2;
        this.messageData = messageData;
    }

    private Event() {
        this.presentationTime = null;
        this.duration = null;
        this.id = null;
        this.messageData = null;
    }

    public Long getPresentationTime() {
        return this.presentationTime;
    }

    public Long getDuration() {
        return this.duration;
    }

    public Long getId() {
        return this.id;
    }

    public String getMessageData() {
        return this.messageData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Event event = (Event)o;
        return Objects.equals(this.presentationTime, event.presentationTime) && Objects.equals(this.duration, event.duration) && Objects.equals(this.id, event.id) && Objects.equals(this.messageData, event.messageData);
    }

    public int hashCode() {
        return Objects.hash(this.presentationTime, this.duration, this.id, this.messageData);
    }

    public String toString() {
        return "Event{presentationTime=" + this.presentationTime + ", duration=" + this.duration + ", id=" + this.id + ", messageData='" + this.messageData + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withPresentationTime(this.presentationTime).withDuration(this.duration).withId(this.id).withMessageData(this.messageData);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Long presentationTime;
        private Long duration;
        private Long id;
        private String messageData;

        public Builder withPresentationTime(Long presentationTime) {
            this.presentationTime = presentationTime;
            return this;
        }

        public Builder withDuration(Long duration) {
            this.duration = duration;
            return this;
        }

        public Builder withId(Long id2) {
            this.id = id2;
            return this;
        }

        public Builder withMessageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public Event build() {
            return new Event(this.presentationTime, this.duration, this.id, this.messageData);
        }
    }
}

