/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.zlab.mpd.data.ActuateType;
import com.zlab.mpd.data.Event;
import com.zlab.mpd.support.Utils;
import java.util.List;
import java.util.Objects;

public class EventStream {
    @JacksonXmlProperty(localName="Event", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final List<Event> events;
    @JacksonXmlProperty(isAttribute=true, namespace="http://www.w3.org/1999/xlink")
    private final String href;
    @JacksonXmlProperty(isAttribute=true, namespace="http://www.w3.org/1999/xlink")
    private final ActuateType actuate;
    @JacksonXmlProperty(isAttribute=true)
    private final String schemeIdUri;
    @JacksonXmlProperty(isAttribute=true)
    private final String value;
    @JacksonXmlProperty(isAttribute=true)
    private final Long timescale;
    @JacksonXmlProperty(isAttribute=true)
    private final String messageData;

    private EventStream(List<Event> events, String href, ActuateType actuate, String schemeIdUri, String value, Long timescale, String messageData) {
        this.events = events;
        this.href = href;
        this.actuate = actuate;
        this.schemeIdUri = schemeIdUri;
        this.value = value;
        this.timescale = timescale;
        this.messageData = messageData;
    }

    private EventStream() {
        this.events = null;
        this.href = null;
        this.actuate = null;
        this.schemeIdUri = null;
        this.value = null;
        this.timescale = null;
        this.messageData = null;
    }

    public List<Event> getEvents() {
        return Utils.unmodifiableList(this.events);
    }

    public String getHref() {
        return this.href;
    }

    public ActuateType getActuate() {
        return this.actuate;
    }

    public String getSchemeIdUri() {
        return this.schemeIdUri;
    }

    public String getValue() {
        return this.value;
    }

    public Long getTimescale() {
        return this.timescale;
    }

    public String getMessageData() {
        return this.messageData;
    }

    public String toString() {
        return "EventStream{events=" + this.events + ", href='" + this.href + "', actuate=" + this.actuate + ", schemeIdUri='" + this.schemeIdUri + "', value='" + this.value + "', timescale=" + this.timescale + ", messageData='" + this.messageData + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventStream that = (EventStream)o;
        return Objects.equals(this.events, that.events) && Objects.equals(this.href, that.href) && this.actuate == that.actuate && Objects.equals(this.schemeIdUri, that.schemeIdUri) && Objects.equals(this.value, that.value) && Objects.equals(this.timescale, that.timescale) && Objects.equals(this.messageData, that.messageData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.events, this.href, this.actuate, this.schemeIdUri, this.value, this.timescale, this.messageData});
    }

    public Builder buildUpon() {
        return new Builder().withEvents(this.events).withHref(this.href).withActuate(this.actuate).withSchemeIdUri(this.schemeIdUri).withValue(this.value).withTimescale(this.timescale).withMessageData(this.messageData);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Event> events;
        private String href;
        private ActuateType actuate;
        private String schemeIdUri;
        private String value;
        private Long timescale;
        private String messageData;

        public Builder withEvents(List<Event> events) {
            this.events = events;
            return this;
        }

        public Builder withHref(String href) {
            this.href = href;
            return this;
        }

        public Builder withActuate(ActuateType actuate) {
            this.actuate = actuate;
            return this;
        }

        public Builder withSchemeIdUri(String schemeIdUri) {
            this.schemeIdUri = schemeIdUri;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withTimescale(Long timescale) {
            this.timescale = timescale;
            return this;
        }

        public Builder withMessageData(String messageData) {
            this.messageData = messageData;
            return this;
        }

        public EventStream build() {
            return new EventStream(this.events, this.href, this.actuate, this.schemeIdUri, this.value, this.timescale, this.messageData);
        }
    }
}

