/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.zlab.mpd.support.FrameRateDeserializer;
import com.zlab.mpd.support.FrameRateSerializer;
import java.util.Objects;

@JsonSerialize(using=FrameRateSerializer.class)
@JsonDeserialize(using=FrameRateDeserializer.class)
public class FrameRate {
    private final long numerator;
    private final Long denominator;

    public FrameRate(long numerator, Long denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public FrameRate(long frameRate) {
        this(frameRate, null);
    }

    public long getNumerator() {
        return this.numerator;
    }

    public Long getDenominator() {
        return this.denominator;
    }

    @JsonIgnore
    public double toDouble() {
        if (this.denominator == null) {
            return this.numerator;
        }
        return (double)this.numerator / (double)this.denominator.longValue();
    }

    public String toString() {
        return "FrameRate{" + this.numerator + (String)(this.denominator == null ? "" : "/" + this.denominator) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FrameRate frameRate = (FrameRate)o;
        return this.numerator == frameRate.numerator && Objects.equals(this.denominator, frameRate.denominator);
    }

    public int hashCode() {
        return Objects.hash(this.numerator, this.denominator);
    }

    public Builder buildUpon() {
        return new Builder().withNumerator(this.numerator).withDenominator(this.denominator);
    }

    public static FrameRate of(long frameRate) {
        return new FrameRate(frameRate, null);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long numerator;
        private Long denominator;

        public Builder withNumerator(long numerator) {
            this.numerator = numerator;
            return this;
        }

        public Builder withDenominator(Long denominator) {
            this.denominator = denominator;
            return this;
        }

        public FrameRate build() {
            return new FrameRate(this.numerator, this.denominator);
        }
    }
}

