/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.zlab.mpd.data.Profile;
import com.zlab.mpd.support.ProfilesDeserializer;
import com.zlab.mpd.support.ProfilesSerializer;
import com.zlab.mpd.support.Utils;
import java.util.List;
import java.util.Objects;

@JsonSerialize(using=ProfilesSerializer.class)
@JsonDeserialize(using=ProfilesDeserializer.class)
public class Profiles {
    private final List<Profile> profiles;
    private final List<String> interoperabilityPointsAndExtensions;

    public Profiles(List<Profile> profiles, List<String> interoperabilityPointsAndExtensions) {
        this.profiles = profiles;
        this.interoperabilityPointsAndExtensions = interoperabilityPointsAndExtensions;
    }

    Profiles() {
        this.profiles = null;
        this.interoperabilityPointsAndExtensions = null;
    }

    public List<Profile> getProfiles() {
        return Utils.unmodifiableList(this.profiles);
    }

    public List<String> getInteroperabilityPointsAndExtensions() {
        return Utils.unmodifiableList(this.interoperabilityPointsAndExtensions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Profiles profiles1 = (Profiles)o;
        return Objects.equals(this.profiles, profiles1.profiles) && Objects.equals(this.interoperabilityPointsAndExtensions, profiles1.interoperabilityPointsAndExtensions);
    }

    public int hashCode() {
        return Objects.hash(this.profiles, this.interoperabilityPointsAndExtensions);
    }

    public String toString() {
        return "Profiles{profiles=" + this.profiles + ", interoperabilityPointsAndExtensions=" + this.interoperabilityPointsAndExtensions + "}";
    }

    public Builder buildUpon() {
        return new Builder().withProfiles(this.profiles).withInteroperabilityPointsAndExtensions(this.interoperabilityPointsAndExtensions);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private List<Profile> profiles;
        private List<String> interoperabilityPointsAndExtensions;

        public Builder withProfiles(List<Profile> profiles) {
            this.profiles = profiles;
            return this;
        }

        public Builder withInteroperabilityPointsAndExtensions(List<String> interoperabilityPointsAndExtensions) {
            this.interoperabilityPointsAndExtensions = interoperabilityPointsAndExtensions;
            return this;
        }

        public Profiles build() {
            return new Profiles(this.profiles, this.interoperabilityPointsAndExtensions);
        }
    }
}

