/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;

@JsonPropertyOrder(value={"title", "source", "copyright", "any"})
public class ProgramInformation {
    @JacksonXmlProperty(localName="Title", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final String title;
    @JacksonXmlProperty(localName="Source", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final String source;
    @JacksonXmlProperty(localName="Copyright", namespace="urn:mpeg:dash:schema:mpd:2011")
    private final String copyright;
    @JacksonXmlProperty(isAttribute=true)
    private final String lang;
    @JacksonXmlProperty(isAttribute=true)
    private final String moreInformationURL;

    private ProgramInformation(String title, String source2, String copyright, String lang, String moreInformationURL) {
        this.title = title;
        this.source = source2;
        this.copyright = copyright;
        this.lang = lang;
        this.moreInformationURL = moreInformationURL;
    }

    private ProgramInformation() {
        this.title = null;
        this.source = null;
        this.copyright = null;
        this.lang = null;
        this.moreInformationURL = null;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSource() {
        return this.source;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getLang() {
        return this.lang;
    }

    public String getMoreInformationURL() {
        return this.moreInformationURL;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProgramInformation that = (ProgramInformation)o;
        return Objects.equals(this.title, that.title) && Objects.equals(this.source, that.source) && Objects.equals(this.copyright, that.copyright) && Objects.equals(this.lang, that.lang) && Objects.equals(this.moreInformationURL, that.moreInformationURL);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.source, this.copyright, this.lang, this.moreInformationURL);
    }

    public String toString() {
        return "ProgramInformation{title='" + this.title + "', source='" + this.source + "', copyright='" + this.copyright + "', lang='" + this.lang + "', moreInformationURL='" + this.moreInformationURL + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withTitle(this.title).withSource(this.source).withCopyright(this.copyright).withLang(this.lang).withMoreInformationURL(this.moreInformationURL);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String title;
        private String source;
        private String copyright;
        private String lang;
        private String moreInformationURL;

        public Builder withTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder withSource(String source2) {
            this.source = source2;
            return this;
        }

        public Builder withCopyright(String copyright) {
            this.copyright = copyright;
            return this;
        }

        public Builder withLang(String lang) {
            this.lang = lang;
            return this;
        }

        public Builder withMoreInformationURL(String moreInformationURL) {
            this.moreInformationURL = moreInformationURL;
            return this;
        }

        public ProgramInformation build() {
            return new ProgramInformation(this.title, this.source, this.copyright, this.lang, this.moreInformationURL);
        }
    }
}

