/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.zlab.mpd.support.RatioDeserializer;
import com.zlab.mpd.support.RatioSerializer;
import java.util.Objects;

@JsonSerialize(using=RatioSerializer.class)
@JsonDeserialize(using=RatioDeserializer.class)
public class Ratio {
    private final Long a;
    private final Long b;

    public Ratio(Long a, Long b) {
        this.a = a;
        this.b = b;
    }

    public Long getA() {
        return this.a;
    }

    public Long getB() {
        return this.b;
    }

    public String toString() {
        return "Ratio{" + this.a + ":" + this.b + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ratio ratio = (Ratio)o;
        return Objects.equals(this.a, ratio.a) && Objects.equals(this.b, ratio.b);
    }

    public int hashCode() {
        return Objects.hash(this.a, this.b);
    }

    public Builder buildUpon() {
        return new Builder().withA(this.a).withB(this.b);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Ratio of(long a, long b) {
        return new Ratio(a, b);
    }

    public static class Builder {
        private Long a;
        private Long b;

        public Builder withA(Long a) {
            this.a = a;
            return this;
        }

        public Builder withB(Long b) {
            this.b = b;
            return this;
        }

        public Ratio build() {
            return new Ratio(this.a, this.b);
        }
    }
}

