/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.zlab.mpd.data.EventStream;
import com.zlab.mpd.data.FrameRate;
import com.zlab.mpd.data.Ratio;
import com.zlab.mpd.data.RepresentationBase;
import com.zlab.mpd.data.VideoScanType;
import com.zlab.mpd.data.descriptor.Descriptor;
import java.util.List;
import java.util.Objects;

public class SubRepresentation
extends RepresentationBase {
    @JacksonXmlProperty(isAttribute=true)
    private final Long level;
    @JacksonXmlProperty(isAttribute=true)
    private final String dependencyLevel;
    @JacksonXmlProperty(isAttribute=true)
    private final Long bandwidth;
    @JacksonXmlProperty(isAttribute=true)
    private final String contentComponent;

    private SubRepresentation(List<Descriptor> framePackings, List<Descriptor> audioChannelConfigurations, List<Descriptor> contentProtections, List<Descriptor> essentialProperties, List<Descriptor> supplementalProperties, List<EventStream> inbandEventStreams, String profiles, Long width, Long height, Ratio sar, FrameRate frameRate, String audioSamplingRate, String mimeType, String segmentProfiles, String codecs, Double maximumSAPPeriod, Long startWithSAP, Double maxPlayoutRate, Boolean codingDependency, VideoScanType scanType, Long level, String dependencyLevel, Long bandwidth, String contentComponent) {
        super(framePackings, audioChannelConfigurations, contentProtections, essentialProperties, supplementalProperties, inbandEventStreams, profiles, width, height, sar, frameRate, audioSamplingRate, mimeType, segmentProfiles, codecs, maximumSAPPeriod, startWithSAP, maxPlayoutRate, codingDependency, scanType);
        this.level = level;
        this.dependencyLevel = dependencyLevel;
        this.bandwidth = bandwidth;
        this.contentComponent = contentComponent;
    }

    private SubRepresentation() {
        this.level = null;
        this.dependencyLevel = null;
        this.bandwidth = null;
        this.contentComponent = null;
    }

    public Long getLevel() {
        return this.level;
    }

    public String getDependencyLevel() {
        return this.dependencyLevel;
    }

    public Long getBandwidth() {
        return this.bandwidth;
    }

    public String getContentComponent() {
        return this.contentComponent;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SubRepresentation that = (SubRepresentation)o;
        return Objects.equals(this.level, that.level) && Objects.equals(this.dependencyLevel, that.dependencyLevel) && Objects.equals(this.bandwidth, that.bandwidth) && Objects.equals(this.contentComponent, that.contentComponent);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.level, this.dependencyLevel, this.bandwidth, this.contentComponent);
    }

    @Override
    public String toString() {
        return "SubRepresentation{super=" + super.toString() + ", level=" + this.level + ", dependencyLevel=" + this.dependencyLevel + ", bandwidth=" + this.bandwidth + ", contentComponent=" + this.contentComponent + "}";
    }

    public Builder buildUpon() {
        return super.buildUpon(new Builder().withLevel(this.level).withDependencyLevel(this.dependencyLevel).withBandwidth(this.bandwidth).withContentComponent(this.contentComponent));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends RepresentationBase.AbstractBuilder<Builder> {
        private Long level;
        private String dependencyLevel;
        private Long bandwidth;
        private String contentComponent;

        public Builder withLevel(Long level) {
            this.level = level;
            return this;
        }

        public Builder withDependencyLevel(String dependencyLevel) {
            this.dependencyLevel = dependencyLevel;
            return this;
        }

        public Builder withBandwidth(Long bandwidth) {
            this.bandwidth = bandwidth;
            return this;
        }

        public Builder withContentComponent(String contentComponent) {
            this.contentComponent = contentComponent;
            return this;
        }

        public SubRepresentation build() {
            return new SubRepresentation(this.framePackings, this.audioChannelConfigurations, this.contentProtections, this.essentialProperties, this.supplementalProperties, this.inbandEventStreams, this.profiles, this.width, this.height, this.sar, this.frameRate, this.audioSamplingRate, this.mimeType, this.segmentProfiles, this.codecs, this.maximumSAPPeriod, this.startWithSAP, this.maxPlayoutRate, this.codingDependency, this.scanType, this.level, this.dependencyLevel, this.bandwidth, this.contentComponent);
        }

        @Override
        Builder getThis() {
            return this;
        }
    }
}

