/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.util.Objects;

public class URLType {
    @JacksonXmlProperty(isAttribute=true)
    private final String sourceURL;
    @JacksonXmlProperty(isAttribute=true)
    private final String range;

    private URLType(String sourceURL, String range) {
        this.sourceURL = sourceURL;
        this.range = range;
    }

    private URLType() {
        this.sourceURL = null;
        this.range = null;
    }

    public String getSourceURL() {
        return this.sourceURL;
    }

    public String getRange() {
        return this.range;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        URLType urlType = (URLType)o;
        return Objects.equals(this.sourceURL, urlType.sourceURL) && Objects.equals(this.range, urlType.range);
    }

    public int hashCode() {
        return Objects.hash(this.sourceURL, this.range);
    }

    public String toString() {
        return "URLType{sourceURL='" + this.sourceURL + "', range='" + this.range + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withSourceURL(this.sourceURL).withRange(this.range);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String sourceURL;
        private String range;

        public Builder withSourceURL(String sourceURL) {
            this.sourceURL = sourceURL;
            return this;
        }

        public Builder withRange(String range) {
            this.range = range;
            return this;
        }

        public URLType build() {
            return new URLType(this.sourceURL, this.range);
        }
    }
}

