/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data.descriptor.protection;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.zlab.mpd.data.descriptor.Descriptor;
import java.util.Objects;

public class Mp4Protection
extends Descriptor {
    public static final String SCHEME_ID_URI = "urn:mpeg:dash:mp4protection:2011";
    @JacksonXmlProperty(isAttribute=true, localName="cenc:default_KID", namespace="urn:mpeg:cenc:2013")
    private final String defaultKID;
    @JacksonXmlProperty(isAttribute=true, localName="value")
    private final String value;

    public Mp4Protection(String value, String defaultKID) {
        super(SCHEME_ID_URI, null);
        this.value = value;
        this.defaultKID = defaultKID;
    }

    private Mp4Protection() {
        super(null, null);
        this.defaultKID = null;
        this.value = null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDefaultKID() {
        return this.defaultKID;
    }

    public String toString() {
        return "Mp4Protection{defaultKID='" + this.defaultKID + "', value='" + this.value + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Mp4Protection that = (Mp4Protection)o;
        return Objects.equals(this.defaultKID, that.defaultKID) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.defaultKID, this.value);
    }

    public Builder buildUpon() {
        return new Builder().withDefaultKID(this.defaultKID).withValue(this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String defaultKID;
        private String value;

        public Builder withDefaultKID(String defaultKID) {
            this.defaultKID = defaultKID;
            return this;
        }

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Mp4Protection build() {
            return new Mp4Protection(this.value, this.defaultKID);
        }
    }
}

