/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data.descriptor.protection;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.zlab.mpd.data.descriptor.Descriptor;
import java.util.Objects;

public class PlayReadyContentProtection
extends Descriptor {
    public static final String SCHEME_ID_URI = "urn:uuid:9a04f079-9840-4286-ab92-e65be0885f95";
    @JacksonXmlProperty(isAttribute=true, localName="value")
    private final String value;
    @JacksonXmlProperty(isAttribute=true, localName="default_KID", namespace="urn:mpeg:cenc:2013")
    private final String defaultKID;
    @JacksonXmlProperty(namespace="urn:mpeg:cenc:2013")
    private final String pssh;
    @JacksonXmlProperty(namespace="urn:microsoft:playready")
    private final String pro;

    public PlayReadyContentProtection(String value, String defaultKID, String pssh, String pro) {
        super(SCHEME_ID_URI, null);
        this.value = value;
        this.defaultKID = defaultKID;
        this.pssh = pssh;
        this.pro = pro;
    }

    private PlayReadyContentProtection() {
        super(null, null);
        this.value = null;
        this.defaultKID = null;
        this.pssh = null;
        this.pro = null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getDefaultKID() {
        return this.defaultKID;
    }

    public String getPssh() {
        return this.pssh;
    }

    public String getPro() {
        return this.pro;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PlayReadyContentProtection that = (PlayReadyContentProtection)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.defaultKID, that.defaultKID) && Objects.equals(this.pssh, that.pssh) && Objects.equals(this.pro, that.pro);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.defaultKID, this.pssh, this.pro);
    }

    public String toString() {
        return "PlayReadyContentProtection{value='" + this.value + "', defaultKID='" + this.defaultKID + "', pssh='" + this.pssh + "', pro='" + this.pro + "'}";
    }

    public Builder buildUpon() {
        return new Builder().withValue(this.value).withDefaultKID(this.defaultKID).withPssh(this.pssh).withPro(this.pro);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String value;
        private String defaultKID;
        private String pssh;
        private String pro;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withDefaultKID(String defaultKID) {
            this.defaultKID = defaultKID;
            return this;
        }

        public Builder withPssh(String pssh) {
            this.pssh = pssh;
            return this;
        }

        public Builder withPro(String pro) {
            this.pro = pro;
            return this;
        }

        public PlayReadyContentProtection build() {
            return new PlayReadyContentProtection(this.value, this.defaultKID, this.pssh, this.pro);
        }
    }
}

