/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.data.descriptor.protection;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.zlab.mpd.data.descriptor.Descriptor;
import java.util.Objects;

public class WidewineProtection
extends Descriptor {
    public static final String SCHEME_ID_URI = "urn:uuid:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed";
    @JacksonXmlProperty(isAttribute=true, localName="value")
    private final String value;
    @JacksonXmlProperty(namespace="urn:mpeg:cenc:2013")
    private final String pssh;

    public WidewineProtection(String value, String pssh) {
        super(SCHEME_ID_URI, null);
        this.value = value;
        this.pssh = pssh;
    }

    private WidewineProtection() {
        super(null, null);
        this.pssh = null;
        this.value = null;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String getPssh() {
        return this.pssh;
    }

    public String toString() {
        return "WidewineProtection{value='" + this.value + "', pssh='" + this.pssh + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WidewineProtection that = (WidewineProtection)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.pssh, that.pssh);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.value, this.pssh);
    }

    public Builder buildUpon() {
        return new Builder().withPssh(this.pssh).withValue(this.value);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String value;
        private String pssh;

        public Builder withValue(String value) {
            this.value = value;
            return this;
        }

        public Builder withPssh(String pssh) {
            this.pssh = pssh;
            return this;
        }

        public WidewineProtection build() {
            return new WidewineProtection(this.value, this.pssh);
        }
    }
}

