/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DurationDeserializer
extends JsonDeserializer<Duration> {
    private static final int HOURS_PER_YEAR = 8766;
    private static final int MINUTES_PER_MONTH = 43830;
    private static final int HOURS_PER_DAY = 24;
    private static final Pattern PATTERN = Pattern.compile("([-+]?)P(?:([-+]?[0-9]+)Y)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)D)?(T(?:([-+]?[0-9]+)H)?(?:([-+]?[0-9]+)M)?(?:([-+]?[0-9]+)(?:[.,]([0-9]{0,12}))?S)?)?", 2);

    private static Duration estimateDuration(long years, long months, long days) {
        if (years > 0L || months > 0L || days > 0L) {
            return Duration.ofHours(8766L * years).plusMinutes(43830L * months).plusHours(24L * days);
        }
        return Duration.ZERO;
    }

    private static boolean isNegative(CharSequence text, int start, int end2) {
        return start >= 0 && end2 == start + 1 && text.charAt(start) == '-';
    }

    static long parseFraction(CharSequence text, int start, int end2, boolean negate) {
        if (start < 0 || end2 < 0 || end2 - start == 0) {
            return 0L;
        }
        if (end2 - start > 9) {
            end2 = start + 9;
        }
        long fraction = Long.parseLong(text, start, end2, 10);
        for (int i = end2 - start; i < 9; ++i) {
            fraction *= 10L;
        }
        if (negate) {
            return -fraction;
        }
        return fraction;
    }

    private Duration parse(String text) {
        Matcher matcher = PATTERN.matcher(text);
        if (!matcher.matches()) {
            throw new DateTimeParseException("Text cannot be parsed to a Duration", text, 0);
        }
        boolean negate = DurationDeserializer.isNegative(text, matcher.start(1), matcher.end(1));
        int yearStart = matcher.start(2);
        int yearEnd = matcher.end(2);
        int monthStart = matcher.start(3);
        int monthEnd = matcher.end(3);
        int dayStart = matcher.start(4);
        int dayEnd = matcher.end(4);
        int hourStart = matcher.start(6);
        int hourEnd = matcher.end(6);
        int minuteStart = matcher.start(7);
        int minuteEnd = matcher.end(7);
        int secondStart = matcher.start(8);
        int secondEnd = matcher.end(8);
        int fractionStart = matcher.start(9);
        int fractionEnd = matcher.end(9);
        int years = 0;
        int months = 0;
        int days = 0;
        long hoursAsSecs = 0L;
        long minutesAsSecs = 0L;
        long seconds = 0L;
        long nanos = 0L;
        if (yearStart >= 0) {
            years = Integer.parseInt(text, yearStart, yearEnd, 10);
        }
        if (monthStart >= 0) {
            months = Integer.parseInt(text, monthStart, monthEnd, 10);
        }
        if (dayStart >= 0) {
            days = Integer.parseInt(text, dayStart, dayEnd, 10);
        }
        if (hourStart >= 0) {
            hoursAsSecs = Math.multiplyExact(3600L, Integer.parseInt(text, hourStart, hourEnd, 10));
        }
        if (minuteStart >= 0) {
            minutesAsSecs = Math.multiplyExact(60L, Integer.parseInt(text, minuteStart, minuteEnd, 10));
        }
        if (secondStart >= 0) {
            seconds = Integer.parseInt(text, secondStart, secondEnd, 10);
            boolean negativeSecs = text.charAt(secondStart) == '-';
            nanos = DurationDeserializer.parseFraction(text, fractionStart, fractionEnd, negativeSecs);
        }
        long secondsTotal = Math.addExact(hoursAsSecs, Math.addExact(minutesAsSecs, seconds));
        Duration duration = Duration.ofSeconds(secondsTotal, nanos).plus(DurationDeserializer.estimateDuration(years, months, days));
        if (negate) {
            return duration.negated();
        }
        return duration;
    }

    @Override
    public Duration deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getText();
        try {
            return this.parse(text);
        }
        catch (Exception e) {
            ctxt.reportWrongTokenException(this, p.currentToken(), "Text cannot be parsed to a Duration", new Object[0]);
            return null;
        }
    }
}

