/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.mpd.support;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;

public class OffsetDateTimeDeserializer
extends JsonDeserializer<OffsetDateTime> {
    private final DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss[XXXXX]").parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();

    @Override
    public OffsetDateTime deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        String text = p.getText();
        try {
            return OffsetDateTime.parse(text);
        }
        catch (DateTimeParseException dateTimeParseException) {
            try {
                return OffsetDateTime.parse(text, this.formatter);
            }
            catch (DateTimeParseException dateTimeParseException2) {
                ctxt.reportWrongTokenException(this, p.currentToken(), "Invalid date time", new Object[0]);
                return null;
            }
        }
    }
}

