/*
 * Decompiled with CFR 0.152.
 */
package com.zlab.util;

import com.zlab.exception.QlException;
import com.zlab.model.PlayableChannel;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ(\u0010\r\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\u0010\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\u0011\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0012"}, d2={"Lcom/zlab/util/PlaylistUtils;", "", "()V", "buildPlaylist", "", "type", "host", "port", "", "provider", "channels", "", "Lcom/zlab/model/PlayableChannel;", "flussonicPlaylist", "getHlsUrl", "channelId", "getTsUrl", "m3uPlaylist", "player"})
public final class PlaylistUtils {
    private final String getTsUrl(int channelId, String host2, int port2) {
        return "://" + host2 + ":" + port2 + "/" + channelId + "/ts";
    }

    private final String getHlsUrl(int channelId, String host2, int port2) {
        return "://" + host2 + ":" + port2 + "/" + channelId + "/hls/playlist.m3u8";
    }

    private final String flussonicPlaylist(List<PlayableChannel> channels, String host2, int port2) {
        StringBuilder sb = new StringBuilder();
        Iterable $this$forEach$iv = channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayableChannel it = (PlayableChannel)element$iv;
            boolean bl = false;
            sb.append("stream " + it.getId() + " {");
            sb.append("\n\t input");
            if (Intrinsics.areEqual(it.getProvider().getFormat(), "HLS")) {
                sb.append(" hls");
                sb.append(this.getHlsUrl(it.getId(), host2, port2));
            } else {
                sb.append(" tshttp");
                sb.append(this.getTsUrl(it.getId(), host2, port2));
            }
            sb.append(";");
            sb.append("\n\t title \"");
            sb.append(it.getProvider().getName());
            sb.append(" - ");
            sb.append(it.getName());
            sb.append("\";");
            sb.append("\n\tsource_timeout 60;");
            sb.append("\n}\n");
            sb.append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    static /* synthetic */ String flussonicPlaylist$default(PlaylistUtils playlistUtils, List list, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8989;
        }
        return playlistUtils.flussonicPlaylist(list, string, n);
    }

    /*
     * WARNING - void declaration
     */
    private final String m3uPlaylist(List<PlayableChannel> channels, String host2, int port2) {
        void $this$forEach$iv;
        StringBuilder sb = new StringBuilder();
        sb.append("#EXTM3U\n");
        Iterable iterable = channels;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PlayableChannel it = (PlayableChannel)element$iv;
            boolean bl = false;
            sb.append("#EXTINF:-1 group-title=\"" + it.getProvider().getName() + "\",");
            sb.append(it.getName());
            sb.append("\n");
            sb.append("http");
            if (Intrinsics.areEqual(it.getProvider().getFormat(), "HLS")) {
                sb.append(this.getHlsUrl(it.getId(), host2, port2));
            } else {
                sb.append(this.getTsUrl(it.getId(), host2, port2));
            }
            sb.append("\n");
            sb.append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue(string, "sb.toString()");
        return string;
    }

    static /* synthetic */ String m3uPlaylist$default(PlaylistUtils playlistUtils, List list, String string, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 8787;
        }
        return playlistUtils.m3uPlaylist(list, string, n);
    }

    @NotNull
    public final String buildPlaylist(@NotNull String type2, @NotNull String host2, int port2, @NotNull String provider2, @NotNull List<PlayableChannel> channels) {
        String string;
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(host2, "host");
        Intrinsics.checkNotNullParameter(provider2, "provider");
        Intrinsics.checkNotNullParameter(channels, "channels");
        if (Intrinsics.areEqual(type2, "txt")) {
            string = this.flussonicPlaylist(channels, host2, port2);
        } else if (Intrinsics.areEqual(type2, "m3u")) {
            string = this.m3uPlaylist(channels, host2, port2);
        } else {
            throw new QlException("Unknown playlist type");
        }
        String pls = string;
        Path path = Paths.get("playlists", new String[0]);
        Intrinsics.checkNotNullExpressionValue(path, "get(path)");
        Path path2 = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (!Files.exists(path2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue(Files.createDirectories(path2, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), "createDirectories(this, *attributes)");
        }
        String fileName = "playlists/" + provider2 + "_playlist_" + System.currentTimeMillis() / (long)1000 + "." + type2;
        FilesKt.writeText(new File(fileName), pls, Charsets.UTF_8);
        return fileName;
    }
}

