/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.client.plugins.websocket;

import io.ktor.client.request.ClientUpgradeContent;
import io.ktor.http.Headers;
import io.ktor.http.HeadersBuilder;
import io.ktor.http.HttpHeaders;
import io.ktor.http.websocket.UtilsKt;
import io.ktor.util.Base64Kt;
import io.ktor.util.CryptoKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\bH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lio/ktor/client/plugins/websocket/WebSocketContent;", "Lio/ktor/client/request/ClientUpgradeContent;", "()V", "headers", "Lio/ktor/http/Headers;", "getHeaders", "()Lio/ktor/http/Headers;", "nonce", "", "toString", "verify", "", "ktor-client-core"})
public final class WebSocketContent
extends ClientUpgradeContent {
    @NotNull
    private final String nonce;
    @NotNull
    private final Headers headers;

    /*
     * WARNING - void declaration
     */
    public WebSocketContent() {
        void $this$headers_u24lambda_u2d1;
        Object $this$nonce_u24lambda_u2d0;
        Object object = new StringBuilder();
        StringBuilder stringBuilder = object;
        WebSocketContent webSocketContent = this;
        boolean bl = false;
        byte[] nonce = CryptoKt.generateNonce(16);
        ((StringBuilder)$this$nonce_u24lambda_u2d0).append(Base64Kt.encodeBase64(nonce));
        String string = ((StringBuilder)object).toString();
        Intrinsics.checkNotNullExpressionValue(string, "StringBuilder().apply(builderAction).toString()");
        webSocketContent.nonce = string;
        $this$nonce_u24lambda_u2d0 = object = new HeadersBuilder(0, 1, null);
        webSocketContent = this;
        boolean bl2 = false;
        $this$headers_u24lambda_u2d1.append(HttpHeaders.INSTANCE.getUpgrade(), "websocket");
        $this$headers_u24lambda_u2d1.append(HttpHeaders.INSTANCE.getConnection(), "upgrade");
        $this$headers_u24lambda_u2d1.append(HttpHeaders.INSTANCE.getSecWebSocketKey(), this.nonce);
        $this$headers_u24lambda_u2d1.append(HttpHeaders.INSTANCE.getSecWebSocketVersion(), "13");
        webSocketContent.headers = ((HeadersBuilder)object).build();
    }

    @Override
    @NotNull
    public Headers getHeaders() {
        return this.headers;
    }

    @Override
    public void verify(@NotNull Headers headers2) {
        Intrinsics.checkNotNullParameter(headers2, "headers");
        String string = headers2.get(HttpHeaders.INSTANCE.getSecWebSocketAccept());
        if (string == null) {
            throw new IllegalStateException(("Server should specify header " + HttpHeaders.INSTANCE.getSecWebSocketAccept()).toString());
        }
        String serverAccept = string;
        String expectedAccept = UtilsKt.websocketServerAccept(this.nonce);
        if (!Intrinsics.areEqual(expectedAccept, serverAccept)) {
            boolean bl = false;
            String string2 = "Failed to verify server accept header. Expected: " + expectedAccept + ", received: " + serverAccept;
            throw new IllegalStateException(string2.toString());
        }
    }

    @NotNull
    public String toString() {
        return "WebSocketContent";
    }
}

