/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.CodecsKt;
import io.ktor.http.Parameters;
import io.ktor.http.ParametersBuilder;
import io.ktor.http.URLBuilderJvmKt;
import io.ktor.http.URLBuilderKt;
import io.ktor.http.URLProtocol;
import io.ktor.http.URLUtilsKt;
import io.ktor.http.Url;
import io.ktor.http.UrlDecodedParametersBuilder;
import io.ktor.http.UrlDecodedParametersBuilderKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b)\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 F2\u00020\u0001:\u0001FBi\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0005\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\b\u0010A\u001a\u00020BH\u0002J\u0006\u0010C\u001a\u00020DJ\u0006\u0010E\u001a\u00020\u0005R\u001a\u0010\u0012\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0014\"\u0004\b \u0010\u0016R \u0010!\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001c\u0010&\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0014\"\u0004\b(\u0010\u0016R$\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b)\u0010\u0014\"\u0004\b*\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u0014\"\u0004\b,\u0010\u0016R\u001e\u0010\f\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u0018@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010\u001bR(\u0010\t\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u0010\u0014\"\u0004\b0\u0010\u0016R0\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u0010#\"\u0004\b2\u0010%R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u0010<\"\u0004\b=\u0010>R(\u0010\b\u001a\u0004\u0018\u00010\u00052\b\u0010\u0017\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b?\u0010\u0014\"\u0004\b@\u0010\u0016\u00a8\u0006G"}, d2={"Lio/ktor/http/URLBuilder;", "", "protocol", "Lio/ktor/http/URLProtocol;", "host", "", "port", "", "user", "password", "pathSegments", "", "parameters", "Lio/ktor/http/Parameters;", "fragment", "trailingQuery", "", "(Lio/ktor/http/URLProtocol;Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;Ljava/util/List;Lio/ktor/http/Parameters;Ljava/lang/String;Z)V", "encodedFragment", "getEncodedFragment", "()Ljava/lang/String;", "setEncodedFragment", "(Ljava/lang/String;)V", "value", "Lio/ktor/http/ParametersBuilder;", "encodedParameters", "getEncodedParameters", "()Lio/ktor/http/ParametersBuilder;", "setEncodedParameters", "(Lio/ktor/http/ParametersBuilder;)V", "encodedPassword", "getEncodedPassword", "setEncodedPassword", "encodedPathSegments", "getEncodedPathSegments", "()Ljava/util/List;", "setEncodedPathSegments", "(Ljava/util/List;)V", "encodedUser", "getEncodedUser", "setEncodedUser", "getFragment", "setFragment", "getHost", "setHost", "<set-?>", "getParameters", "getPassword", "setPassword", "getPathSegments", "setPathSegments", "getPort", "()I", "setPort", "(I)V", "getProtocol", "()Lio/ktor/http/URLProtocol;", "setProtocol", "(Lio/ktor/http/URLProtocol;)V", "getTrailingQuery", "()Z", "setTrailingQuery", "(Z)V", "getUser", "setUser", "applyOrigin", "", "build", "Lio/ktor/http/Url;", "buildString", "Companion", "ktor-http"})
public final class URLBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private URLProtocol protocol;
    @NotNull
    private String host;
    private int port;
    private boolean trailingQuery;
    @Nullable
    private String encodedUser;
    @Nullable
    private String encodedPassword;
    @NotNull
    private String encodedFragment;
    @NotNull
    private List<String> encodedPathSegments;
    @NotNull
    private ParametersBuilder encodedParameters;
    @NotNull
    private ParametersBuilder parameters;
    @NotNull
    private static final Url originUrl = URLUtilsKt.Url(URLBuilderJvmKt.getOrigin(Companion));

    /*
     * WARNING - void declaration
     */
    public URLBuilder(@NotNull URLProtocol protocol, @NotNull String host2, int port2, @Nullable String user2, @Nullable String password, @NotNull List<String> pathSegments, @NotNull Parameters parameters2, @NotNull String fragment, boolean trailingQuery) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(protocol, "protocol");
        Intrinsics.checkNotNullParameter(host2, "host");
        Intrinsics.checkNotNullParameter(pathSegments, "pathSegments");
        Intrinsics.checkNotNullParameter(parameters2, "parameters");
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        this.protocol = protocol;
        this.host = host2;
        this.port = port2;
        this.trailingQuery = trailingQuery;
        String string = user2;
        this.encodedUser = string != null ? CodecsKt.encodeURLParameter$default(string, false, 1, null) : null;
        String string2 = password;
        this.encodedPassword = string2 != null ? CodecsKt.encodeURLParameter$default(string2, false, 1, null) : null;
        this.encodedFragment = CodecsKt.encodeURLQueryComponent$default(fragment, false, false, null, 7, null);
        Iterable iterable = pathSegments;
        URLBuilder uRLBuilder = this;
        boolean $i$f$map = false;
        void var12_13 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string3 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CodecsKt.encodeURLPathPart((String)it));
        }
        uRLBuilder.encodedPathSegments = (List)destination$iv$iv;
        this.encodedParameters = UrlDecodedParametersBuilderKt.encodeParameters(parameters2);
        this.parameters = new UrlDecodedParametersBuilder(this.encodedParameters);
    }

    public /* synthetic */ URLBuilder(URLProtocol uRLProtocol, String string, int n, String string2, String string3, List list, Parameters parameters2, String string4, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            uRLProtocol = URLProtocol.Companion.getHTTP();
        }
        if ((n2 & 2) != 0) {
            string = "";
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 8) != 0) {
            string2 = null;
        }
        if ((n2 & 0x10) != 0) {
            string3 = null;
        }
        if ((n2 & 0x20) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x40) != 0) {
            parameters2 = Parameters.Companion.getEmpty();
        }
        if ((n2 & 0x80) != 0) {
            string4 = "";
        }
        if ((n2 & 0x100) != 0) {
            bl = false;
        }
        this(uRLProtocol, string, n, string2, string3, list, parameters2, string4, bl);
    }

    @NotNull
    public final URLProtocol getProtocol() {
        return this.protocol;
    }

    public final void setProtocol(@NotNull URLProtocol uRLProtocol) {
        Intrinsics.checkNotNullParameter(uRLProtocol, "<set-?>");
        this.protocol = uRLProtocol;
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    public final void setHost(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.host = string;
    }

    public final int getPort() {
        return this.port;
    }

    public final void setPort(int n) {
        this.port = n;
    }

    public final boolean getTrailingQuery() {
        return this.trailingQuery;
    }

    public final void setTrailingQuery(boolean bl) {
        this.trailingQuery = bl;
    }

    @Nullable
    public final String getEncodedUser() {
        return this.encodedUser;
    }

    public final void setEncodedUser(@Nullable String string) {
        this.encodedUser = string;
    }

    @Nullable
    public final String getUser() {
        String string = this.encodedUser;
        return string != null ? CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null) : null;
    }

    public final void setUser(@Nullable String value) {
        String string = value;
        this.encodedUser = string != null ? CodecsKt.encodeURLParameter$default(string, false, 1, null) : null;
    }

    @Nullable
    public final String getEncodedPassword() {
        return this.encodedPassword;
    }

    public final void setEncodedPassword(@Nullable String string) {
        this.encodedPassword = string;
    }

    @Nullable
    public final String getPassword() {
        String string = this.encodedPassword;
        return string != null ? CodecsKt.decodeURLPart$default(string, 0, 0, null, 7, null) : null;
    }

    public final void setPassword(@Nullable String value) {
        String string = value;
        this.encodedPassword = string != null ? CodecsKt.encodeURLParameter$default(string, false, 1, null) : null;
    }

    @NotNull
    public final String getEncodedFragment() {
        return this.encodedFragment;
    }

    public final void setEncodedFragment(@NotNull String string) {
        Intrinsics.checkNotNullParameter(string, "<set-?>");
        this.encodedFragment = string;
    }

    @NotNull
    public final String getFragment() {
        return CodecsKt.decodeURLQueryComponent$default(this.encodedFragment, 0, 0, false, null, 15, null);
    }

    public final void setFragment(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.encodedFragment = CodecsKt.encodeURLQueryComponent$default(value, false, false, null, 7, null);
    }

    @NotNull
    public final List<String> getEncodedPathSegments() {
        return this.encodedPathSegments;
    }

    public final void setEncodedPathSegments(@NotNull List<String> list) {
        Intrinsics.checkNotNullParameter(list, "<set-?>");
        this.encodedPathSegments = list;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> getPathSegments() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.encodedPathSegments;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CodecsKt.decodeURLPart$default((String)it, 0, 0, null, 7, null));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPathSegments(@NotNull List<String> value) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(value, "value");
        Iterable iterable = value;
        URLBuilder uRLBuilder = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(CodecsKt.encodeURLPathPart((String)it));
        }
        uRLBuilder.encodedPathSegments = (List)destination$iv$iv;
    }

    @NotNull
    public final ParametersBuilder getEncodedParameters() {
        return this.encodedParameters;
    }

    public final void setEncodedParameters(@NotNull ParametersBuilder value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.encodedParameters = value;
        this.parameters = new UrlDecodedParametersBuilder(value);
    }

    @NotNull
    public final ParametersBuilder getParameters() {
        return this.parameters;
    }

    @NotNull
    public final String buildString() {
        this.applyOrigin();
        String string = ((StringBuilder)URLBuilderKt.access$appendTo(this, new StringBuilder(256))).toString();
        Intrinsics.checkNotNullExpressionValue(string, "appendTo(StringBuilder(256)).toString()");
        return string;
    }

    @NotNull
    public final Url build() {
        this.applyOrigin();
        return new Url(this.protocol, this.host, this.port, this.getPathSegments(), this.parameters.build(), this.getFragment(), this.getUser(), this.getPassword(), this.trailingQuery, this.buildString());
    }

    private final void applyOrigin() {
        if (((CharSequence)this.host).length() > 0 || Intrinsics.areEqual(this.protocol.getName(), "file")) {
            return;
        }
        this.host = originUrl.getHost();
        if (Intrinsics.areEqual(this.protocol, URLProtocol.Companion.getHTTP())) {
            this.protocol = originUrl.getProtocol();
        }
        if (this.port == 0) {
            this.port = originUrl.getSpecifiedPort();
        }
    }

    public URLBuilder() {
        this(null, null, 0, null, null, null, null, null, false, 511, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/ktor/http/URLBuilder$Companion;", "", "()V", "originUrl", "Lio/ktor/http/Url;", "ktor-http"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

