/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.network.tls;

import io.ktor.network.tls.ParserKt;
import io.ktor.network.tls.ServerKeyExchangeType;
import io.ktor.network.tls.TLSException;
import io.ktor.network.tls.TLSHandshake;
import io.ktor.network.tls.TLSHandshakeType;
import io.ktor.network.tls.TLSRecord;
import io.ktor.network.tls.TLSRecordType;
import io.ktor.network.tls.TLSServerHello;
import io.ktor.network.tls.TLSVersion;
import io.ktor.network.tls.extensions.NamedCurve;
import io.ktor.network.tls.extensions.TLSExtension;
import io.ktor.network.tls.extensions.TLSExtensionType;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.core.BytePacketBuilder;
import io.ktor.utils.io.core.ByteReadPacket;
import io.ktor.utils.io.core.Input;
import io.ktor.utils.io.core.InputArraysKt;
import io.ktor.utils.io.core.InputPrimitivesKt;
import io.ktor.utils.io.core.Output;
import io.ktor.utils.io.core.OutputKt;
import io.ktor.utils.io.core.StringsKt;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.ECPoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0002\u001a\u00020\u0003*\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0006*\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0001H\u0000\u001a\u0015\u0010\b\u001a\u00020\u0001*\u00020\tH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\u0012\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u0004H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0004H\u0000\u001a\u0015\u0010\u0010\u001a\u00020\u0011*\u00020\tH\u0080@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0004H\u0000\u001a\u0015\u0010\u0014\u001a\u00020\u0015*\u00020\tH\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\n\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0004H\u0002\u001a\f\u0010\u0016\u001a\u00020\u0001*\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0017"}, d2={"MAX_TLS_FRAME_SIZE", "", "readCurveParams", "Lio/ktor/network/tls/extensions/NamedCurve;", "Lio/ktor/utils/io/core/ByteReadPacket;", "readECPoint", "Ljava/security/spec/ECPoint;", "fieldSize", "readShortCompatible", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "readTLSCertificate", "", "Ljava/security/cert/Certificate;", "readTLSHandshake", "Lio/ktor/network/tls/TLSHandshake;", "readTLSRecord", "Lio/ktor/network/tls/TLSRecord;", "readTLSServerHello", "Lio/ktor/network/tls/TLSServerHello;", "readTLSVersion", "Lio/ktor/network/tls/TLSVersion;", "readTripleByteLength", "ktor-network-tls"})
public final class ParserKt {
    private static final int MAX_TLS_FRAME_SIZE = 18432;

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readTLSRecord(@NotNull ByteReadChannel var0, @NotNull Continuation<? super TLSRecord> var1_1) {
        if (!(var1_1 instanceof readTLSRecord.1)) ** GOTO lbl-1000
        var8_2 = var1_1;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super readTLSRecord.1>)var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readTLSRecord(null, this);
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var6_5 = TLSRecordType.Companion;
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = var6_5;
                $continuation.label = 1;
                v0 = $this$readTLSRecord.readByte($continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl25
            }
            case 1: {
                var6_5 = (TLSRecordType.Companion)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl25:
                // 2 sources

                type = var6_5.byCode(((Number)v0).byteValue() & 255);
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.label = 2;
                v1 = ParserKt.readTLSVersion($this$readTLSRecord, $continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl38
            }
            case 2: {
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl38:
                // 2 sources

                version = (TLSVersion)v1;
                $continuation.L$0 = $this$readTLSRecord;
                $continuation.L$1 = type;
                $continuation.L$2 = version;
                $continuation.label = 3;
                v2 = ParserKt.readShortCompatible($this$readTLSRecord, $continuation);
                if (v2 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl53
            }
            case 3: {
                version = (TLSVersion)$continuation.L$2;
                type = (TLSRecordType)$continuation.L$1;
                $this$readTLSRecord = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl53:
                // 2 sources

                if ((length = ((Number)v2).intValue() & 65535) > 18432) {
                    throw new TLSException("Illegal TLS frame size: " + length, null, 2, null);
                }
                $continuation.L$0 = type;
                $continuation.L$1 = version;
                $continuation.L$2 = null;
                $continuation.label = 4;
                v3 = $this$readTLSRecord.readPacket(length, $continuation);
                if (v3 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl68
            }
            case 4: {
                version = (TLSVersion)$continuation.L$1;
                type = (TLSRecordType)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v3 = $result;
lbl68:
                // 2 sources

                packet = (ByteReadPacket)v3;
                return new TLSRecord(type, version, packet);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final TLSHandshake readTLSHandshake(@NotNull ByteReadPacket $this$readTLSHandshake) {
        ByteReadPacket byteReadPacket;
        TLSHandshake tLSHandshake;
        Intrinsics.checkNotNullParameter($this$readTLSHandshake, "<this>");
        TLSHandshake $this$readTLSHandshake_u24lambda_u2d1 = tLSHandshake = new TLSHandshake();
        boolean bl = false;
        int typeAndVersion = InputPrimitivesKt.readInt($this$readTLSHandshake);
        $this$readTLSHandshake_u24lambda_u2d1.setType(TLSHandshakeType.Companion.byCode(typeAndVersion >>> 24));
        int length = typeAndVersion & 0xFFFFFF;
        TLSHandshake tLSHandshake2 = $this$readTLSHandshake_u24lambda_u2d1;
        boolean $i$f$buildPacket = false;
        BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
        try {
            BytePacketBuilder $this$readTLSHandshake_u24lambda_u2d1_u24lambda_u2d0 = builder$iv;
            boolean bl2 = false;
            OutputKt.writeFully$default((Output)$this$readTLSHandshake_u24lambda_u2d1_u24lambda_u2d0, StringsKt.readBytes($this$readTLSHandshake, length), 0, 0, 6, null);
            byteReadPacket = builder$iv.build();
        }
        catch (Throwable t$iv) {
            builder$iv.release();
            throw t$iv;
        }
        tLSHandshake2.setPacket(byteReadPacket);
        return tLSHandshake;
    }

    @NotNull
    public static final TLSServerHello readTLSServerHello(@NotNull ByteReadPacket $this$readTLSServerHello) {
        Intrinsics.checkNotNullParameter($this$readTLSServerHello, "<this>");
        TLSVersion version2 = ParserKt.readTLSVersion($this$readTLSServerHello);
        byte[] random = new byte[32];
        InputArraysKt.readFully$default((Input)$this$readTLSServerHello, random, 0, 0, 6, null);
        int sessionIdLength = $this$readTLSServerHello.readByte() & 0xFF;
        if (sessionIdLength > 32) {
            throw new TLSException("sessionId length limit of 32 bytes exceeded: " + sessionIdLength + " specified", null, 2, null);
        }
        byte[] sessionId = new byte[32];
        InputArraysKt.readFully((Input)$this$readTLSServerHello, sessionId, 0, sessionIdLength);
        short suite = InputPrimitivesKt.readShort($this$readTLSServerHello);
        short compressionMethod = (short)((short)$this$readTLSServerHello.readByte() & 0xFF);
        if (compressionMethod != 0) {
            throw new TLSException("Unsupported TLS compression method " + compressionMethod + " (only null 0 compression method is supported)", null, 2, null);
        }
        if ((int)$this$readTLSServerHello.getRemaining() == 0) {
            return new TLSServerHello(version2, random, sessionId, suite, compressionMethod, null, 32, null);
        }
        int extensionSize = InputPrimitivesKt.readShort($this$readTLSServerHello) & 0xFFFF;
        if ((int)$this$readTLSServerHello.getRemaining() != extensionSize) {
            throw new TLSException("Invalid extensions size: requested " + extensionSize + ", available " + $this$readTLSServerHello.getRemaining(), null, 2, null);
        }
        List extensions = new ArrayList();
        while ($this$readTLSServerHello.getRemaining() > 0L) {
            ByteReadPacket byteReadPacket;
            ByteReadPacket byteReadPacket2;
            int type2 = InputPrimitivesKt.readShort($this$readTLSServerHello) & 0xFFFF;
            int length = InputPrimitivesKt.readShort($this$readTLSServerHello) & 0xFFFF;
            Collection collection = extensions;
            int n = length;
            TLSExtensionType tLSExtensionType = TLSExtensionType.Companion.byCode(type2);
            boolean $i$f$buildPacket = false;
            BytePacketBuilder builder$iv = new BytePacketBuilder(null, 1, null);
            try {
                BytePacketBuilder $this$readTLSServerHello_u24lambda_u2d2 = builder$iv;
                boolean bl = false;
                OutputKt.writeFully$default((Output)$this$readTLSServerHello_u24lambda_u2d2, StringsKt.readBytes($this$readTLSServerHello, length), 0, 0, 6, null);
                byteReadPacket2 = builder$iv.build();
            }
            catch (Throwable t$iv) {
                builder$iv.release();
                throw t$iv;
            }
            ByteReadPacket byteReadPacket3 = byteReadPacket = byteReadPacket2;
            int n2 = n;
            TLSExtensionType tLSExtensionType2 = tLSExtensionType;
            collection.add(new TLSExtension(tLSExtensionType2, n2, byteReadPacket3));
        }
        return new TLSServerHello(version2, random, sessionId, suite, compressionMethod, extensions);
    }

    @NotNull
    public static final NamedCurve readCurveParams(@NotNull ByteReadPacket $this$readCurveParams) {
        Intrinsics.checkNotNullParameter($this$readCurveParams, "<this>");
        int type2 = $this$readCurveParams.readByte() & 0xFF;
        switch (WhenMappings.$EnumSwitchMapping$0[ServerKeyExchangeType.Companion.byCode(type2).ordinal()]) {
            case 1: {
                short curveId = InputPrimitivesKt.readShort($this$readCurveParams);
                NamedCurve namedCurve = NamedCurve.Companion.fromCode(curveId);
                if (namedCurve == null) {
                    throw new TLSException("Unknown EC id", null, 2, null);
                }
                return namedCurve;
            }
            case 2: {
                throw new IllegalStateException("ExplicitPrime server key exchange type is not yet supported".toString());
            }
            case 3: {
                throw new IllegalStateException("ExplicitChar server key exchange type is not yet supported".toString());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public static final List<Certificate> readTLSCertificate(@NotNull ByteReadPacket $this$readTLSCertificate) {
        int certificateLength;
        Intrinsics.checkNotNullParameter($this$readTLSCertificate, "<this>");
        int certificatesChainLength = ParserKt.readTripleByteLength($this$readTLSCertificate);
        ArrayList<Certificate> result2 = new ArrayList<Certificate>();
        CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
        Intrinsics.checkNotNull(certificateFactory);
        CertificateFactory factory2 = certificateFactory;
        for (int certificateBase = 0; certificateBase < certificatesChainLength; certificateBase += certificateLength + 3) {
            certificateLength = ParserKt.readTripleByteLength($this$readTLSCertificate);
            if (certificateLength > certificatesChainLength - certificateBase) {
                throw new TLSException("Certificate length is too big", null, 2, null);
            }
            if ((long)certificateLength > $this$readTLSCertificate.getRemaining()) {
                throw new TLSException("Certificate length is too big", null, 2, null);
            }
            byte[] certificate = new byte[certificateLength];
            InputArraysKt.readFully$default((Input)$this$readTLSCertificate, certificate, 0, 0, 6, null);
            Certificate x509 = factory2.generateCertificate(new ByteArrayInputStream(certificate));
            result2.add(x509);
        }
        return result2;
    }

    @NotNull
    public static final ECPoint readECPoint(@NotNull ByteReadPacket $this$readECPoint, int fieldSize) {
        Intrinsics.checkNotNullParameter($this$readECPoint, "<this>");
        int pointSize = $this$readECPoint.readByte() & 0xFF;
        byte tag = $this$readECPoint.readByte();
        if (tag != 4) {
            throw new TLSException("Point should be uncompressed", null, 2, null);
        }
        int componentLength = (pointSize - 1) / 2;
        if (fieldSize + 7 >>> 3 != componentLength) {
            throw new TLSException("Invalid point component length", null, 2, null);
        }
        return new ECPoint(new BigInteger(1, StringsKt.readBytes($this$readECPoint, componentLength)), new BigInteger(1, StringsKt.readBytes($this$readECPoint, componentLength)));
    }

    /*
     * Unable to fully structure code
     */
    private static final Object readTLSVersion(ByteReadChannel var0, Continuation<? super TLSVersion> var1_1) {
        if (!(var1_1 instanceof readTLSVersion.1)) ** GOTO lbl-1000
        var4_2 = var1_1;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super readTLSVersion.1>)var1_1){
                Object L$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.access$readTLSVersion(null, this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var2_5 = TLSVersion.Companion;
                $continuation.L$0 = var2_5;
                $continuation.label = 1;
                v0 = ParserKt.readShortCompatible($this$readTLSVersion, $continuation);
                if (v0 == var5_4) {
                    return var5_4;
                }
                ** GOTO lbl23
            }
            case 1: {
                var2_5 = (TLSVersion.Companion)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl23:
                // 2 sources

                return var2_5.byCode(((Number)v0).intValue() & 65535);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private static final TLSVersion readTLSVersion(ByteReadPacket $this$readTLSVersion) {
        return TLSVersion.Companion.byCode(InputPrimitivesKt.readShort($this$readTLSVersion) & 0xFFFF);
    }

    public static final int readTripleByteLength(@NotNull ByteReadPacket $this$readTripleByteLength) {
        Intrinsics.checkNotNullParameter($this$readTripleByteLength, "<this>");
        return ($this$readTripleByteLength.readByte() & 0xFF) << 16 | InputPrimitivesKt.readShort($this$readTripleByteLength) & 0xFFFF;
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object readShortCompatible(@NotNull ByteReadChannel var0, @NotNull Continuation<? super Integer> var1_1) {
        if (!(var1_1 instanceof readShortCompatible.1)) ** GOTO lbl-1000
        var5_2 = var1_1;
        if ((var5_2.label & -2147483648) != 0) {
            var5_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl((Continuation<? super readShortCompatible.1>)var1_1){
                Object L$0;
                int I$0;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ParserKt.readShortCompatible(null, this);
                }
            };
        }
        $result = $continuation.result;
        var6_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = $this$readShortCompatible;
                $continuation.label = 1;
                v0 = $this$readShortCompatible.readByte($continuation);
                if (v0 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl22
            }
            case 1: {
                $this$readShortCompatible = (ByteReadChannel)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                first = ((Number)v0).byteValue() & 255;
                $continuation.L$0 = null;
                $continuation.I$0 = first;
                $continuation.label = 2;
                v1 = $this$readShortCompatible.readByte($continuation);
                if (v1 == var6_4) {
                    return var6_4;
                }
                ** GOTO lbl34
            }
            case 2: {
                first = $continuation.I$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl34:
                // 2 sources

                second = ((Number)v1).byteValue() & 255;
                return Boxing.boxInt((first << 8) + second);
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static final /* synthetic */ Object access$readTLSVersion(ByteReadChannel $receiver, Continuation $completion) {
        return ParserKt.readTLSVersion($receiver, $completion);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ServerKeyExchangeType.values().length];
            nArray[ServerKeyExchangeType.NamedCurve.ordinal()] = 1;
            nArray[ServerKeyExchangeType.ExplicitPrime.ordinal()] = 2;
            nArray[ServerKeyExchangeType.ExplicitChar.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

