/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.config;

import io.ktor.server.config.ApplicationConfig;
import io.ktor.server.config.ApplicationConfigValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00010\u00122\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u000e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0010\u001a\u00020\tH\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00190\u0018H\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R!\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0003\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006\u00a8\u0006\u001a"}, d2={"Lio/ktor/server/config/MergedApplicationConfig;", "Lio/ktor/server/config/ApplicationConfig;", "first", "second", "(Lio/ktor/server/config/ApplicationConfig;Lio/ktor/server/config/ApplicationConfig;)V", "getFirst", "()Lio/ktor/server/config/ApplicationConfig;", "firstKeys", "", "", "getFirstKeys", "()Ljava/util/Set;", "firstKeys$delegate", "Lkotlin/Lazy;", "getSecond", "config", "path", "configList", "", "keys", "property", "Lio/ktor/server/config/ApplicationConfigValue;", "propertyOrNull", "toMap", "", "", "ktor-server-core"})
public final class MergedApplicationConfig
implements ApplicationConfig {
    @NotNull
    private final ApplicationConfig first;
    @NotNull
    private final ApplicationConfig second;
    @NotNull
    private final Lazy firstKeys$delegate;

    public MergedApplicationConfig(@NotNull ApplicationConfig first2, @NotNull ApplicationConfig second2) {
        Intrinsics.checkNotNullParameter(first2, "first");
        Intrinsics.checkNotNullParameter(second2, "second");
        this.first = first2;
        this.second = second2;
        this.firstKeys$delegate = LazyKt.lazy((Function0)new Function0<Set<? extends String>>(this){
            final /* synthetic */ MergedApplicationConfig this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Set<String> invoke() {
                return this.this$0.getFirst().keys();
            }
        });
    }

    @NotNull
    public final ApplicationConfig getFirst() {
        return this.first;
    }

    @NotNull
    public final ApplicationConfig getSecond() {
        return this.second;
    }

    private final Set<String> getFirstKeys() {
        Lazy lazy = this.firstKeys$delegate;
        return (Set)lazy.getValue();
    }

    @Override
    @NotNull
    public ApplicationConfigValue property(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.getFirstKeys().contains(path) ? this.first.property(path) : this.second.property(path);
    }

    @Override
    @Nullable
    public ApplicationConfigValue propertyOrNull(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.getFirstKeys().contains(path) ? this.first.propertyOrNull(path) : this.second.propertyOrNull(path);
    }

    @Override
    @NotNull
    public ApplicationConfig config(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.getFirstKeys().contains(path) ? this.first.config(path) : this.second.config(path);
    }

    @Override
    @NotNull
    public List<ApplicationConfig> configList(@NotNull String path) {
        Intrinsics.checkNotNullParameter(path, "path");
        return this.getFirstKeys().contains(path) ? this.first.configList(path) : this.second.configList(path);
    }

    @Override
    @NotNull
    public Set<String> keys() {
        return SetsKt.plus(this.getFirstKeys(), (Iterable)this.second.keys());
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        return MapsKt.plus(this.second.toMap(), this.first.toMap());
    }
}

