/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.engine;

import io.ktor.http.ContentType;
import io.ktor.http.HeaderValueWithParameters;
import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.application.ApplicationCall;
import io.ktor.server.application.ApplicationCallKt;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.engine.LongKt;
import io.ktor.server.engine.internal.ApplicationUtilsJvmKt;
import io.ktor.server.http.LinkHeaderKt;
import io.ktor.server.plugins.OriginConnectionPointKt;
import io.ktor.server.response.ApplicationResponse;
import io.ktor.server.response.ApplicationResponsePropertiesKt;
import io.ktor.server.response.ApplicationSendPipeline;
import io.ktor.server.response.ResponseCookies;
import io.ktor.server.response.ResponseHeaders;
import io.ktor.server.response.ResponsePushBuilder;
import io.ktor.server.response.UseHttp2Push;
import io.ktor.util.AttributeKey;
import io.ktor.util.cio.ChannelWriteException;
import io.ktor.util.internal.ExceptionUtilsJvmKt;
import io.ktor.util.pipeline.PipelineContext;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteReadChannelJVMKt;
import io.ktor.utils.io.ByteReadChannelKt;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ClosedWriteChannelException;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CopyableThrowable;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b&\u0018\u0000 ?2\u00020\u0001:\u0005=>?@AB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0018\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u00182\u0006\u0010 \u001a\u00020!H\u0017J\u0019\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020$H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010%J\u0019\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010)J\u0019\u0010*\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020+H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010,J\u0019\u0010-\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010.J\u0019\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00102J\u0019\u00103\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u000204H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00105J\u0011\u00106\u001a\u000207H\u00a4@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00108J\u0010\u00109\u001a\u00020\u00182\u0006\u0010:\u001a\u00020\u0006H$J\n\u0010;\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010;\u001a\u00020\u00182\u0006\u0010<\u001a\u00020\u0006H\u0016R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006B"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse;", "Lio/ktor/server/response/ApplicationResponse;", "call", "Lio/ktor/server/application/ApplicationCall;", "(Lio/ktor/server/application/ApplicationCall;)V", "_status", "Lio/ktor/http/HttpStatusCode;", "getCall", "()Lio/ktor/server/application/ApplicationCall;", "cookies", "Lio/ktor/server/response/ResponseCookies;", "getCookies", "()Lio/ktor/server/response/ResponseCookies;", "cookies$delegate", "Lkotlin/Lazy;", "isCommitted", "", "()Z", "pipeline", "Lio/ktor/server/response/ApplicationSendPipeline;", "getPipeline", "()Lio/ktor/server/response/ApplicationSendPipeline;", "responded", "commitHeaders", "", "content", "Lio/ktor/http/content/OutgoingContent;", "ensureLength", "expected", "", "actual", "push", "builder", "Lio/ktor/server/response/ResponsePushBuilder;", "respondFromBytes", "bytes", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondFromChannel", "readChannel", "Lio/ktor/utils/io/ByteReadChannel;", "(Lio/ktor/utils/io/ByteReadChannel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondNoContent", "Lio/ktor/http/content/OutgoingContent$NoContent;", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondOutgoingContent", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondUpgrade", "upgrade", "Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;", "(Lio/ktor/http/content/OutgoingContent$ProtocolUpgrade;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondWriteChannelContent", "Lio/ktor/http/content/OutgoingContent$WriteChannelContent;", "(Lio/ktor/http/content/OutgoingContent$WriteChannelContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "responseChannel", "Lio/ktor/utils/io/ByteWriteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "setStatus", "statusCode", "status", "value", "BodyLengthIsTooLong", "BodyLengthIsTooSmall", "Companion", "InvalidHeaderForContent", "ResponseAlreadySentException", "ktor-server-host-common"})
public abstract class BaseApplicationResponse
implements ApplicationResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationCall call;
    @Nullable
    private HttpStatusCode _status;
    @NotNull
    private final Lazy cookies$delegate;
    private boolean responded;
    @NotNull
    private final ApplicationSendPipeline pipeline;
    @NotNull
    private static final AttributeKey<BaseApplicationResponse> EngineResponseAttributeKey = new AttributeKey("EngineResponse");

    /*
     * WARNING - void declaration
     */
    public BaseApplicationResponse(@NotNull ApplicationCall call) {
        void $this$pipeline_u24lambda_u2d0;
        ApplicationSendPipeline applicationSendPipeline;
        Intrinsics.checkNotNullParameter(call, "call");
        this.call = call;
        this.cookies$delegate = LazyKt.lazy((Function0)new Function0<ResponseCookies>(this){
            final /* synthetic */ BaseApplicationResponse this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final ResponseCookies invoke() {
                return new ResponseCookies(this.this$0, Intrinsics.areEqual(OriginConnectionPointKt.getOrigin(this.this$0.getCall().getRequest()).getScheme(), "https") || Intrinsics.areEqual(OriginConnectionPointKt.getOrigin(this.this$0.getCall().getRequest()).getScheme(), "wss"));
            }
        });
        ApplicationSendPipeline applicationSendPipeline2 = applicationSendPipeline = new ApplicationSendPipeline(this.call.getApplication().getEnvironment().getDevelopmentMode());
        BaseApplicationResponse baseApplicationResponse = this;
        boolean bl = false;
        $this$pipeline_u24lambda_u2d0.resetFrom(this.call.getApplication().getSendPipeline());
        baseApplicationResponse.pipeline = applicationSendPipeline;
    }

    @Override
    @NotNull
    public final ApplicationCall getCall() {
        return this.call;
    }

    @Override
    public boolean isCommitted() {
        return this.responded;
    }

    @Override
    @NotNull
    public ResponseCookies getCookies() {
        Lazy lazy = this.cookies$delegate;
        return (ResponseCookies)lazy.getValue();
    }

    @Override
    @Nullable
    public HttpStatusCode status() {
        return this._status;
    }

    @Override
    public void status(@NotNull HttpStatusCode value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this._status = value;
        this.setStatus(value);
    }

    @Override
    @NotNull
    public final ApplicationSendPipeline getPipeline() {
        return this.pipeline;
    }

    protected final void commitHeaders(@NotNull OutgoingContent content2) {
        OutgoingContent outgoingContent;
        Object object;
        Object it;
        Intrinsics.checkNotNullParameter(content2, "content");
        if (this.responded) {
            throw new ResponseAlreadySentException();
        }
        this.responded = true;
        Ref.BooleanRef transferEncodingSet = new Ref.BooleanRef();
        HttpStatusCode httpStatusCode = content2.getStatus();
        if (httpStatusCode != null) {
            it = httpStatusCode;
            boolean bl = false;
            this.status((HttpStatusCode)it);
            object = Unit.INSTANCE;
        } else {
            object = this.status();
            if (object == null) {
                this.status(HttpStatusCode.Companion.getOK());
                object = Unit.INSTANCE;
            }
        }
        content2.getHeaders().forEach((Function2<? super String, ? super List<String>, Unit>)new Function2<String, List<? extends String>, Unit>(transferEncodingSet, content2, this){
            final /* synthetic */ Ref.BooleanRef $transferEncodingSet;
            final /* synthetic */ OutgoingContent $content;
            final /* synthetic */ BaseApplicationResponse this$0;
            {
                this.$transferEncodingSet = $transferEncodingSet;
                this.$content = $content;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@NotNull String name, @NotNull List<String> values2) {
                Intrinsics.checkNotNullParameter(name, "name");
                Intrinsics.checkNotNullParameter(values2, "values");
                String string = name;
                if (Intrinsics.areEqual(string, HttpHeaders.INSTANCE.getTransferEncoding())) {
                    this.$transferEncodingSet.element = true;
                } else if (Intrinsics.areEqual(string, HttpHeaders.INSTANCE.getUpgrade())) {
                    if (!(this.$content instanceof OutgoingContent.ProtocolUpgrade)) {
                        throw new InvalidHeaderForContent(HttpHeaders.INSTANCE.getUpgrade(), "non-upgrading response");
                    }
                    for (String value : values2) {
                        this.this$0.getHeaders().append(name, value, false);
                    }
                    return;
                }
                for (String value : values2) {
                    ResponseHeaders.append$default(this.this$0.getHeaders(), name, value, false, 4, null);
                }
            }
        });
        Long contentLength = content2.getContentLength();
        if (contentLength != null) {
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), LongKt.toStringFast(contentLength), false);
        } else if (!transferEncodingSet.element && !((outgoingContent = content2) instanceof OutgoingContent.ProtocolUpgrade)) {
            if (outgoingContent instanceof OutgoingContent.NoContent) {
                this.getHeaders().append(HttpHeaders.INSTANCE.getContentLength(), "0", false);
            } else {
                this.getHeaders().append(HttpHeaders.INSTANCE.getTransferEncoding(), "chunked", false);
            }
        }
        ContentType contentType2 = content2.getContentType();
        if (contentType2 != null) {
            it = contentType2;
            boolean bl = false;
            this.getHeaders().append(HttpHeaders.INSTANCE.getContentType(), ((HeaderValueWithParameters)it).toString(), false);
        }
        String connection = this.call.getRequest().getHeaders().get(HttpHeaders.INSTANCE.getConnection());
        if (connection != null && !this.call.getResponse().getHeaders().contains(HttpHeaders.INSTANCE.getConnection())) {
            if (StringsKt.equals(connection, "close", true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, "Connection", "close");
            } else if (StringsKt.equals(connection, "keep-alive", true)) {
                ApplicationResponsePropertiesKt.header((ApplicationResponse)this, "Connection", "keep-alive");
            }
        }
    }

    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent content2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this, content2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static /* synthetic */ Object respondOutgoingContent$suspendImpl(BaseApplicationResponse var0, OutgoingContent var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof respondOutgoingContent.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondOutgoingContent$suspendImpl(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                var3_6 = content;
                if (var3_6 instanceof OutgoingContent.ProtocolUpgrade) {
                    this.commitHeaders((OutgoingContent)content);
                    $continuation.label = 1;
                    v0 = this.respondUpgrade((OutgoingContent.ProtocolUpgrade)content, $continuation);
                    v1 = v0;
                    if (v0 != var8_5) return Unit.INSTANCE;
                    return var8_5;
                }
                ** GOTO lbl25
            }
            case 1: {
                ResultKt.throwOnFailure($result);
                v1 = $result;
                return Unit.INSTANCE;
            }
lbl25:
            // 1 sources

            if (var3_6 instanceof OutgoingContent.ByteArrayContent) {
                bytes = ((OutgoingContent.ByteArrayContent)content).bytes();
                this.commitHeaders((OutgoingContent)content);
                $continuation.label = 2;
                v2 = this.respondFromBytes(bytes, $continuation);
                v3 = v2;
                if (v2 != var8_5) return Unit.INSTANCE;
                return var8_5;
            }
            ** GOTO lbl38
            case 2: {
                ResultKt.throwOnFailure($result);
                v3 = $result;
                return Unit.INSTANCE;
            }
lbl38:
            // 1 sources

            if (var3_6 instanceof OutgoingContent.WriteChannelContent) {
                this.commitHeaders((OutgoingContent)content);
                $continuation.label = 3;
                v4 = this.respondWriteChannelContent((OutgoingContent.WriteChannelContent)content, $continuation);
                v5 = v4;
                if (v4 != var8_5) return Unit.INSTANCE;
                return var8_5;
            }
            ** GOTO lbl50
            case 3: {
                ResultKt.throwOnFailure($result);
                v5 = $result;
                return Unit.INSTANCE;
            }
lbl50:
            // 1 sources

            if (!(var3_6 instanceof OutgoingContent.ReadChannelContent)) {
                if (var3_6 instanceof OutgoingContent.NoContent == false) throw new NoWhenBranchMatchedException();
                this.commitHeaders((OutgoingContent)content);
                $continuation.label = 5;
                v6 = this.respondNoContent((OutgoingContent.NoContent)content, $continuation);
                v7 = v6;
                if (v6 != var8_5) return Unit.INSTANCE;
                return var8_5;
            }
            readChannel = ((OutgoingContent.ReadChannelContent)content).readFrom();
            this.commitHeaders((OutgoingContent)content);
            $continuation.L$0 = readChannel;
            $continuation.label = 4;
            v8 = this.respondFromChannel(readChannel, $continuation);
            v9 = v8;
            if (v8 != var8_5) return Unit.INSTANCE;
            return var8_5;
            case 4: {
                readChannel = (ByteReadChannel)$continuation.L$0;
                ** try [egrp 1[TRYBLOCK] [1 : 331->345)] { 
lbl74:
                // 1 sources

                ResultKt.throwOnFailure($result);
                v9 = $result;
                return Unit.INSTANCE;
lbl78:
                // 1 sources

                finally {
                    ByteReadChannelKt.cancel(readChannel);
                }
            }
            case 5: {
                ResultKt.throwOnFailure($result);
                v7 = $result;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent content2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondNoContent$suspendImpl(this, content2, $completion);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(BaseApplicationResponse this_, OutgoingContent.NoContent content2, Continuation $completion) {
        return Unit.INSTANCE;
    }

    @Nullable
    protected Object respondWriteChannelContent(@NotNull OutgoingContent.WriteChannelContent content2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this, content2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondWriteChannelContent$suspendImpl(BaseApplicationResponse var0, OutgoingContent.WriteChannelContent var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof respondWriteChannelContent.1)) ** GOTO lbl-1000
        var10_3 = var2_2;
        if ((var10_3.label & -2147483648) != 0) {
            var10_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondWriteChannelContent$suspendImpl(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var11_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = content;
                $continuation.label = 1;
                v0 = this.responseChannel($continuation);
                if (v0 == var11_5) {
                    return var11_5;
                }
                ** GOTO lbl22
            }
            case 1: {
                content = (OutgoingContent.WriteChannelContent)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl22:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v0;
                $i$f$use = false;
                $this$respondWriteChannelContent_u24lambda_u2d3 = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondWriteChannelContent$2 = false;
                $continuation.L$0 = $this$use$iv;
                $continuation.label = 2;
                v1 = BuildersKt.withContext(ApplicationUtilsJvmKt.getIOBridge(Dispatchers.INSTANCE), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(content, $this$respondWriteChannelContent_u24lambda_u2d3, null){
                    int label;
                    final /* synthetic */ OutgoingContent.WriteChannelContent $content;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    {
                        this.$content = $content;
                        this.$this_use = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.label = 1;
                                Object object3 = this.$content.writeTo(this.$this_use, this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v1 != var11_5) goto lbl36
lbl35:
                // 1 sources

                return var11_5;
lbl36:
                // 1 sources

                ** GOTO lbl59
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondWriteChannelContent$2 = false;
                $this$use$iv = (ByteWriteChannel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v1 = $result;
                    ** GOTO lbl59
                    {
                        catch (ClosedWriteChannelException closed) {
                            throw new ChannelWriteException(null, (Throwable)closed, 1, null);
                        }
                    }
                }
                catch (Throwable cause$iv) {
                    $this$use$iv.close(cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var8_14) {
                throw var8_14;
            }
            {
                finally {
                    ByteWriteChannelKt.close($this$use$iv);
                }
lbl59:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromBytes(@NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondFromBytes$suspendImpl(this, bytes, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromBytes$suspendImpl(BaseApplicationResponse var0, byte[] var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof respondFromBytes.1)) ** GOTO lbl-1000
        var11_3 = var2_2;
        if ((var11_3.label & -2147483648) != 0) {
            var11_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromBytes$suspendImpl(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var12_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                v0 = this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                if (v0 != null) {
                    length = Long.parseLong(v0);
                    $i$a$-let-BaseApplicationResponse$respondFromBytes$2 = false;
                    this.ensureLength(length, bytes.length);
                }
                $continuation.L$0 = bytes;
                $continuation.label = 1;
                v1 = this.responseChannel($continuation);
                if (v1 == var12_5) {
                    return var12_5;
                }
                ** GOTO lbl29
            }
            case 1: {
                bytes = (byte[])$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v1 = $result;
lbl29:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v1;
                $i$f$use = false;
                $this$respondFromBytes_u24lambda_u2d5 = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondFromBytes$3 = false;
                $continuation.L$0 = $this$use$iv;
                $continuation.label = 2;
                v2 = BuildersKt.withContext(Dispatchers.getUnconfined(), (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$respondFromBytes_u24lambda_u2d5, bytes, null){
                    int label;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    final /* synthetic */ byte[] $bytes;
                    {
                        this.$this_use = $receiver;
                        this.$bytes = $bytes;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                this.label = 1;
                                Object object3 = ByteWriteChannelKt.writeFully(this.$this_use, this.$bytes, this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v2 != var12_5) goto lbl41
lbl40:
                // 1 sources

                return var12_5;
lbl41:
                // 1 sources

                ** GOTO lbl61
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondFromBytes$3 = false;
                $this$use$iv = (ByteWriteChannel)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v2 = $result;
                    ** GOTO lbl61
                }
                catch (Throwable cause$iv) {
                    $this$use$iv.close(cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var7_8) {
                throw var7_8;
            }
            {
                finally {
                    ByteWriteChannelKt.close($this$use$iv);
                }
lbl61:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    protected Object respondFromChannel(@NotNull ByteReadChannel readChannel2, @NotNull Continuation<? super Unit> $completion) {
        return BaseApplicationResponse.respondFromChannel$suspendImpl(this, readChannel2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondFromChannel$suspendImpl(BaseApplicationResponse var0, ByteReadChannel var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof respondFromChannel.1)) ** GOTO lbl-1000
        var14_3 = var2_2;
        if ((var14_3.label & -2147483648) != 0) {
            var14_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                long J$0;
                /* synthetic */ Object result;
                final /* synthetic */ BaseApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return BaseApplicationResponse.respondFromChannel$suspendImpl(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var15_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.label = 1;
                v0 = this.responseChannel($continuation);
                if (v0 == var15_5) {
                    return var15_5;
                }
                ** GOTO lbl24
            }
            case 1: {
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v0 = $result;
lbl24:
                // 2 sources

                $this$use$iv = (ByteWriteChannel)v0;
                $i$f$use = false;
                $this$respondFromChannel_u24lambda_u2d6 = $this$use$iv;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                v1 = this.getHeaders().get(HttpHeaders.INSTANCE.getContentLength());
                length = v1 != null ? Boxing.boxLong(Long.parseLong(v1)) : null;
                $continuation.L$0 = this;
                $continuation.L$1 = readChannel;
                $continuation.L$2 = $this$use$iv;
                $continuation.L$3 = length;
                $continuation.label = 2;
                v2 = BuildersKt.withContext(Dispatchers.getUnconfined(), (Function2)new Function2<CoroutineScope, Continuation<? super Long>, Object>(readChannel, $this$respondFromChannel_u24lambda_u2d6, length, null){
                    int label;
                    final /* synthetic */ ByteReadChannel $readChannel;
                    final /* synthetic */ ByteWriteChannel $this_use;
                    final /* synthetic */ Long $length;
                    {
                        this.$readChannel = $readChannel;
                        this.$this_use = $receiver;
                        this.$length = $length;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure(object);
                                Long l = this.$length;
                                this.label = 1;
                                Object object3 = ByteReadChannelJVMKt.copyTo(this.$readChannel, this.$this_use, l != null ? l : Long.MAX_VALUE, this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure($result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Long> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }, $continuation);
                ** if (v2 != var15_5) goto lbl41
lbl40:
                // 1 sources

                return var15_5;
lbl41:
                // 1 sources

                ** GOTO lbl53
            }
            case 2: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                length = (Long)$continuation.L$3;
                $this$use$iv = (ByteWriteChannel)$continuation.L$2;
                readChannel = (ByteReadChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                ResultKt.throwOnFailure($result);
                v2 = $result;
lbl53:
                // 2 sources

                copied = ((Number)v2).longValue();
                v3 = length;
                if (v3 != null) ** GOTO lbl57
                ** GOTO lbl93
lbl57:
                // 1 sources

                v3.longValue();
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.L$2 = length;
                $continuation.L$3 = null;
                $continuation.J$0 = copied;
                $continuation.label = 3;
                v4 = readChannel.discard(1L, $continuation);
                ** if (v4 != var15_5) goto lbl67
lbl66:
                // 1 sources

                return var15_5;
lbl67:
                // 1 sources

                ** GOTO lbl79
            }
            case 3: {
                $i$f$use = false;
                $i$a$-use-BaseApplicationResponse$respondFromChannel$2 = false;
                copied = $continuation.J$0;
                length = (Long)$continuation.L$2;
                $this$use$iv = (ByteWriteChannel)$continuation.L$1;
                this = (BaseApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v4 = $result;
lbl79:
                    // 2 sources

                    discarded = ((Number)v4).longValue();
                    this.ensureLength(length, copied + discarded);
                    ** GOTO lbl93
                }
                catch (Throwable cause$iv) {
                    $this$use$iv.close(cause$iv);
                    throw cause$iv;
                }
            }
            catch (Throwable var12_18) {
                throw var12_18;
            }
            {
                finally {
                    ByteWriteChannelKt.close($this$use$iv);
                }
lbl93:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void ensureLength(long expected, long actual) {
        if (expected < actual) {
            throw new BodyLengthIsTooLong(expected);
        }
        if (expected > actual) {
            throw new BodyLengthIsTooSmall(expected, actual);
        }
    }

    @Nullable
    protected abstract Object respondUpgrade(@NotNull OutgoingContent.ProtocolUpgrade var1, @NotNull Continuation<? super Unit> var2);

    @Nullable
    protected abstract Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> var1);

    protected abstract void setStatus(@NotNull HttpStatusCode var1);

    @Override
    @UseHttp2Push
    public void push(@NotNull ResponsePushBuilder builder) {
        Intrinsics.checkNotNullParameter(builder, "builder");
        String[] stringArray = new String[]{"prefetch"};
        LinkHeaderKt.link(this, builder.getUrl().buildString(), stringArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$ResponseAlreadySentException;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "()V", "ktor-server-host-common"})
    public static final class ResponseAlreadySentException
    extends IllegalStateException {
        public ResponseAlreadySentException() {
            super("Response has already been sent");
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0000H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$InvalidHeaderForContent;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "Lkotlinx/coroutines/CopyableThrowable;", "name", "", "content", "(Ljava/lang/String;Ljava/lang/String;)V", "createCopy", "ktor-server-host-common"})
    public static final class InvalidHeaderForContent
    extends IllegalStateException
    implements CopyableThrowable<InvalidHeaderForContent> {
        @NotNull
        private final String name;
        @NotNull
        private final String content;

        public InvalidHeaderForContent(@NotNull String name, @NotNull String content2) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(content2, "content");
            super("Header " + name + " is not allowed for " + content2);
            this.name = name;
            this.content = content2;
        }

        @Override
        @NotNull
        public InvalidHeaderForContent createCopy() {
            InvalidHeaderForContent invalidHeaderForContent;
            InvalidHeaderForContent it = invalidHeaderForContent = new InvalidHeaderForContent(this.name, this.content);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge(it, this);
            return invalidHeaderForContent;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\u0000H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooSmall;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "Lkotlinx/coroutines/CopyableThrowable;", "expected", "", "actual", "(JJ)V", "createCopy", "ktor-server-host-common"})
    public static final class BodyLengthIsTooSmall
    extends IllegalStateException
    implements CopyableThrowable<BodyLengthIsTooSmall> {
        private final long expected;
        private final long actual;

        public BodyLengthIsTooSmall(long expected, long actual) {
            super("Body.size is too small. Body: " + actual + ", Content-Length: " + expected);
            this.expected = expected;
            this.actual = actual;
        }

        @Override
        @NotNull
        public BodyLengthIsTooSmall createCopy() {
            BodyLengthIsTooSmall bodyLengthIsTooSmall;
            BodyLengthIsTooSmall it = bodyLengthIsTooSmall = new BodyLengthIsTooSmall(this.expected, this.actual);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge(it, this);
            return bodyLengthIsTooSmall;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00060\u0001j\u0002`\u00022\b\u0012\u0004\u0012\u00020\u00000\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0000H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$BodyLengthIsTooLong;", "Ljava/lang/IllegalStateException;", "Lkotlin/IllegalStateException;", "Lkotlinx/coroutines/CopyableThrowable;", "expected", "", "(J)V", "createCopy", "ktor-server-host-common"})
    public static final class BodyLengthIsTooLong
    extends IllegalStateException
    implements CopyableThrowable<BodyLengthIsTooLong> {
        private final long expected;

        public BodyLengthIsTooLong(long expected) {
            super("Body.size is too long. Expected " + expected);
            this.expected = expected;
        }

        @Override
        @NotNull
        public BodyLengthIsTooLong createCopy() {
            BodyLengthIsTooLong bodyLengthIsTooLong;
            BodyLengthIsTooLong it = bodyLengthIsTooLong = new BodyLengthIsTooLong(this.expected);
            boolean bl = false;
            ExceptionUtilsJvmKt.initCauseBridge(it, this);
            return bodyLengthIsTooLong;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lio/ktor/server/engine/BaseApplicationResponse$Companion;", "", "()V", "EngineResponseAttributeKey", "Lio/ktor/util/AttributeKey;", "Lio/ktor/server/engine/BaseApplicationResponse;", "getEngineResponseAttributeKey", "()Lio/ktor/util/AttributeKey;", "setupSendPipeline", "", "sendPipeline", "Lio/ktor/server/response/ApplicationSendPipeline;", "ktor-server-host-common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AttributeKey<BaseApplicationResponse> getEngineResponseAttributeKey() {
            return EngineResponseAttributeKey;
        }

        public final void setupSendPipeline(@NotNull ApplicationSendPipeline sendPipeline) {
            Intrinsics.checkNotNullParameter(sendPipeline, "sendPipeline");
            sendPipeline.intercept(ApplicationSendPipeline.Phases.getEngine(), (Function3)new Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object>(null){
                int label;
                private /* synthetic */ Object L$0;
                /* synthetic */ Object L$1;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            PipelineContext $this$intercept = (PipelineContext)this.L$0;
                            Object body2 = this.L$1;
                            PipelineContext $this$call$iv = $this$intercept;
                            boolean $i$f$getCall = false;
                            if (ApplicationCallKt.isHandled((ApplicationCall)$this$call$iv.getContext())) {
                                return Unit.INSTANCE;
                            }
                            if (!(body2 instanceof OutgoingContent)) {
                                throw new IllegalArgumentException("Response pipeline couldn't transform '" + Reflection.getOrCreateKotlinClass(body2.getClass()) + "' to the OutgoingContent");
                            }
                            PipelineContext $this$call$iv2 = $this$intercept;
                            boolean $i$f$getCall2 = false;
                            ApplicationResponse applicationResponse = ((ApplicationCall)$this$call$iv2.getContext()).getResponse();
                            BaseApplicationResponse baseApplicationResponse = applicationResponse instanceof BaseApplicationResponse ? (BaseApplicationResponse)applicationResponse : null;
                            if (baseApplicationResponse == null) {
                                PipelineContext $this$call$iv3 = $this$intercept;
                                boolean $i$f$getCall3 = false;
                                baseApplicationResponse = ((ApplicationCall)$this$call$iv3.getContext()).getAttributes().get(BaseApplicationResponse.Companion.getEngineResponseAttributeKey());
                            }
                            BaseApplicationResponse response2 = baseApplicationResponse;
                            this.L$0 = null;
                            this.label = 1;
                            Object object3 = response2.respondOutgoingContent((OutgoingContent)body2, this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @Nullable
                public final Object invoke(@NotNull PipelineContext<Object, ApplicationCall> p1, @NotNull Object p2, @Nullable Continuation<? super Unit> p3) {
                    Function3<PipelineContext<Object, ApplicationCall>, Object, Continuation<? super Unit>, Object> function3 = new /* invalid duplicate definition of identical inner class */;
                    function3.L$0 = p1;
                    function3.L$1 = p2;
                    return function3.invokeSuspend(Unit.INSTANCE);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

