/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.server.netty;

import io.ktor.http.HttpHeaders;
import io.ktor.http.HttpStatusCode;
import io.ktor.http.content.OutgoingContent;
import io.ktor.server.engine.BaseApplicationResponse;
import io.ktor.server.netty.NettyApplicationCall;
import io.ktor.server.netty.NettyApplicationResponse;
import io.ktor.utils.io.ByteChannel;
import io.ktor.utils.io.ByteChannelCtorKt;
import io.ktor.utils.io.ByteChannelKt;
import io.ktor.utils.io.ByteReadChannel;
import io.ktor.utils.io.ByteWriteChannel;
import io.ktor.utils.io.ByteWriteChannelKt;
import io.ktor.utils.io.ClosedWriteChannelException;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u0000 ?2\u00020\u0001:\u0001?B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0006\u0010%\u001a\u00020&J\r\u0010'\u001a\u00020&H\u0000\u00a2\u0006\u0002\b(J\r\u0010)\u001a\u00020&H\u0000\u00a2\u0006\u0002\b*J\u000f\u0010+\u001a\u0004\u0018\u00010\u0015H\u0010\u00a2\u0006\u0002\b,J\u0019\u0010-\u001a\u00020&2\u0006\u0010.\u001a\u00020/H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00100J\u0019\u00101\u001a\u00020&2\u0006\u00102\u001a\u000203H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00104J\u0019\u00105\u001a\u00020&2\u0006\u00102\u001a\u000206H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00107J\u0011\u0010\u000e\u001a\u000208H\u0094@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u001b2\u0006\u0010;\u001a\u00020\u001bH$J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010:\u001a\u00020\u001b2\u0006\u0010<\u001a\u00020/H\u0014J\u001f\u0010=\u001a\u00020&2\b\b\u0002\u0010:\u001a\u00020\u001b2\u0006\u00102\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b>R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0006\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\u00020\u000fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001a\u001a\u00020\u001bX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010\b\u001a\u00020\u0007X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\r\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006@"}, d2={"Lio/ktor/server/netty/NettyApplicationResponse;", "Lio/ktor/server/engine/BaseApplicationResponse;", "call", "Lio/ktor/server/netty/NettyApplicationCall;", "context", "Lio/netty/channel/ChannelHandlerContext;", "engineContext", "Lkotlin/coroutines/CoroutineContext;", "userContext", "(Lio/ktor/server/netty/NettyApplicationCall;Lio/netty/channel/ChannelHandlerContext;Lkotlin/coroutines/CoroutineContext;Lkotlin/coroutines/CoroutineContext;)V", "getContext", "()Lio/netty/channel/ChannelHandlerContext;", "getEngineContext", "()Lkotlin/coroutines/CoroutineContext;", "responseChannel", "Lio/ktor/utils/io/ByteReadChannel;", "getResponseChannel$ktor_server_netty", "()Lio/ktor/utils/io/ByteReadChannel;", "setResponseChannel$ktor_server_netty", "(Lio/ktor/utils/io/ByteReadChannel;)V", "responseMessage", "", "getResponseMessage", "()Ljava/lang/Object;", "setResponseMessage", "(Ljava/lang/Object;)V", "responseMessageSent", "", "getResponseMessageSent", "()Z", "setResponseMessageSent", "(Z)V", "responseReady", "Lio/netty/channel/ChannelPromise;", "getResponseReady$ktor_server_netty", "()Lio/netty/channel/ChannelPromise;", "getUserContext", "cancel", "", "close", "close$ktor_server_netty", "ensureResponseSent", "ensureResponseSent$ktor_server_netty", "prepareTrailerMessage", "prepareTrailerMessage$ktor_server_netty", "respondFromBytes", "bytes", "", "([BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondNoContent", "content", "Lio/ktor/http/content/OutgoingContent$NoContent;", "(Lio/ktor/http/content/OutgoingContent$NoContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "respondOutgoingContent", "Lio/ktor/http/content/OutgoingContent;", "(Lio/ktor/http/content/OutgoingContent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Lio/ktor/utils/io/ByteWriteChannel;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "chunked", "last", "data", "sendResponse", "sendResponse$ktor_server_netty", "Companion", "ktor-server-netty"})
public abstract class NettyApplicationResponse
extends BaseApplicationResponse {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final ChannelHandlerContext context;
    @NotNull
    private final CoroutineContext engineContext;
    @NotNull
    private final CoroutineContext userContext;
    @NotNull
    private final ChannelPromise responseReady;
    public Object responseMessage;
    private volatile boolean responseMessageSent;
    @NotNull
    private ByteReadChannel responseChannel;
    @NotNull
    private static final byte[] EmptyByteArray;
    @NotNull
    private static final HttpResponseStatus[] responseStatusCache;

    public NettyApplicationResponse(@NotNull NettyApplicationCall call, @NotNull ChannelHandlerContext context, @NotNull CoroutineContext engineContext, @NotNull CoroutineContext userContext) {
        Intrinsics.checkNotNullParameter(call, "call");
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(engineContext, "engineContext");
        Intrinsics.checkNotNullParameter(userContext, "userContext");
        super(call);
        this.context = context;
        this.engineContext = engineContext;
        this.userContext = userContext;
        ChannelPromise channelPromise = this.context.newPromise();
        Intrinsics.checkNotNullExpressionValue(channelPromise, "context.newPromise()");
        this.responseReady = channelPromise;
        this.responseChannel = ByteReadChannel.Companion.getEmpty();
    }

    @NotNull
    protected final ChannelHandlerContext getContext() {
        return this.context;
    }

    @NotNull
    protected final CoroutineContext getEngineContext() {
        return this.engineContext;
    }

    @NotNull
    protected final CoroutineContext getUserContext() {
        return this.userContext;
    }

    @NotNull
    public final ChannelPromise getResponseReady$ktor_server_netty() {
        return this.responseReady;
    }

    @NotNull
    public final Object getResponseMessage() {
        Object object = this.responseMessage;
        if (object != null) {
            return object;
        }
        Intrinsics.throwUninitializedPropertyAccessException("responseMessage");
        return Unit.INSTANCE;
    }

    public final void setResponseMessage(@NotNull Object object) {
        Intrinsics.checkNotNullParameter(object, "<set-?>");
        this.responseMessage = object;
    }

    protected final boolean getResponseMessageSent() {
        return this.responseMessageSent;
    }

    protected final void setResponseMessageSent(boolean bl) {
        this.responseMessageSent = bl;
    }

    @NotNull
    public final ByteReadChannel getResponseChannel$ktor_server_netty() {
        return this.responseChannel;
    }

    public final void setResponseChannel$ktor_server_netty(@NotNull ByteReadChannel byteReadChannel) {
        Intrinsics.checkNotNullParameter(byteReadChannel, "<set-?>");
        this.responseChannel = byteReadChannel;
    }

    @Override
    @Nullable
    protected Object respondOutgoingContent(@NotNull OutgoingContent content2, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondOutgoingContent$suspendImpl(this, content2, $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    static /* synthetic */ Object respondOutgoingContent$suspendImpl(NettyApplicationResponse var0, OutgoingContent var1_1, Continuation var2_2) {
        if (!(var2_2 instanceof respondOutgoingContent.1)) ** GOTO lbl-1000
        var7_3 = var2_2;
        if ((var7_3.label & -2147483648) != 0) {
            var7_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var0, var2_2){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ NettyApplicationResponse this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return NettyApplicationResponse.respondOutgoingContent$suspendImpl(this.this$0, null, this);
                }
            };
        }
        $result = $continuation.result;
        var8_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure($result);
                $continuation.L$0 = this;
                $continuation.label = 1;
                v0 = super.respondOutgoingContent((OutgoingContent)content, $continuation);
                ** if (v0 != var8_5) goto lbl19
lbl18:
                // 1 sources

                return var8_5;
lbl19:
                // 1 sources

                ** GOTO lbl26
            }
            case 1: {
                this = (NettyApplicationResponse)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure($result);
                    v0 = $result;
                }
                catch (Throwable t) {
                    try {
                        var5_12 = this.responseChannel;
                        v2 = out = var5_12 instanceof ByteWriteChannel != false ? (ByteWriteChannel)var5_12 : null;
                        if (v2 != null) {
                            Boxing.boxBoolean(v2.close(t));
                        }
                        throw t;
                    }
                    catch (Throwable var3_11) {
                        var5_13 = this.responseChannel;
                        v3 = out = var5_13 instanceof ByteWriteChannel != false ? (ByteWriteChannel)var5_13 : null;
                        if (v3 != null) {
                            Boxing.boxBoolean(ByteWriteChannelKt.close(v3));
                        }
                        throw var3_11;
                    }
                }
lbl26:
                // 2 sources

                v1 = out = (var4_6 = this.responseChannel) instanceof ByteWriteChannel != false ? (ByteWriteChannel)var4_6 : null;
                if (v1 != null) {
                    Boxing.boxBoolean(ByteWriteChannelKt.close(v1));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Override
    @Nullable
    protected Object respondFromBytes(@NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondFromBytes$suspendImpl(this, bytes, $completion);
    }

    static /* synthetic */ Object respondFromBytes$suspendImpl(NettyApplicationResponse this_, byte[] bytes, Continuation $completion) {
        boolean chunked = Intrinsics.areEqual(this_.getHeaders().get(HttpHeaders.INSTANCE.getTransferEncoding()), "chunked");
        if (this_.responseMessageSent) {
            return Unit.INSTANCE;
        }
        Object message2 = this_.responseMessage(chunked, bytes);
        this_.responseChannel = message2 instanceof LastHttpContent ? ByteReadChannel.Companion.getEmpty() : ByteChannelCtorKt.ByteReadChannel(bytes);
        this_.setResponseMessage(message2);
        this_.responseReady.setSuccess();
        this_.responseMessageSent = true;
        return Unit.INSTANCE;
    }

    @Override
    @Nullable
    protected Object responseChannel(@NotNull Continuation<? super ByteWriteChannel> $completion) {
        return NettyApplicationResponse.responseChannel$suspendImpl(this, $completion);
    }

    static /* synthetic */ Object responseChannel$suspendImpl(NettyApplicationResponse this_, Continuation $completion) {
        ByteChannel channel2 = ByteChannelKt.ByteChannel$default(false, 1, null);
        boolean chunked = Intrinsics.areEqual(this_.getHeaders().get(HttpHeaders.INSTANCE.getTransferEncoding()), "chunked");
        this_.sendResponse$ktor_server_netty(chunked, channel2);
        return channel2;
    }

    @Override
    @Nullable
    protected Object respondNoContent(@NotNull OutgoingContent.NoContent content2, @NotNull Continuation<? super Unit> $completion) {
        return NettyApplicationResponse.respondNoContent$suspendImpl(this, content2, $completion);
    }

    static /* synthetic */ Object respondNoContent$suspendImpl(NettyApplicationResponse this_, OutgoingContent.NoContent content2, Continuation $completion) {
        Object object = this_.respondFromBytes(EmptyByteArray, $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    protected abstract Object responseMessage(boolean var1, boolean var2);

    @NotNull
    protected Object responseMessage(boolean chunked, @NotNull byte[] data2) {
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.responseMessage(chunked, true);
    }

    @Nullable
    public Object prepareTrailerMessage$ktor_server_netty() {
        return null;
    }

    public final void sendResponse$ktor_server_netty(boolean chunked, @NotNull ByteReadChannel content2) {
        Intrinsics.checkNotNullParameter(content2, "content");
        if (this.responseMessageSent) {
            return;
        }
        this.responseChannel = content2;
        this.setResponseMessage(content2.isClosedForRead() ? this.responseMessage(false, EmptyByteArray) : this.responseMessage(chunked, false));
        this.responseReady.setSuccess();
        this.responseMessageSent = true;
    }

    public static /* synthetic */ void sendResponse$ktor_server_netty$default(NettyApplicationResponse nettyApplicationResponse, boolean bl, ByteReadChannel byteReadChannel, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: sendResponse");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        nettyApplicationResponse.sendResponse$ktor_server_netty(bl, byteReadChannel);
    }

    public final void ensureResponseSent$ktor_server_netty() {
        NettyApplicationResponse.sendResponse$ktor_server_netty$default(this, false, ByteReadChannel.Companion.getEmpty(), 1, null);
    }

    public final void close$ktor_server_netty() {
        ByteReadChannel existingChannel = this.responseChannel;
        if (existingChannel instanceof ByteWriteChannel) {
            ((ByteWriteChannel)((Object)existingChannel)).close(new ClosedWriteChannelException("Application response has been closed"));
            this.responseChannel = ByteReadChannel.Companion.getEmpty();
        }
        this.ensureResponseSent$ktor_server_netty();
    }

    public final void cancel() {
        if (!this.responseMessageSent) {
            this.responseChannel = ByteReadChannel.Companion.getEmpty();
            this.responseReady.setFailure(new CancellationException("Response was cancelled"));
            this.responseMessageSent = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$associateByTo$iv$iv;
        Companion = new Companion(null);
        EmptyByteArray = new byte[0];
        Iterable $this$associateBy$iv = HttpStatusCode.Companion.getAllStatusCodes();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            HttpStatusCode httpStatusCode = (HttpStatusCode)element$iv$iv;
            Map map2 = destination$iv$iv;
            boolean bl = false;
            map2.put(it.getValue(), element$iv$iv);
        }
        Map codes = destination$iv$iv;
        boolean bl = false;
        HttpResponseStatus[] httpResponseStatusArray = new HttpResponseStatus[1000];
        for (int i = 0; i < 1000; ++i) {
            HttpResponseStatus httpResponseStatus;
            int n = i;
            if (codes.keySet().contains(n)) {
                Object v = codes.get(n);
                Intrinsics.checkNotNull(v);
                httpResponseStatus = new HttpResponseStatus(n, ((HttpStatusCode)v).getDescription());
            } else {
                httpResponseStatus = null;
            }
            httpResponseStatusArray[n] = httpResponseStatus;
        }
        responseStatusCache = httpResponseStatusArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000b"}, d2={"Lio/ktor/server/netty/NettyApplicationResponse$Companion;", "", "()V", "EmptyByteArray", "", "responseStatusCache", "", "Lio/netty/handler/codec/http/HttpResponseStatus;", "getResponseStatusCache", "()[Lio/netty/handler/codec/http/HttpResponseStatus;", "[Lio/netty/handler/codec/http/HttpResponseStatus;", "ktor-server-netty"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final HttpResponseStatus[] getResponseStatusCache() {
            return responseStatusCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

